/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.api.ParsedCertificate;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureCertNotFoundException;
import es.caib.signatura.api.SignatureException;
import es.caib.signatura.api.SignaturePrivKeyException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.impl.LocalSignerProviderInterface;
import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.impl.ValidadorProxy;
import es.caib.signatura.provider.impl.common.ParsedCertificateImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public abstract class AbstractSigner
implements LocalSignerProviderInterface {
    protected String providerName = "";
    protected static Vector notValidCerts = new Vector();

    public AbstractSigner() throws SignatureException {
        try {
            this.initialize();
        }
        catch (SignatureProviderException e) {
            if (this.providerName.equals("BC") && e.getMessage().contains(".keystore")) {
                throw new SignatureException(e.getMessage(), e.getCause());
            }
            e.printStackTrace();
            throw new SignatureException("No se pudo cargar el provider " + this.providerName);
        }
    }

    protected String getAliasFromCN(String cn, boolean recognized) throws SignatureException {
        String[] aliases = this.getAliases();
        ParsedCertificateImpl[] parsedCerts = this.getParsedCertificates(aliases);
        ParsedCertificateImpl[] filteredCerts = this.filter(parsedCerts, recognized);
        for (int i = 0; i < filteredCerts.length; ++i) {
            if (cn == null || !cn.equals(filteredCerts[i].getCommonName())) continue;
            return filteredCerts[i].getAlias();
        }
        throw new SignatureException(this.providerName + "No se ha encontrado el alias para el certificado " + cn);
    }

    protected ParsedCertificateImpl[] filter(ParsedCertificateImpl[] parsedCerts, boolean needsRecognized) {
        Vector<ParsedCertificateImpl> temp = new Vector<ParsedCertificateImpl>();
        Vector out = new Vector();
        for (int i = 0; i < parsedCerts.length; ++i) {
            if (!this.filterValidity(parsedCerts[i]) || !this.filterUsage(parsedCerts[i], needsRecognized)) continue;
            if (this.isInSecureDevice(parsedCerts[i].getAlias())) {
                temp.add(parsedCerts[i]);
                continue;
            }
            if (needsRecognized) continue;
            temp.add(parsedCerts[i]);
        }
        out = this.filterDuplicated(temp);
        return out.toArray(new ParsedCertificateImpl[out.size()]);
    }

    protected boolean filterValidity(ParsedCertificateImpl parsed) {
        switch (parsed.getIsInValidPeriod()) {
            case 0: {
                return true;
            }
            case -1: {
                System.out.println(this.providerName + " Certificat " + parsed.getCommonName() + " rebutjat, el certificat encara no \u00e9s v\u00e0lid.");
                notValidCerts.add(parsed);
                return false;
            }
            case 1: {
                System.out.println(this.providerName + " Certificat " + parsed.getCommonName() + " rebutjat, el certificat ha caducat.");
                notValidCerts.add(parsed);
                return false;
            }
        }
        System.out.println(this.providerName + " Certificat " + parsed.getCommonName() + " rebutjat. Motiu:" + parsed.getIsInValidPeriod());
        notValidCerts.add(parsed);
        return false;
    }

    protected boolean filterUsage(ParsedCertificateImpl parsed, boolean needsRecognized) {
        ValidadorProxy validador = new ValidadorProxy();
        if (parsed.isRecognized() && needsRecognized || parsed.isAdvanced() && !needsRecognized) {
            if (validador.isEnDesenvolupament()) {
                return true;
            }
            return !parsed.isTest();
        }
        System.out.println(this.providerName + " Certificat " + parsed.getCommonName() + " rebutjat, buscant " + (needsRecognized ? "reconeguts" : "avan\u00e7ats") + " i el certificat no ho es.");
        return false;
    }

    protected Vector filterDuplicated(Vector parsedCerts) {
        if (SigDebug.isActive()) {
            SigDebug.write((String)(this.providerName + " Filtrando certificados con Common Name duplicado..."));
        }
        HashMap<String, ParsedCertificateImpl> map = new HashMap<String, ParsedCertificateImpl>();
        int vectorSize = parsedCerts.size();
        for (int i = 0; i < vectorSize; ++i) {
            ParsedCertificateImpl parsed = (ParsedCertificateImpl)parsedCerts.elementAt(i);
            if (SigDebug.isActive()) {
                SigDebug.write((String)(this.providerName + " Alias: " + parsed.getAlias()));
                SigDebug.write((String)(this.providerName + " Emisi\u00f3n: " + parsed.getValidSince().getTime()));
            }
            if (!map.containsKey(parsed.getCommonName())) {
                map.put(parsed.getCommonName(), parsed);
                if (!SigDebug.isActive()) continue;
                SigDebug.write((String)(this.providerName + " Almacenado certificado con alias " + parsed.getAlias() + " " + "(a\u00fan no exist\u00eda ninguna entrada para el Common Name '" + parsed.getCommonName() + "')"));
                continue;
            }
            ParsedCertificateImpl storedParsed = (ParsedCertificateImpl)map.get(parsed.getCommonName());
            if (SigDebug.isActive()) {
                SigDebug.write((String)(this.providerName + " Stored Alias: " + storedParsed.getAlias()));
                SigDebug.write((String)(this.providerName + " Stored Emisi\u00f3n: " + storedParsed.getValidSince().getTime()));
            }
            if (parsed.getValidSince().getTime() > storedParsed.getValidSince().getTime()) {
                if (SigDebug.isActive()) {
                    SigDebug.write((String)(this.providerName + " " + parsed.getAlias() + " tiene una fecha de emisi\u00f3n m\u00e1s reciente que " + storedParsed.getAlias()));
                    SigDebug.write((String)(this.providerName + " Actualizando certificado con Common Name '" + parsed.getCommonName() + "'"));
                }
                map.put(parsed.getCommonName(), parsed);
                continue;
            }
            if (!SigDebug.isActive()) continue;
            SigDebug.write((String)(this.providerName + " " + parsed.getAlias() + " tiene una fecha de emisi\u00f3n menor o igual que " + storedParsed.getAlias()));
            SigDebug.write((String)(this.providerName + " DESCARTADO..."));
        }
        parsedCerts.clear();
        Set keySet = map.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            ParsedCertificateImpl parsed = (ParsedCertificateImpl)map.get(key);
            parsedCerts.add(parsed);
        }
        if (SigDebug.isActive()) {
            SigDebug.write((String)(this.providerName + " Filtrado completo."));
        }
        return parsedCerts;
    }

    protected ParsedCertificateImpl[] getParsedCertificates(String[] aliases) throws SignatureCertNotFoundException, SignaturePrivKeyException {
        Vector<ParsedCertificateImpl> out = new Vector<ParsedCertificateImpl>();
        for (int i = 0; i < aliases.length; ++i) {
            try {
                X509Certificate[] chain = this.getCertChainFromAlias(aliases[i]);
                if (chain == null || chain.length <= 0) continue;
                ParsedCertificateImpl parsed = new ParsedCertificateImpl(chain, this.isInSecureDevice(aliases[i]), aliases[i]);
                out.add(parsed);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SignatureCertNotFoundException(e);
            }
        }
        return out.toArray(new ParsedCertificateImpl[out.size()]);
    }

    protected abstract boolean isInSecureDevice(String var1);

    protected abstract X509Certificate[] getCertChainFromAlias(String var1) throws SignatureProviderException;

    protected abstract String[] getAliases() throws SignatureProviderException;

    protected abstract void initialize() throws SignatureProviderException;

    protected String getProviderName() {
        return this.providerName;
    }

    protected void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public ParsedCertificate[] getCertList(boolean recognized) throws SignatureCertNotFoundException, SignaturePrivKeyException {
        String[] aliases;
        try {
            aliases = this.getAliases();
        }
        catch (SignatureProviderException e) {
            throw new SignatureCertNotFoundException(e.getMessage(), e.getCause());
        }
        ParsedCertificateImpl[] parsedCerts = this.getParsedCertificates(aliases);
        ParsedCertificate[] filteredCerts = this.filter(parsedCerts, recognized);
        return filteredCerts;
    }

    public abstract Date getCurrentDate(String var1, String var2, boolean var3) throws SignatureTimestampException, SignatureException, IOException;

    public abstract String getVersion();

    public abstract Signature sign(InputStream var1, String var2, String var3, String var4, boolean var5, boolean var6, boolean var7) throws IOException, SignatureException;

    public abstract void signPDF(InputStream var1, OutputStream var2, String var3, String var4, String var5, boolean var6, String var7, int var8, boolean var9) throws IOException, SignatureException;

    public abstract void signPDF(InputStream var1, OutputStream var2, String var3, String var4, String var5, boolean var6, String var7, int var8, float var9, float var10, float var11, float var12, float var13, boolean var14) throws IOException, SignatureException;

    public abstract void certifyDigitalCopy(InputStream var1, OutputStream var2, String var3, String var4, String var5, boolean var6, String var7, String var8, float var9, float var10, float var11, SignaturaProperties var12) throws IOException, SignatureException;
}

