/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.provider.impl.common.CMSSignatureImpl;
import es.caib.signatura.provider.impl.common.SHA1Util;
import es.caib.signatura.provider.impl.common.TimeStampManager;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class CMSSignatureImplv2
extends CMSSignatureImpl {
    protected boolean verifyTimestamp(TimeStampToken tst, SignerInformation si, byte[] documentDigest) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean timeStampVerified;
        block5: {
            timeStampVerified = false;
            try {
                Collection<? extends Certificate> certificates;
                CertStore certs;
                byte[] signatureDigest = SHA1Util.digest(si.getSignature());
                if (tst == null || (certs = tst.getCertificatesAndCRLs("Collection", "BC")) == null || (certificates = certs.getCertificates((CertSelector)tst.getSID())) == null || certificates.size() <= 0) break block5;
                X509Certificate timeStampCertificate = this.getTimeStampCertificates(certificates)[0];
                try {
                    tst.validate(timeStampCertificate, "BC");
                    timeStampVerified = true;
                    TimeStampTokenInfo tsTokenInfo = tst.getTimeStampInfo();
                    byte[] hashTimeStamp = tsTokenInfo.getMessageImprintDigest();
                    timeStampVerified = timeStampVerified && hashTimeStamp.length == signatureDigest.length;
                    for (int i = 0; i < signatureDigest.length && timeStampVerified; ++i) {
                        timeStampVerified = timeStampVerified && hashTimeStamp[i] == signatureDigest[i];
                    }
                }
                catch (Exception e) {
                    throw new SignatureVerifyException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw new SignatureVerifyException((Throwable)e);
            }
        }
        return timeStampVerified;
    }

    protected CMSSignedData addTimeStamp(CMSSignedData signedData) throws SignatureTimestampException, IOException, TSPException, CMSException, NoSuchAlgorithmException, NoSuchProviderException {
        TimeStampManager tsm = new TimeStampManager();
        return tsm.addTimestamp(this.getCert(), signedData);
    }
}

