/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.api.Signature;
import es.caib.signatura.impl.RawSignature;
import es.caib.signatura.impl.SMIMEGenerator;
import es.caib.signatura.impl.SMIMEInputStream;
import es.caib.signatura.impl.SMIMEPkcs7InputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public class CopyOfSMIMEGeneratorImpl
implements SMIMEGenerator {
    public InputStream generateSMIME(InputStream document, Signature signature) throws IOException {
        SMIMEInputStream in;
        if (signature instanceof RawSignature) {
            byte[] pkcs7 = CopyOfSMIMEGeneratorImpl.encapsulateData(signature.getPkcs7(), document);
            in = new SMIMEPkcs7InputStream(pkcs7);
        } else {
            in = new SMIMEInputStream(signature, document);
        }
        return in;
    }

    private static byte[] encapsulateData(byte[] pkcs7, InputStream data) throws IOException {
        try {
            CMSSignedData cmsSignedData = new CMSSignedData(pkcs7);
            CMSSignedDataGenerator cmsSignedDataGenerator = new CMSSignedDataGenerator();
            cmsSignedDataGenerator.addSigners(cmsSignedData.getSignerInfos());
            cmsSignedDataGenerator.addCertificatesAndCRLs(cmsSignedData.getCertificatesAndCRLs("Collection", "BC"));
            CopyOfSMIMEGeneratorImpl copyOfSMIMEGeneratorImpl = new CopyOfSMIMEGeneratorImpl();
            copyOfSMIMEGeneratorImpl.getClass();
            ProcessableInputStream cmsProcessable = copyOfSMIMEGeneratorImpl.new ProcessableInputStream(data);
            cmsSignedData = cmsSignedDataGenerator.generate((CMSProcessable)cmsProcessable, true, "BC");
            return cmsSignedData.getEncoded();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    class ProcessableInputStream
    implements CMSProcessable {
        private DigestInputStream in;
        MessageDigest digester = MessageDigest.getInstance("SHA-1", "BC");
        byte[] digestResult;

        public void write(OutputStream out) throws IOException, CMSException {
            byte[] b = new byte[8192];
            int read = this.in.read(b);
            while (read > 0) {
                out.write(b, 0, read);
                read = this.in.read(b);
            }
            out.close();
            this.in.close();
            this.digestResult = this.digester.digest();
        }

        public Object getContent() {
            return this.in;
        }

        public ProcessableInputStream(InputStream datain) throws NoSuchAlgorithmException, NoSuchProviderException {
            this.in = new DigestInputStream(datain, this.digester);
            this.digestResult = null;
        }

        public byte[] getDigest() {
            return this.digestResult;
        }
    }
}

