/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.provider.impl.common.InternalParsedCertificate;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class DefaultParsedCertificateImpl
implements InternalParsedCertificate {
    X509CertificateStructure certificate;
    String nif;
    String fullName;
    String productor;
    String intranetUser;
    String policy;
    String givenName;
    String surName;
    boolean proxy = false;
    String nifResponsable;
    boolean personaFisica;
    boolean personaJuridica;
    private SignaturaProperties properties = new SignaturaProperties();
    private static DERObjectIdentifier NIFOID = new DERObjectIdentifier("1.3.6.1.4.1.18838.1.1");
    private static DERObjectIdentifier productorOID = new DERObjectIdentifier("1.3.6.1.4.1.22896.1.1");
    private static DERObjectIdentifier proxyOID = new DERObjectIdentifier("1.3.6.1.4.1.22896.1.2");

    public DefaultParsedCertificateImpl(X509Certificate[] cert, boolean securedevice) throws CertificateEncodingException, IOException {
        this.init(cert, securedevice);
    }

    public String getName() {
        if (this.getFullName() != null) {
            return this.getFullName();
        }
        return this.certificate.getSubject().toString();
    }

    public String getNif() {
        return this.nif;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultParsedCertificateImpl) {
            DefaultParsedCertificateImpl other = (DefaultParsedCertificateImpl)obj;
            if (this.certificate != null && other.certificate != null) {
                return this.certificate.equals((Object)other.certificate);
            }
            if (this.intranetUser != null && other.intranetUser != null) {
                return this.intranetUser.equals(other.intranetUser);
            }
        }
        return false;
    }

    public String toString() {
        String s = this.certificate != null ? this.certificate.getSubject().toString() + "(" + this.certificate.getIssuer().toString() + ")" : this.intranetUser;
        s = s + " FullName:" + this.fullName + " NIF:" + this.nif;
        if (this.nifResponsable != null) {
            s = s + " NIF Responsable:" + this.nifResponsable;
        }
        if (this.productor != null) {
            s = s + " N\u00famero productor:" + this.productor;
        }
        if (this.proxy) {
            s = s + " PROXY:YES";
        }
        return s;
    }

    public String getNifResponsable() {
        return this.nifResponsable;
    }

    public boolean isPersonaFisica() {
        return this.personaFisica;
    }

    public boolean isPersonaJuridica() {
        return this.personaJuridica;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getCommonName() {
        return this.fullName;
    }

    public String getProductor() {
        return this.productor;
    }

    public String getIntranetUser() {
        if (this.intranetUser != null) {
            return this.intranetUser;
        }
        if (this.productor == null) {
            return null;
        }
        String user = this.productor;
        while (user.length() < 5) {
            user = "0" + user;
        }
        user = "u" + user;
        return user;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public String getPolicy() {
        return this.policy;
    }

    private void processName(String cn) {
        if (cn != null && cn.startsWith("NOMBRE ")) {
            int i = cn.indexOf(" - ");
            if (i > 0 && cn.substring(i).startsWith(" - NIF ")) {
                this.nif = cn.substring(i + 7);
                this.fullName = cn.substring(7, i);
                this.personaFisica = true;
                this.personaJuridica = false;
            }
        } else if (cn != null && cn.startsWith("ENTIDAD ")) {
            this.personaFisica = false;
            this.personaJuridica = true;
            int i = cn.indexOf(" - ");
            if (i > 0 && cn.substring(i).startsWith(" - CIF ")) {
                int j = cn.indexOf(" - ", i + 7);
                int l = cn.indexOf(" - NOMBRE ", i + 7);
                int k = cn.indexOf(" - NIF ", i + 7);
                if (l > 0) {
                    this.givenName = cn.substring(l + 10 + cn.substring(l + 10, k).lastIndexOf(" ") + 1, k);
                    this.surName = cn.substring(l + 10, l + 11 + cn.substring(l + 10, k).lastIndexOf(" ") - 1);
                }
                if (j > 0 && k > 0) {
                    this.nif = cn.substring(i + 7, j);
                    this.fullName = cn.substring(8, i);
                    this.nifResponsable = cn.substring(k + 7);
                }
            }
        } else if (cn != null && cn.startsWith("DESCRIPCION ")) {
            int k;
            this.personaFisica = false;
            this.personaJuridica = false;
            int i = cn.lastIndexOf(" - ");
            if (i > 0 && cn.substring(i).startsWith(" - CIF ") && (k = cn.indexOf(" - CIF ")) > 0) {
                this.nif = cn.substring(k + 7);
                this.fullName = cn.substring(12, k).replaceAll(" - ENTIDAD ", " - ");
            }
        } else {
            this.fullName = cn;
        }
    }

    private void init(X509Certificate[] cert, boolean securedevice) throws IOException, CertificateEncodingException {
        byte[] b = cert[0].getEncoded();
        ASN1InputStream asn1is = new ASN1InputStream(b);
        DERObject obj = asn1is.readObject();
        this.certificate = new X509CertificateStructure((ASN1Sequence)obj);
        X509Name name = this.certificate.getSubject();
        this.personaFisica = false;
        this.personaJuridica = false;
        Vector v = name.getOIDs();
        Vector value = name.getValues();
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i).equals(X509Name.CN)) {
                this.processName(value.get(i).toString());
            }
            if (v.get(i).equals(X509Name.SURNAME)) {
                this.surName = value.get(i).toString();
            }
            if (v.get(i).equals(X509Name.GIVENNAME)) {
                this.givenName = value.get(i).toString();
            }
            if (v.get(i).equals(X509Name.SN)) {
                this.nif = value.get(i).toString();
                if (!this.personaJuridica) {
                    this.personaFisica = true;
                }
            }
            if (!v.get(i).equals(NIFOID)) continue;
            this.nifResponsable = value.get(i).toString();
            this.personaFisica = false;
            this.personaJuridica = true;
        }
        TBSCertificateStructure tbs = this.certificate.getTBSCertificate();
        X509Extensions exts = tbs.getExtensions();
        if (SigDebug.isActive()) {
            SigDebug.write((String)("ParsedCertificateImp.init: extensionss null ?" + (exts == null ? "si" : "no")));
        }
        if (exts != null) {
            X509Extension altName = exts.getExtension(X509Extensions.SubjectAlternativeName);
            if (altName != null) {
                asn1is = new ASN1InputStream(altName.getValue().getOctets());
                ASN1Sequence asn1seq = (ASN1Sequence)asn1is.readObject();
                GeneralNames gnames = new GeneralNames(asn1seq);
                GeneralName[] gname = gnames.getNames();
                for (int i = 0; i < gname.length; ++i) {
                    if (gname[i].getTagNo() != 0) continue;
                    ASN1Sequence seq = (ASN1Sequence)gname[i].getName();
                    if (seq.getObjectAt(0).equals(productorOID)) {
                        this.productor = DERUTF8String.getInstance((Object)seq.getObjectAt(1)).getString();
                    }
                    if (!seq.getObjectAt(0).equals(proxyOID)) continue;
                    this.proxy = DERUTF8String.getInstance((Object)seq.getObjectAt(1)).getString().equals("YES");
                }
            }
            if (SigDebug.isActive()) {
                SigDebug.write((String)"ParsedCertificateImpl.init: calculant extensions CertificatePolicies");
            }
            X509Extension polext = exts.getExtension(X509Extensions.CertificatePolicies);
            if (SigDebug.isActive()) {
                SigDebug.write((String)("ParsedCertificateImpl.init: extensions CertificatePolicies null ?" + (polext == null ? "si" : "no")));
            }
            if (polext != null) {
                asn1is = new ASN1InputStream(polext.getValue().getOctets());
                ASN1Sequence asn1seq = (ASN1Sequence)asn1is.readObject();
                Enumeration polInfo = asn1seq.getObjects();
                while (polInfo.hasMoreElements()) {
                    ASN1Sequence seq2 = (ASN1Sequence)polInfo.nextElement();
                    PolicyInformation info = new PolicyInformation(seq2);
                    this.processPolicy(info.getPolicyIdentifier().getId(), exts, securedevice);
                }
            } else {
                this.processPolicy("", exts, securedevice);
            }
        }
    }

    private String getCACommonName(X509Certificate cert) throws IOException, CertificateEncodingException {
        String ou = "";
        byte[] b = cert.getEncoded();
        ASN1InputStream asn1is = new ASN1InputStream(b);
        DERObject obj = asn1is.readObject();
        this.certificate = new X509CertificateStructure((ASN1Sequence)obj);
        asn1is.close();
        X509Name name = this.certificate.getIssuer();
        Vector v = name.getOIDs();
        Vector value = name.getValues();
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i).equals(X509Name.CN)) {
                if (SigDebug.isActive()) {
                    SigDebug.write((String)("getCACommonName(): " + value.get(i).toString()));
                }
                return value.get(i).toString();
            }
            if (!v.get(i).equals(X509Name.OU)) continue;
            ou = value.get(i).toString();
        }
        if (SigDebug.isActive()) {
            SigDebug.write((String)("getCACommonName(): " + ou));
        }
        return ou;
    }

    private void processPolicy(String id, X509Extensions exts, boolean securedevice) {
    }

    private boolean isIncluded(String id, String[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (!id.equals(policies[i])) continue;
            return true;
        }
        return false;
    }

    public Date getValidSince() {
        return this.certificate.getEndDate().getDate();
    }

    public Date getValidUntil() {
        return this.certificate.getStartDate().getDate();
    }
}

