/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.impl.SMIMESignatureProxy;
import es.caib.signatura.provider.impl.common.CertStoreCRLSelector;
import es.caib.signatura.provider.impl.common.SMIMEImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.x509.NoSuchStoreException;

public class DetachedSMIME
extends SMIMEImpl {
    public void parse(MimeMessage mime) throws MessagingException, IOException, SignatureDataException, NoSuchProviderException, NoSuchAlgorithmException, CertStoreException, CMSException, NoSuchStoreException, InvalidAlgorithmParameterException {
        if (mime.isMimeType(MULTIPART_SIGNED)) {
            Multipart multipart = (Multipart)mime.getContent();
            for (int ip = 0; ip < multipart.getCount(); ++ip) {
                BodyPart part = multipart.getBodyPart(ip);
                if (!part.isMimeType(DETACHED_SIGNATURE)) {
                    this.contentType = part.getContentType();
                    this.signedObject = this.readStream(part.getInputStream());
                    continue;
                }
                this.signatures = this.extractSignatures(this.readStream(part.getInputStream()));
            }
        }
    }

    private Signature[] extractSignatures(byte[] pkcs7) throws IOException, CMSException, SignatureDataException, NoSuchProviderException, NoSuchStoreException, NoSuchAlgorithmException, CertStoreException, InvalidAlgorithmParameterException {
        Vector<SMIMESignatureProxy> signatures = new Vector<SMIMESignatureProxy>();
        try {
            if (Security.getProvider("BC") == null) {
                Provider p = (Provider)this.getClass().getClassLoader().loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
                Security.addProvider(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteArrayInputStream voidContentData = new ByteArrayInputStream(new byte[0]);
        CMSTypedStream typedIn = new CMSTypedStream((InputStream)voidContentData);
        CMSSignedDataParser parser = new CMSSignedDataParser(typedIn, pkcs7);
        parser.getSignedContent().drain();
        SignerInformationStore signers = parser.getSignerInfos();
        Iterator it = signers.getSigners().iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            ByteArrayInputStream new_voidContentData = new ByteArrayInputStream(new byte[0]);
            CMSTypedStream new_typedIn = new CMSTypedStream((InputStream)new_voidContentData);
            CMSSignedDataParser new_signedData = new CMSSignedDataParser(new_typedIn, pkcs7);
            new_signedData.getSignedContent().drain();
            Vector<SignerInformation> new_signers = new Vector<SignerInformation>();
            new_signers.add(new_signedData.getSignerInfos().get(signer.getSID()));
            SignerInformationStore new_signersStore = new SignerInformationStore(new_signers);
            ByteArrayInputStream inStr = new ByteArrayInputStream(pkcs7);
            ByteArrayOutputStream outStr = new ByteArrayOutputStream();
            CMSSignedDataParser.replaceSigners((InputStream)inStr, (SignerInformationStore)new_signersStore, (OutputStream)outStr);
            try {
                inStr.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            inStr = new ByteArrayInputStream(outStr.toByteArray());
            try {
                outStr.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            outStr = new ByteArrayOutputStream();
            CertStore store = new_signedData.getCertificatesAndCRLs("Collection", "BC");
            Vector<Object> newCertStoreCollection = new Vector<Object>();
            X509Certificate[] new_certs = this.extractCertificateChain(store, signer);
            for (int i = 0; i < new_certs.length; ++i) {
                newCertStoreCollection.add(new_certs[i]);
            }
            CRL[] crls = store.getCRLs(new CertStoreCRLSelector(new_certs)).toArray(new CRL[0]);
            for (int i = 0; i < crls.length; ++i) {
                newCertStoreCollection.add(crls[i]);
            }
            CollectionCertStoreParameters param = new CollectionCertStoreParameters(newCertStoreCollection);
            CertStore new_certsStore = CertStore.getInstance("Collection", param);
            CMSSignedDataParser.replaceCertificatesAndCRLs((InputStream)inStr, (CertStore)new_certsStore, (OutputStream)outStr);
            try {
                inStr.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            byte[] new_pkcs7 = outStr.toByteArray();
            try {
                outStr.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            SMIMESignatureProxy new_signature = new SMIMESignatureProxy(new_pkcs7, this.contentType);
            signatures.add(new_signature);
        }
        return signatures.toArray(new Signature[signatures.size()]);
    }

    public byte[] readStream(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int c = -1;
        try {
            do {
                if ((c = is.read()) != -1) {
                    out.write(c);
                    continue;
                }
                out.flush();
                out.close();
            } while (c != -1);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ioex) {
            throw ioex;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                out.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public X509Certificate[] extractCertificateChain(CertStore certs, SignerInformation signer) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, CertStoreException {
        X509Certificate userCertificate = null;
        Collection<? extends Certificate> certCollection = certs.getCertificates((CertSelector)signer.getSID());
        Iterator<? extends Certificate> certIt = certCollection.iterator();
        if (certIt.hasNext()) {
            userCertificate = (X509Certificate)certIt.next();
        }
        certCollection = certs.getCertificates(null);
        certIt = certCollection.iterator();
        LinkedList<Certificate> allCertificates = new LinkedList<Certificate>();
        while (certIt.hasNext()) {
            allCertificates.addFirst(certIt.next());
        }
        boolean finishExtraction = allCertificates.size() == 0;
        X509Certificate currentCertificate = userCertificate;
        LinkedList<X509Certificate> certificateChainList = new LinkedList<X509Certificate>();
        certificateChainList.addFirst(userCertificate);
        while (!finishExtraction) {
            ListIterator iterator = allCertificates.listIterator();
            boolean nextCertificate = false;
            X509Certificate certificateFromIterator = null;
            while (iterator.hasNext() && !nextCertificate) {
                certificateFromIterator = (X509Certificate)iterator.next();
                nextCertificate = ((Object)certificateFromIterator.getSubjectDN()).toString().compareTo(((Object)currentCertificate.getIssuerDN()).toString()) == 0;
            }
            if (nextCertificate) {
                certificateChainList.addLast(certificateFromIterator);
                currentCertificate = certificateFromIterator;
            }
            finishExtraction = !nextCertificate || ((Object)currentCertificate.getIssuerDN()).toString().compareTo(((Object)currentCertificate.getSubjectDN()).toString()) == 0;
        }
        return certificateChainList.toArray(new X509Certificate[certificateChainList.size()]);
    }
}

