/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.provider.impl.common.FuncionariParsedCertificate;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.cert.CertificateException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class FuncionariParsedCertificateImpl
extends FuncionariParsedCertificate {
    private String cargo;
    private String centroDirectivo;
    private String consejeria;
    private String nombre;
    private String apellidos;
    private String localidad;
    private static final String CERTIFICATE_POLICY_OID = "1.3.6.1.4.1.17326.10.9.2.2.2";

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream("C:\\test\\miquel_mascaro_artigues.cer");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
            X509Certificate[] certs = new X509Certificate[]{cert};
            FuncionariParsedCertificateImpl funcionariCert = new FuncionariParsedCertificateImpl(certs, false);
            System.out.println("Cargo: " + funcionariCert.getCargo());
            System.out.println("Centro directivo: " + funcionariCert.getCentroDirectivo());
            System.out.println("Consejer\u00eda: " + funcionariCert.getConsejeria());
            System.out.println("Nombre: " + funcionariCert.getNombre());
            System.out.println("Apellidos: " + funcionariCert.getApellidos());
            System.out.println("Localidad: " + funcionariCert.getLocalidad());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FuncionariParsedCertificateImpl(X509Certificate[] cert, boolean securedevice) throws Exception {
        super(cert, securedevice);
        this.init(cert, securedevice);
    }

    private void init(X509Certificate[] cert, boolean securedevice) throws IOException, CertificateException, CertificateEncodingException {
        byte[] b = cert[0].getEncoded();
        ASN1InputStream asn1is = new ASN1InputStream(b);
        DERObject obj = asn1is.readObject();
        X509CertificateStructure certificate = new X509CertificateStructure((ASN1Sequence)obj);
        X509Name name = certificate.getSubject();
        Vector v = name.getOIDs();
        Vector value = name.getValues();
        if (SigDebug.isActive()) {
            System.out.println("Hay " + v.size() + " oids en el subject");
        }
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i).equals(X509Name.GIVENNAME)) {
                if (SigDebug.isActive()) {
                    System.out.println("Obteniendo GIVENNAME: " + value.get(i).toString());
                }
                this.nombre = value.get(i).toString();
                continue;
            }
            if (v.get(i).equals(X509Name.SN)) {
                if (SigDebug.isActive()) {
                    System.out.println("Obteniendo SN: " + value.get(i).toString());
                }
                this.apellidos = value.get(i).toString();
                continue;
            }
            if (v.get(i).equals(X509Name.SURNAME)) {
                if (SigDebug.isActive()) {
                    System.out.println("Obteniendo SURNAME: " + value.get(i).toString());
                }
                this.apellidos = value.get(i).toString();
                continue;
            }
            if (v.get(i).equals(X509Name.OU)) {
                if (SigDebug.isActive()) {
                    System.out.println("Obteniendo OU: " + value.get(i).toString());
                }
                if (this.consejeria == null) {
                    this.consejeria = value.get(i).toString();
                    continue;
                }
                this.centroDirectivo = value.get(i).toString();
                continue;
            }
            if (v.get(i).equals(X509Name.L)) {
                if (SigDebug.isActive()) {
                    System.out.println("Obteniendo L: " + value.get(i).toString());
                }
                this.localidad = value.get(i).toString();
                continue;
            }
            if (v.get(i).equals(X509Name.T)) {
                if (SigDebug.isActive()) {
                    System.out.println("Obteniendo T: " + value.get(i).toString());
                }
                this.cargo = value.get(i).toString();
                continue;
            }
            if (!SigDebug.isActive()) continue;
            System.out.println("OID no contemplado: " + v.get(i).toString() + " => " + value.get(i).toString());
        }
        TBSCertificateStructure tbs = certificate.getTBSCertificate();
        X509Extensions exts = tbs.getExtensions();
        X509Extension polext = exts.getExtension(X509Extensions.CertificatePolicies);
        Vector<PolicyInformation> policies = new Vector<PolicyInformation>();
        if (polext != null) {
            asn1is = new ASN1InputStream(polext.getValue().getOctets());
            ASN1Sequence asn1seq = (ASN1Sequence)asn1is.readObject();
            Enumeration tempPolicies = asn1seq.getObjects();
            while (tempPolicies.hasMoreElements()) {
                ASN1Sequence seq2 = (ASN1Sequence)tempPolicies.nextElement();
                PolicyInformation info = new PolicyInformation(seq2);
                policies.add(info);
            }
            boolean found = false;
            SignaturaProperties properties = new SignaturaProperties();
            String[] publicemployeeOID = properties.getPublicEmployeeOID();
            int i = 0;
            for (int cnt = 0; cnt < policies.size() && !found; ++cnt) {
                for (i = 0; i < publicemployeeOID.length && !found; ++i) {
                    PolicyInformation info = (PolicyInformation)policies.get(cnt);
                    String policyOID = info.getPolicyIdentifier().getId();
                    if (!publicemployeeOID[i].equals(policyOID)) continue;
                    found = true;
                }
            }
            if (!found) {
                throw new CertificateException("OID de certificado de funcionario p\u00fablico no encontrado en el certificado especificado para crear la compulsa.");
            }
        } else {
            throw new CertificateException("OID de certificado de funcionario p\u00fablico no encontrado en el certificado especificado para crear la compulsa.");
        }
    }

    public String getCargo() {
        return this.cargo;
    }

    public String getLocalidad() {
        return this.localidad;
    }

    public String getCentroDirectivo() {
        return this.centroDirectivo;
    }

    public String getConsejeria() {
        return this.consejeria;
    }

    public String getNombre() {
        return this.nombre;
    }

    public String getApellidos() {
        return this.apellidos;
    }
}

