/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import [Ljava.security.cert.X509Certificate;;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BarcodePDF417;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSignature;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import es.caib.signatura.api.SignatureException;
import es.caib.signatura.impl.ClassLoaderFactory;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.impl.locales.Messages;
import es.caib.signatura.provider.impl.common.FuncionariParsedCertificate;
import es.caib.signatura.provider.impl.common.ParsedCertificateImpl;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public class PDFSigner {
    private static final int SIGNATURE_HORIZONTAL_SPLIT_LEN = 65;
    private static final int SIGNATURE_VERTICAL_SPLIT_LEN = 100;
    private static final int SIGNATURE_SPLIT_RANGE = 10;
    private static final int SIGNATURE_SPLIT_MARGIN = 5;
    private static int SIGNATURE_DEF_WIDTH = 260;
    private static int SIGNATURE_DEF_HEIGHT = 50;
    public static final String DATE_FORMAT = "dd-MM-yyyy";
    private static final int SIGNATURE_RESERVED_BYTES = 10000;
    private static int CERTIFY_DEF_WIDTH = 350;
    private static int CERTIFY_DEF_HEIGHT = 75;
    private static String CERTIFY_DATE_FORMAT = "dd/MM/yyyy H:m:s";
    private static int CERTIFY_FONT_SIZE = 4;
    private static final String CERTIFY_TEXT = "\u00c9S C\u00d2PIA ELECTR\u00d2NICA AUTENTICADA DEL DOCUMENT ORIGINAL";

    public static void sign(InputStream pdfInputStream, OutputStream signedStream, PrivateKey key, X509Certificate[] chain, String textoAdicional, int position, boolean allowMultipleSignature, String providerName) throws Exception {
        if ((position & 0x20) == 0 || position == 0 || (position & 0x40) != 0) {
            PDFSigner.estampadoPDF417(pdfInputStream, signedStream, key, chain, textoAdicional, position, allowMultipleSignature, providerName);
        } else {
            PDFSigner.estampadoAdobe(pdfInputStream, signedStream, key, chain, textoAdicional, position, allowMultipleSignature, providerName);
        }
    }

    public static void sign(InputStream pdfInputStream, OutputStream signedStream, PrivateKey key, X509Certificate[] chain, String textoAdicional, int stampOptions, float top, float left, float height, float width, float rotation, boolean allowMultipleSignature, String providerName) throws Exception {
        if ((stampOptions & 0x20) == 0 || stampOptions == 0 || (stampOptions & 0x40) != 0) {
            PDFSigner.estampadoPDF417(pdfInputStream, signedStream, key, chain, textoAdicional, stampOptions, top, left, height, width, rotation, allowMultipleSignature, providerName);
        } else {
            PDFSigner.estampadoAdobe(pdfInputStream, signedStream, key, chain, textoAdicional, stampOptions, top, left, height, width, rotation, allowMultipleSignature, providerName);
        }
    }

    public static void certifyDigitalCopy(InputStream pdfInputStream, OutputStream signedStream, PrivateKey key, X509Certificate[] chain, String url, String localidad, float x, float y, float rotation, SignaturaProperties signatureProperties, String providerName) throws Exception {
        try {
            PdfReader reader = new PdfReader(pdfInputStream);
            String funcionariParserClassName = signatureProperties.getPublicEmployeeParser();
            Class<?> funcionariParserClass = ClassLoaderFactory.getFactory().getMasterClassLoader().loadClass(funcionariParserClassName);
            Constructor<?> constructor = funcionariParserClass.getConstructor(X509Certificate;.class, Boolean.TYPE);
            FuncionariParsedCertificate certificate = (FuncionariParsedCertificate)constructor.newInstance(chain, new Boolean(true));
            PdfStamper stp = null;
            stp = PdfStamper.createSignature((PdfReader)reader, (OutputStream)signedStream, (char)'\u0000', null, (boolean)true);
            PdfSignatureAppearance sap = stp.getSignatureAppearance();
            sap.setCrypto(key, (Certificate[])chain, null, PdfSignatureAppearance.WINCER_SIGNED);
            sap.setReason(CERTIFY_TEXT);
            int pageNumber = 1;
            float x2 = 0.0f;
            float y2 = 0.0f;
            float topTemplate = 0.0f;
            float leftTemplate = 0.0f;
            if (rotation == 0.0f) {
                x2 = x + (float)CERTIFY_DEF_WIDTH;
                y2 = y + (float)CERTIFY_DEF_HEIGHT;
                leftTemplate = 0.0f;
                topTemplate = 0.0f;
            } else if (rotation == 90.0f) {
                x2 = x + (float)CERTIFY_DEF_HEIGHT;
                y2 = y + (float)CERTIFY_DEF_WIDTH;
                leftTemplate = CERTIFY_DEF_HEIGHT;
                topTemplate = 1.0f;
            } else if (rotation == 270.0f || rotation == -90.0f) {
                x2 = x + (float)CERTIFY_DEF_HEIGHT;
                y2 = y + (float)CERTIFY_DEF_WIDTH;
                leftTemplate = 0.0f;
                topTemplate = CERTIFY_DEF_WIDTH - 1;
            } else {
                throw new SignatureException("La rotaci\u00f3n especificada no est\u00e1 dentro de los valores soportados [0|90|270]");
            }
            Rectangle rec = new Rectangle(x, y, x2, y2);
            sap.setVisibleSignature(rec, pageNumber, certificate.getNombre());
            sap.setAcro6Layers(true);
            PdfTemplate n2 = sap.getLayer(2);
            PdfTemplate tem = PdfTemplate.createTemplate((PdfWriter)stp.getWriter(), (float)(x2 - x), (float)(y2 - y));
            PdfPTable table = new PdfPTable(new float[]{0.13f, 0.66f, 0.09f, 0.12f});
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
            Font font = new Font(bf);
            font.setSize((float)CERTIFY_FONT_SIZE);
            PdfPCell cell = new PdfPCell(new Phrase(CERTIFY_TEXT, font));
            cell.setColspan(4);
            cell.setHorizontalAlignment(1);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Signat per", font));
            cell.setHorizontalAlignment(0);
            table.addCell(cell);
            String nombreCargo = certificate.getNombre() + " " + certificate.getApellidos() + " - " + certificate.getCargo();
            cell = new PdfPCell(new Phrase(nombreCargo, font));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Centre directiu adscrit", font));
            cell.setHorizontalAlignment(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(certificate.getCentroDirectivo(), font));
            cell.setHorizontalAlignment(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Data d'emissi\u00f3", font));
            cell.setHorizontalAlignment(0);
            table.addCell(cell);
            Date fecha = sap.getSignDate().getTime();
            SimpleDateFormat formatter = new SimpleDateFormat(CERTIFY_DATE_FORMAT);
            String fechaFormateada = formatter.format(fecha);
            cell = new PdfPCell(new Phrase(fechaFormateada, font));
            cell.setHorizontalAlignment(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Conselleria", font));
            cell.setHorizontalAlignment(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(certificate.getConsejeria(), font));
            cell.setHorizontalAlignment(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Lloc d'emissi\u00f3", font));
            cell.setHorizontalAlignment(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(localidad, font));
            cell.setHorizontalAlignment(0);
            table.addCell(cell);
            String line = url;
            float pdf417_X = 20.0f;
            float pdf417_Y = 20.0f;
            BarcodePDF417 pdf417 = new BarcodePDF417();
            pdf417.setText(url);
            Image image = pdf417.getImage();
            int SIGNATURE_SPLIT_LEN = 65;
            Vector<String> lines = new Vector<String>();
            int counter = 0;
            while (counter != -1) {
                if (counter + SIGNATURE_SPLIT_LEN < line.length()) {
                    int prev = line.substring(counter, counter + SIGNATURE_SPLIT_LEN).lastIndexOf(" ");
                    String next_string = line.substring(counter + SIGNATURE_SPLIT_LEN, line.length());
                    int next = next_string.indexOf(" ");
                    int splitPos = prev + 1;
                    if (next < 10 && next != -1) {
                        splitPos = SIGNATURE_SPLIT_LEN + next;
                    } else if (prev == -1 && next > 10) {
                        splitPos = SIGNATURE_SPLIT_LEN;
                    } else if (prev == -1 && next == -1) {
                        splitPos = SIGNATURE_SPLIT_LEN;
                    }
                    lines.add(line.substring(counter, counter + splitPos));
                    counter += splitPos;
                    continue;
                }
                lines.add(line.substring(counter, line.length()));
                counter = -1;
            }
            image.setAbsolutePosition(pdf417_X, pdf417_Y);
            image.scalePercent(100.0f);
            cell = new PdfPCell(image);
            cell.setColspan(4);
            cell.setPadding(3.0f);
            cell.setHorizontalAlignment(1);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(url, font));
            cell.setColspan(4);
            cell.setHorizontalAlignment(1);
            table.addCell(cell);
            table.setTotalWidth((float)Math.abs(CERTIFY_DEF_WIDTH));
            table.writeSelectedRows(0, -1, 0.0f, (float)(CERTIFY_DEF_HEIGHT - 1), (PdfContentByte)tem);
            float angle = (float)((double)(-rotation) * (Math.PI / 180));
            float xScale = (float)Math.cos(angle);
            float yScale = (float)Math.cos(angle);
            float xRote = (float)(-Math.sin(angle));
            float yRote = (float)Math.sin(angle);
            n2.addTemplate(tem, xScale, xRote, yRote, yScale, leftTemplate, topTemplate);
            PdfSignature dic = new PdfSignature(PdfName.ADOBE_PPKMS, PdfName.ADBE_PKCS7_SHA1);
            dic.setDate(new PdfDate(sap.getSignDate()));
            dic.setName(PdfPKCS7.getSubjectFields((X509Certificate)chain[0]).getField("CN"));
            if (sap.getReason() != null) {
                dic.setReason(sap.getReason());
            }
            if (sap.getLocation() != null) {
                dic.setLocation(sap.getLocation());
            }
            sap.setCryptoDictionary((PdfDictionary)dic);
            int csize = 10000;
            HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
            exc.put(PdfName.CONTENTS, new Integer(csize * 2 + 2));
            sap.preClose(exc);
            MessageDigest md = MessageDigest.getInstance("SHA1");
            InputStream s = sap.getRangeStream();
            int read = 0;
            byte[] buff = new byte[8192];
            while ((read = s.read(buff, 0, 8192)) > 0) {
                md.update(buff, 0, read);
            }
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            AttributeTable signedAttributes = PDFSigner.getSignedAttributes(chain[0]);
            AttributeTable unsignedAttributes = PDFSigner.getUnsignedAttributes(chain[0]);
            generator.addSigner(key, chain[0], CMSSignedDataGenerator.DIGEST_SHA1, signedAttributes, unsignedAttributes);
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            for (int i = 0; i < chain.length; ++i) {
                list.add(chain[i]);
            }
            CertStore chainStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(list));
            generator.addCertificatesAndCRLs(chainStore);
            CMSProcessableByteArray content = new CMSProcessableByteArray(md.digest());
            CMSSignedData signedData = generator.generate((CMSProcessable)content, true, providerName);
            byte[] pk = signedData.getEncoded();
            byte[] outc = new byte[csize];
            PdfDictionary dic2 = new PdfDictionary();
            System.arraycopy(pk, 0, outc, 0, pk.length);
            dic2.put(PdfName.CONTENTS, (PdfObject)new PdfString(outc).setHexWriting(true));
            sap.close(dic2);
        }
        catch (DocumentException e) {
            throw new SignatureException(Messages.getString((String)"PDFSigner.error_firmando_pdf"), (Throwable)e);
        }
    }

    private static void estampadoAdobe(InputStream pdfInputStream, OutputStream signedStream, PrivateKey key, X509Certificate[] chain, String reason, int position, boolean allowMultipleSignature, String providerName) throws Exception {
        PdfReader reader = new PdfReader(pdfInputStream);
        int numberOfPages = reader.getNumberOfPages();
        ParsedCertificateImpl certificate = new ParsedCertificateImpl(chain, true);
        int pageNumber = (position & 0x10) == 0 ? 1 : numberOfPages;
        boolean top = false;
        boolean left = false;
        PDFSigner.estampadoAdobe(reader, signedStream, key, certificate, chain, reason, position, (float)top, (float)left, SIGNATURE_DEF_HEIGHT, SIGNATURE_DEF_WIDTH, 0.0f, allowMultipleSignature, providerName, true);
    }

    private static void estampadoAdobe(InputStream pdfInputStream, OutputStream signedStream, PrivateKey key, X509Certificate[] chain, String reason, int stampOptions, float top, float left, float height, float width, float rotation, boolean allowMultipleSignature, String providerName) throws Exception {
        PdfReader reader = new PdfReader(pdfInputStream);
        int numberOfPages = reader.getNumberOfPages();
        ParsedCertificateImpl certificate = new ParsedCertificateImpl(chain, true);
        int pageNumber = (stampOptions & 0x10) == 0 ? 1 : numberOfPages;
        Rectangle pageSize = reader.getPageSize(pageNumber);
        float p_width = pageSize.getWidth();
        float p_height = pageSize.getHeight();
        if (left < 0.0f) {
            left = p_width + left;
        }
        if (top < 0.0f) {
            top = p_height + top;
        }
        PDFSigner.estampadoAdobe(reader, signedStream, key, certificate, chain, reason, stampOptions, top, left, height, width, rotation, allowMultipleSignature, providerName, false);
    }

    private static void estampadoAdobe(PdfReader reader, OutputStream signedStream, PrivateKey key, ParsedCertificateImpl certificate, X509Certificate[] chain, String reason, int stampOptions, float top, float left, float height, float width, float rotation, boolean allowMultipleSignature, String providerName, boolean adjustSize) throws Exception {
        try {
            int numberOfPages = reader.getNumberOfPages();
            AcroFields acroFields = reader.getAcroFields();
            ArrayList names = acroFields.getSignatureNames();
            if (names.size() > 0 && !allowMultipleSignature) {
                throw new Exception(Messages.getString((String)"PDFSigner.error_documento_ya_firmado"));
            }
            PdfStamper stp = null;
            stp = allowMultipleSignature ? PdfStamper.createSignature((PdfReader)reader, (OutputStream)signedStream, (char)'\u0000', null, (boolean)true) : PdfStamper.createSignature((PdfReader)reader, (OutputStream)signedStream, (char)'\u0000');
            PdfSignatureAppearance sap = stp.getSignatureAppearance();
            sap.setCrypto(key, (Certificate[])chain, null, PdfSignatureAppearance.WINCER_SIGNED);
            sap.setReason(reason);
            int pageNumber = (stampOptions & 0x10) == 0 ? 1 : numberOfPages;
            Rectangle pageSize = reader.getPageSize(pageNumber);
            float pageWidth = pageSize.getWidth();
            float pageHeight = pageSize.getHeight();
            String[] texto = new String[]{Messages.getString((String)"PDFSigner.sello_adobe_firmado_por") + certificate.getCommonName(), Messages.getString((String)"PDFSigner.sello_adobe_fecha") + sap.getSignDate().getTime().toLocaleString(), Messages.getString((String)"PDFSigner.sello_adobe_motivo") + sap.getReason()};
            if (adjustSize) {
                for (int i = 0; i < texto.length; ++i) {
                    int text_width = 0;
                    for (int j = 0; j < texto[i].length(); ++j) {
                        char c = texto[i].charAt(j);
                        if (c > '`' && c < '{') {
                            text_width += 4;
                            continue;
                        }
                        text_width += 6;
                    }
                    if (!((float)(text_width + 30) > width)) continue;
                    width = text_width + 30;
                }
            }
            if ((stampOptions & 4) == 4) {
                left = 20.0f;
            } else if ((stampOptions & 8) == 8) {
                left = (float)((int)pageWidth) - width - 20.0f;
            } else if ((stampOptions & 1) == 1 || (stampOptions & 2) == 2) {
                left = (int)(pageWidth - width) / 2;
            }
            if ((stampOptions & 1) == 1) {
                top = (int)pageHeight - 20;
            } else if ((stampOptions & 2) == 2) {
                top = 20 + SIGNATURE_DEF_HEIGHT;
            } else if ((stampOptions & 4) == 4 || (stampOptions & 8) == 8) {
                top = (int)(pageHeight - (float)SIGNATURE_DEF_HEIGHT) / 2;
            }
            Rectangle rec = new Rectangle(left, top - height, left + width, top);
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
            sap.setVisibleSignature(rec, pageNumber, certificate.getName());
            sap.setAcro6Layers(true);
            PdfTemplate n2 = sap.getLayer(2);
            n2.beginText();
            bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            n2.setColorStroke(Color.BLACK);
            n2.setFontAndSize(bf, 8.0f);
            for (int i = 0; i < texto.length; ++i) {
                n2.setTextMatrix(30.0f, n2.getHeight() - (float)((i + 1) * 10));
                n2.showText(texto[i]);
            }
            n2.endText();
            PdfSignature dic = new PdfSignature(PdfName.ADOBE_PPKMS, PdfName.ADBE_PKCS7_SHA1);
            dic.setDate(new PdfDate(sap.getSignDate()));
            dic.setName(PdfPKCS7.getSubjectFields((X509Certificate)chain[0]).getField("CN"));
            if (sap.getReason() != null) {
                dic.setReason(sap.getReason());
            }
            if (sap.getLocation() != null) {
                dic.setLocation(sap.getLocation());
            }
            sap.setCryptoDictionary((PdfDictionary)dic);
            int csize = 10000;
            HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
            exc.put(PdfName.CONTENTS, new Integer(csize * 2 + 2));
            sap.preClose(exc);
            MessageDigest md = MessageDigest.getInstance("SHA1");
            InputStream s = sap.getRangeStream();
            int read = 0;
            byte[] buff = new byte[8192];
            while ((read = s.read(buff, 0, 8192)) > 0) {
                md.update(buff, 0, read);
            }
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            AttributeTable signedAttributes = PDFSigner.getSignedAttributes(chain[0]);
            AttributeTable unsignedAttributes = PDFSigner.getUnsignedAttributes(chain[0]);
            generator.addSigner(key, chain[0], CMSSignedDataGenerator.DIGEST_SHA1, signedAttributes, unsignedAttributes);
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            for (int i = 0; i < chain.length; ++i) {
                list.add(chain[i]);
            }
            CertStore chainStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(list));
            generator.addCertificatesAndCRLs(chainStore);
            CMSProcessableByteArray content = new CMSProcessableByteArray(md.digest());
            CMSSignedData signedData = generator.generate((CMSProcessable)content, true, providerName);
            byte[] pk = signedData.getEncoded();
            byte[] outc = new byte[csize];
            PdfDictionary dic2 = new PdfDictionary();
            System.arraycopy(pk, 0, outc, 0, pk.length);
            dic2.put(PdfName.CONTENTS, (PdfObject)new PdfString(outc).setHexWriting(true));
            sap.close(dic2);
        }
        catch (DocumentException e) {
            throw new SignatureException(Messages.getString((String)"PDFSigner.error_firmando_pdf"), (Throwable)e);
        }
    }

    private static void estampadoPDF417(InputStream pdfInputStream, OutputStream signedStream, PrivateKey key, X509Certificate[] chain, String url, int stampOptions, boolean allowMultipleSignature, String providerName) throws Exception {
        float rotation;
        float y;
        float x;
        PdfReader reader = new PdfReader(pdfInputStream);
        float height = 500.0f;
        float width = 1125.0f;
        switch (stampOptions) {
            case 8: {
                x = -20.0f;
                y = 20.0f;
                rotation = 90.0f;
                break;
            }
            case 1: {
                x = 20.0f;
                y = -50.0f;
                rotation = 0.0f;
                break;
            }
            case 2: {
                x = 20.0f;
                y = 30.0f;
                rotation = 0.0f;
                break;
            }
            default: {
                x = 40.0f;
                y = 20.0f;
                rotation = 90.0f;
            }
        }
        PDFSigner.estampadoPDF417(reader, signedStream, key, chain, url, stampOptions, y, x, height, width, rotation, allowMultipleSignature, providerName);
    }

    private static void estampadoPDF417(InputStream pdfInputStream, OutputStream signedStream, PrivateKey key, X509Certificate[] chain, String url, int stampOptions, float top, float left, float height, float width, float rotation, boolean allowMultipleSignature, String providerName) throws Exception {
        PdfReader reader = new PdfReader(pdfInputStream);
        PDFSigner.estampadoPDF417(reader, signedStream, key, chain, url, stampOptions, top, left, height, width, rotation, allowMultipleSignature, providerName);
    }

    private static void estampadoPDF417(PdfReader reader, OutputStream signedStream, PrivateKey key, X509Certificate[] chain, String url, int position, float top, float left, float height, float width, float rotation, boolean allowMultipleSignature, String providerName) throws Exception {
        try {
            int numberOfPages = reader.getNumberOfPages();
            AcroFields acroFields = reader.getAcroFields();
            ArrayList names = acroFields.getSignatureNames();
            if (names.size() > 0 && !allowMultipleSignature) {
                throw new Exception(Messages.getString((String)"PDFSigner.error_documento_ya_firmado"));
            }
            ParsedCertificateImpl certificate = new ParsedCertificateImpl(chain, true);
            String signName = certificate.getName();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
            String line = signName + " " + simpleDateFormat.format(new Date()) + " " + url;
            PdfStamper stamp = allowMultipleSignature ? PdfStamper.createSignature((PdfReader)reader, (OutputStream)signedStream, (char)'\u0000', null, (boolean)true) : PdfStamper.createSignature((PdfReader)reader, (OutputStream)signedStream, (char)'\u0000');
            PdfSignatureAppearance sap = stamp.getSignatureAppearance();
            sap.setCrypto(key, (Certificate[])chain, null, PdfSignatureAppearance.WINCER_SIGNED);
            if (position != 0) {
                int textAlign = 0;
                BarcodePDF417 pdf417 = new BarcodePDF417();
                pdf417.setText(url);
                Image image = pdf417.getImage();
                if (width < image.getWidth()) {
                    throw new SignatureException("Width too small, minumim: " + image.getWidth());
                }
                if (height < image.getHeight()) {
                    throw new SignatureException("Height too small, minumim: " + image.getHeight());
                }
                for (int i = 1; i <= numberOfPages; ++i) {
                    PdfContentByte over = stamp.getOverContent(i);
                    PdfTemplate template = PdfTemplate.createTemplate((PdfWriter)stamp.getWriter(), (float)width, (float)height);
                    Rectangle pageSize = reader.getPageSize(i);
                    float pageWidth = pageSize.getWidth();
                    float pageHeight = pageSize.getHeight();
                    int SIGNATURE_SPLIT_LEN = 0;
                    SIGNATURE_SPLIT_LEN = (int)(width - image.getWidth()) / 8;
                    Vector<String> lines = new Vector<String>();
                    int counter = 0;
                    boolean ampliat = false;
                    while (counter != -1) {
                        if (counter + SIGNATURE_SPLIT_LEN < line.length()) {
                            int prev = line.substring(counter, counter + SIGNATURE_SPLIT_LEN).lastIndexOf(" ");
                            String next_string = line.substring(counter + SIGNATURE_SPLIT_LEN, line.length());
                            int next = next_string.indexOf(" ");
                            int splitPos = prev + 1;
                            if (!ampliat && next < 10 && next != -1) {
                                splitPos = SIGNATURE_SPLIT_LEN + next;
                                SIGNATURE_SPLIT_LEN += next;
                                ampliat = true;
                            } else if (prev == -1 && next > 10) {
                                splitPos = SIGNATURE_SPLIT_LEN;
                            } else if (prev == -1 && next == -1) {
                                splitPos = SIGNATURE_SPLIT_LEN;
                            }
                            lines.add(line.substring(counter, counter + splitPos));
                            if (counter + splitPos < line.length() && line.charAt(counter + splitPos) == ' ') {
                                ++counter;
                            }
                            counter += splitPos;
                            continue;
                        }
                        lines.add(line.substring(counter, line.length()));
                        counter = -1;
                    }
                    float pdf417_X = 0.0f;
                    float pdf417_Y = 0.0f;
                    float text_X = image.getWidth() + 20.0f;
                    float text_Y = 0.0f;
                    image.setAbsolutePosition(pdf417_X, (float)(lines.size() * 15) / 2.0f - image.getHeight() / 2.0f);
                    template.addImage(image);
                    counter = 0;
                    for (counter = 0; counter < lines.size(); ++counter) {
                        template.beginText();
                        template.setFontAndSize(bf, 10.0f);
                        float x = text_X;
                        float y = text_Y + (float)((lines.size() - 1 - counter) * 15);
                        template.showTextAligned(textAlign, (String)lines.get(counter), x, y, 0.0f);
                        template.endText();
                    }
                    float angle = (float)((double)(-rotation) * (Math.PI / 180));
                    float xScale = (float)Math.cos(angle);
                    float yScale = (float)Math.cos(angle);
                    float xRote = (float)(-Math.sin(angle));
                    float yRote = (float)Math.sin(angle);
                    if (-rotation == 90.0f || -rotation == -270.0f) {
                        xScale = 0.0f;
                        yRote = 1.0f;
                        xRote = -1.0f;
                        yScale = 0.0f;
                    } else if (-rotation == 180.0f || -rotation == -180.0f) {
                        xScale = -1.0f;
                        yRote = 0.0f;
                        xRote = 0.0f;
                        yScale = -1.0f;
                    } else if (-rotation == 270.0f || -rotation == -90.0f) {
                        xScale = 0.0f;
                        yRote = -1.0f;
                        xRote = 1.0f;
                        yScale = 0.0f;
                    }
                    if (left < 0.0f) {
                        left = pageWidth + left;
                    }
                    if (top < 0.0f) {
                        top = pageHeight + top;
                    }
                    over.addTemplate(template, xScale, xRote, yRote, yScale, left, top);
                }
            }
            PdfSignature dic = new PdfSignature(PdfName.ADOBE_PPKMS, PdfName.ADBE_PKCS7_SHA1);
            dic.setDate(new PdfDate(sap.getSignDate()));
            dic.setName(PdfPKCS7.getSubjectFields((X509Certificate)chain[0]).getField("CN"));
            if (sap.getReason() != null) {
                dic.setReason(sap.getReason());
            }
            if (sap.getLocation() != null) {
                dic.setLocation(sap.getLocation());
            }
            sap.setCryptoDictionary((PdfDictionary)dic);
            int csize = 10000;
            HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
            exc.put(PdfName.CONTENTS, new Integer(csize * 2 + 2));
            sap.preClose(exc);
            MessageDigest md = MessageDigest.getInstance("SHA1");
            InputStream s = sap.getRangeStream();
            int read = 0;
            byte[] buff = new byte[8192];
            while ((read = s.read(buff, 0, 8192)) > 0) {
                md.update(buff, 0, read);
            }
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            AttributeTable signedAttributes = PDFSigner.getSignedAttributes(chain[0]);
            AttributeTable unsignedAttributes = PDFSigner.getUnsignedAttributes(chain[0]);
            generator.addSigner(key, chain[0], CMSSignedDataGenerator.DIGEST_SHA1, signedAttributes, unsignedAttributes);
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            for (int i = 0; i < chain.length; ++i) {
                list.add(chain[i]);
            }
            CertStore chainStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(list));
            generator.addCertificatesAndCRLs(chainStore);
            CMSProcessableByteArray content = new CMSProcessableByteArray(md.digest());
            CMSSignedData signedData = generator.generate((CMSProcessable)content, true, providerName);
            byte[] pk = signedData.getEncoded();
            byte[] outc = new byte[csize];
            PdfDictionary dic2 = new PdfDictionary();
            System.arraycopy(pk, 0, outc, 0, pk.length);
            dic2.put(PdfName.CONTENTS, (PdfObject)new PdfString(outc).setHexWriting(true));
            sap.close(dic2);
        }
        catch (DocumentException e) {
            throw new SignatureException(Messages.getString((String)"PDFSigner.error_firmando_pdf"), (Throwable)e);
        }
    }

    private static AttributeTable getSignedAttributes(X509Certificate cert) throws Exception {
        byte[] encodedCert = cert.getEncoded();
        ByteArrayInputStream baInputStream = new ByteArrayInputStream(encodedCert);
        MessageDigest digester = MessageDigest.getInstance("SHA-1", "BC");
        DigestInputStream diInputStream = new DigestInputStream(baInputStream, digester);
        byte[] digestResult = null;
        byte[] b = new byte[8192];
        int read = diInputStream.read(b);
        while (read > 0) {
            read = diInputStream.read(b);
        }
        diInputStream.close();
        baInputStream.close();
        digestResult = digester.digest();
        GeneralName generalName = new GeneralName(new X509Name(cert.getIssuerX500Principal().getName()));
        GeneralNames generalNames = new GeneralNames(generalName);
        BigInteger serialNumber = cert.getSerialNumber();
        IssuerSerial issuerSerial = new IssuerSerial(generalNames, new DERInteger(serialNumber.intValue()));
        ESSCertID essCertID = new ESSCertID(digestResult, issuerSerial);
        SigningCertificate signingCertificate = new SigningCertificate(essCertID);
        Hashtable<String, Attribute> table = new Hashtable<String, Attribute>();
        Attribute att = new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.16.2.12"), (ASN1Set)new DERSet((DEREncodable)signingCertificate));
        table.put("signingCertificate", att);
        return new AttributeTable(table);
    }

    private static AttributeTable getUnsignedAttributes(X509Certificate cert) {
        return new AttributeTable(new Hashtable());
    }
}

