/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BarcodePDF417;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import es.caib.signatura.api.SignatureException;
import es.caib.signatura.impl.locales.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class PDFTest {
    private static final int SIGNATURE_HORIZONTAL_SPLIT_LEN = 65;
    private static final int SIGNATURE_VERTICAL_SPLIT_LEN = 100;
    private static final int SIGNATURE_SPLIT_RANGE = 10;
    private static final int SIGNATURE_SPLIT_MARGIN = 5;
    public static final String DATE_FORMAT = "dd-MM-yyyy";
    private static int SIGNATURE_DEF_WIDTH = 200;
    private static int SIGNATURE_DEF_HEIGHT = 50;

    public static void main(String[] args) {
        try {
            PDFTest test = new PDFTest();
            String url = "http://www.opensubscriber.com/message/itext-questions@lists.sourceforge.net/7624146.html";
            int stampOptions = 0;
            PDFTest.estampadoPDF417(url, stampOptions, 300.0f, 300.0f, 150.0f, 350.0f, 0.0f);
            PDFTest.estampadoPDF417(url, stampOptions, 300.0f, 300.0f, 150.0f, 300.0f, 90.0f);
            PDFTest.estampadoPDF417(url, stampOptions, 300.0f, 300.0f, 500.0f, 500.0f, 30.0f);
            PDFTest.estampadoPDF417(url, stampOptions, 300.0f, 300.0f, 500.0f, 500.0f, 120.0f);
            PDFTest.estampadoPDF417(url, stampOptions, 300.0f, 300.0f, 500.0f, 500.0f, 240.0f);
            PDFTest.estampadoPDF417(url, stampOptions, 300.0f, 300.0f, 500.0f, 500.0f, 300.0f);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static void estampadoPDF417(String url, int stampOptions, float top, float left, float height, float width, float rotation) throws Exception {
        FileInputStream in = new FileInputStream(new File("c:\\pkcs.pdf"));
        FileOutputStream out = new FileOutputStream(new File("c:\\pdf_out" + rotation + ".pdf"));
        PdfReader reader = new PdfReader((InputStream)in);
        PDFTest.estampadoPDF417(reader, out, url, stampOptions, top, left, height, width, rotation);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private static void estampadoPDF417(PdfReader reader, OutputStream signedStream, String url, int position, float top, float left, float height, float width, float rotation) throws Exception {
        try {
            int numberOfPages = reader.getNumberOfPages();
            AcroFields acroFields = reader.getAcroFields();
            ArrayList names = acroFields.getSignatureNames();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
            String line = "Pere Joseph Rodr\u00edguex " + simpleDateFormat.format(new Date()) + " " + url;
            PdfStamper stamp = new PdfStamper(reader, signedStream);
            PdfTemplate template = PdfTemplate.createTemplate((PdfWriter)stamp.getWriter(), (float)width, (float)height);
            int textAlign = 0;
            BarcodePDF417 pdf417 = new BarcodePDF417();
            pdf417.setText(url);
            Image image = pdf417.getImage();
            if (width < image.getWidth()) {
                throw new SignatureException("Width too small, minumim: " + image.getWidth());
            }
            if (height < image.getHeight()) {
                throw new SignatureException("Height too small, minumim: " + image.getHeight());
            }
            for (int i = 1; i <= numberOfPages; ++i) {
                PdfContentByte over = stamp.getOverContent(i);
                Rectangle pageSize = reader.getPageSize(i);
                float pageWidth = pageSize.getWidth();
                float pageHeight = pageSize.getHeight();
                int SIGNATURE_SPLIT_LEN = 0;
                SIGNATURE_SPLIT_LEN = (int)(width - image.getWidth()) / 8;
                Vector<String> lines = new Vector<String>();
                int counter = 0;
                boolean ampliat = false;
                while (counter != -1) {
                    if (counter + SIGNATURE_SPLIT_LEN < line.length()) {
                        int prev = line.substring(counter, counter + SIGNATURE_SPLIT_LEN).lastIndexOf(" ");
                        String next_string = line.substring(counter + SIGNATURE_SPLIT_LEN, line.length());
                        int next = next_string.indexOf(" ");
                        int splitPos = prev + 1;
                        if (!ampliat && next < 10 && next != -1) {
                            splitPos = SIGNATURE_SPLIT_LEN + next;
                            SIGNATURE_SPLIT_LEN += next;
                            ampliat = true;
                        } else if (prev == -1 && next > 10) {
                            splitPos = SIGNATURE_SPLIT_LEN;
                        } else if (prev == -1 && next == -1) {
                            splitPos = SIGNATURE_SPLIT_LEN;
                        }
                        lines.add(line.substring(counter, counter + splitPos));
                        if (counter + splitPos < line.length() && line.charAt(counter + splitPos) == ' ') {
                            ++counter;
                        }
                        counter += splitPos;
                        continue;
                    }
                    lines.add(line.substring(counter, line.length()));
                    counter = -1;
                }
                float pdf417_X = 0.0f;
                float pdf417_Y = 0.0f;
                float text_X = image.getWidth() + 20.0f;
                float text_Y = 0.0f;
                image.setAbsolutePosition(pdf417_X, (float)(lines.size() * 15) / 2.0f - image.getHeight() / 2.0f);
                template.addImage(image);
                counter = 0;
                for (counter = 0; counter < lines.size(); ++counter) {
                    template.beginText();
                    template.setFontAndSize(bf, 10.0f);
                    float x = text_X;
                    float y = text_Y + (float)((lines.size() - 1 - counter) * 15);
                    template.showTextAligned(textAlign, (String)lines.get(counter), x, y, 0.0f);
                    template.endText();
                }
                float angle = (float)((double)(-rotation) * (Math.PI / 180));
                float xScale = (float)Math.cos(angle);
                float yScale = (float)Math.cos(angle);
                float xRote = (float)(-Math.sin(angle));
                float yRote = (float)Math.sin(angle);
                float leftTemplate = 0.0f;
                float topTemplate = 0.0f;
                over.addTemplate(template, xScale, xRote, yRote, yScale, leftTemplate + left, topTemplate + top);
            }
            stamp.close();
            reader.close();
        }
        catch (DocumentException e) {
            throw new SignatureException(Messages.getString((String)"PDFSigner.error_firmando_pdf"), (Throwable)e);
        }
    }
}

