/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.provider.impl.common.DefaultParsedCertificateImpl;
import es.caib.signatura.provider.impl.common.InternalParsedCertificate;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class ParsedCertificateImpl
implements InternalParsedCertificate {
    InternalParsedCertificate impl = null;
    private boolean recognized = false;
    private boolean test = false;
    private boolean unrecognized = false;
    private boolean securedevice = false;
    private int isInValidPeriod = 0;
    public static final int Certificate_Not_Yet_Valid = -1;
    public static final int Certificate_Expired = 1;
    private SignaturaProperties properties = new SignaturaProperties();
    private String alias;
    static /* synthetic */ Class array$Ljava$security$cert$X509Certificate;

    public ParsedCertificateImpl(X509Certificate[] cert, boolean securedevice) throws CertificateEncodingException, IOException {
        X509Extension polext;
        try {
            cert[0].checkValidity();
        }
        catch (CertificateNotYetValidException e) {
            this.isInValidPeriod = -1;
        }
        catch (CertificateExpiredException e) {
            this.isInValidPeriod = 1;
        }
        this.securedevice = securedevice;
        byte[] b = cert[0].getEncoded();
        ASN1InputStream asn1is = new ASN1InputStream(b);
        DERObject obj = asn1is.readObject();
        X509CertificateStructure certificate = new X509CertificateStructure((ASN1Sequence)obj);
        TBSCertificateStructure tbs = certificate.getTBSCertificate();
        X509Extensions exts = tbs.getExtensions();
        Vector<PolicyInformation> policies = new Vector<PolicyInformation>();
        if (exts != null && (polext = exts.getExtension(X509Extensions.CertificatePolicies)) != null) {
            PolicyInformation info;
            asn1is = new ASN1InputStream(polext.getValue().getOctets());
            ASN1Sequence asn1seq = (ASN1Sequence)asn1is.readObject();
            Enumeration tempPolicies = asn1seq.getObjects();
            while (tempPolicies.hasMoreElements()) {
                ASN1Sequence seq2 = (ASN1Sequence)tempPolicies.nextElement();
                info = new PolicyInformation(seq2);
                policies.add(info);
            }
            for (int cnt = 0; cnt < policies.size(); ++cnt) {
                info = (PolicyInformation)policies.get(cnt);
                try {
                    String parserClassName = this.properties.getCertificateParser("certificateparser." + info.getPolicyIdentifier().getId());
                    if (parserClassName == null) continue;
                    Class<?> parserClass = this.getClass().getClassLoader().loadClass(parserClassName);
                    InternalParsedCertificate parser = (InternalParsedCertificate)parserClass.getConstructor(array$Ljava$security$cert$X509Certificate == null ? ParsedCertificateImpl.class$("[Ljava.security.cert.X509Certificate;") : array$Ljava$security$cert$X509Certificate, Boolean.TYPE).newInstance(cert, new Boolean(securedevice));
                    if (parser == null) continue;
                    this.impl = parser;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.impl == null) {
            this.impl = new DefaultParsedCertificateImpl(cert, securedevice);
        }
        this.processPolicy(cert, certificate, policies, exts);
        if (SigDebug.isActive()) {
            SigDebug.write((String)this.toString());
        }
    }

    public ParsedCertificateImpl(X509Certificate[] cert, boolean securedevice, String alias) throws CertificateEncodingException, IOException {
        this(cert, securedevice);
        this.alias = alias;
    }

    private void processPolicy(X509Certificate[] cert, X509CertificateStructure certificate, Vector policies, X509Extensions extensions) throws CertificateEncodingException, IOException {
        this.recognized = false;
        this.unrecognized = false;
        this.test = false;
        if (SigDebug.isActive()) {
            SigDebug.write((String)("ParsedCertificateImp.init: extensionss null ?" + (extensions == null ? "si" : "no")));
        }
        if (extensions != null) {
            if (policies.size() != 0) {
                for (int cnt = 0; cnt < policies.size(); ++cnt) {
                    PolicyInformation info = (PolicyInformation)policies.get(cnt);
                    this.processPolicy(certificate, info.getPolicyIdentifier().getId(), extensions, this.securedevice);
                }
            } else {
                this.processPolicy(certificate, "", extensions, this.securedevice);
            }
            X509Certificate caCert = cert[cert.length - 1];
            String caName = this.getCACommonName(caCert);
            this.test = !this.isIncluded(caName, this.properties.getRootCAs());
        }
    }

    private void processPolicy(X509CertificateStructure certificate, String id, X509Extensions exts, boolean securedevice) {
        if (this.isIncluded(id, this.properties.getRecognizedPolicies())) {
            this.recognized = true;
        }
        if (this.isIncluded(id, this.properties.getAdvancedPolicies())) {
            this.unrecognized = true;
        }
        if (this.isIncluded(id, this.properties.getAmbigousPoliciess())) {
            String[] recognizedExtensions = this.properties.getRecognizedExtensions();
            for (int i = 0; i < recognizedExtensions.length; ++i) {
                X509Extension ext = exts.getExtension(new DERObjectIdentifier(recognizedExtensions[i]));
                if (ext != null) {
                    this.recognized = true;
                    continue;
                }
                this.unrecognized = true;
            }
        }
        if (!this.recognized && this.isIncluded(id, this.properties.getRecognizedSecureDevicePolicies())) {
            this.recognized = securedevice;
        }
        if ("".equals(id) && "OU = FNMT Clase 2 CA,O = FNMT,C = ES".equals(certificate.getIssuer())) {
            this.unrecognized = true;
        }
    }

    private String getCACommonName(X509Certificate cert) throws IOException, CertificateEncodingException {
        String ou = "";
        byte[] b = cert.getEncoded();
        ASN1InputStream asn1is = new ASN1InputStream(b);
        DERObject obj = asn1is.readObject();
        X509CertificateStructure certificate = new X509CertificateStructure((ASN1Sequence)obj);
        asn1is.close();
        X509Name name = certificate.getIssuer();
        Vector v = name.getOIDs();
        Vector value = name.getValues();
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i).equals(X509Name.CN)) {
                if (SigDebug.isActive()) {
                    SigDebug.write((String)("getCACommonName(): " + value.get(i).toString()));
                }
                return value.get(i).toString();
            }
            if (!v.get(i).equals(X509Name.OU)) continue;
            ou = value.get(i).toString();
        }
        if (SigDebug.isActive()) {
            SigDebug.write((String)("getCACommonName(): " + ou));
        }
        return ou;
    }

    private boolean isIncluded(String id, String[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (!id.equals(policies[i])) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.impl.getName();
    }

    public String getNif() {
        return this.impl.getNif();
    }

    public boolean equals(Object obj) {
        return this.impl.equals(obj);
    }

    public String toString() {
        String implDesc = this.impl.toString();
        if (SigDebug.isActive()) {
            implDesc = implDesc + "\n Persona F\u00edsica:" + this.impl.isPersonaFisica();
            implDesc = implDesc + "\n Persona Jur\u00eddica:" + this.impl.isPersonaJuridica();
            implDesc = implDesc + "\n Reconocido: " + this.recognized;
            implDesc = implDesc + "\n Avanzado: " + this.unrecognized;
            implDesc = implDesc + "\n Parser: " + this.impl.getClass().getName();
            implDesc = implDesc + "\n common Name: " + this.getCommonName();
            implDesc = implDesc + "\n Name: " + this.getName();
            implDesc = implDesc + "\n full Name: " + this.getFullName();
            implDesc = implDesc + "\n";
        }
        return implDesc;
    }

    public String getNifResponsable() {
        return this.impl.getNifResponsable();
    }

    public boolean isPersonaFisica() {
        return this.impl.isPersonaFisica();
    }

    public boolean isPersonaJuridica() {
        return this.impl.isPersonaJuridica();
    }

    public boolean isRecognized() {
        return this.recognized;
    }

    public boolean isAdvanced() {
        return this.unrecognized;
    }

    public boolean isTest() {
        return this.test;
    }

    public String getCommonName() {
        if (this.test) {
            return "TEST: " + this.impl.getCommonName();
        }
        return this.impl.getCommonName();
    }

    public String getFullName() {
        return this.impl.getFullName();
    }

    public Date getValidSince() {
        return this.impl.getValidSince();
    }

    public Date getValidUntil() {
        return this.impl.getValidUntil();
    }

    public String getAlias() {
        return this.alias;
    }

    public synchronized int getIsInValidPeriod() {
        return this.isInValidPeriod;
    }
}

