/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.api.Signature;
import es.caib.signatura.impl.RawSignature;
import es.caib.signatura.impl.SMIMEGenerator;
import es.caib.signatura.impl.SMIMEInputStream;
import es.caib.signatura.impl.SMIMEPkcs7InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SMIMEGeneratorImpl
implements SMIMEGenerator {
    public InputStream generateSMIME(InputStream document, Signature signature) throws IOException {
        SMIMEInputStream in;
        if (signature instanceof RawSignature) {
            byte[] pkcs7 = SMIMEGeneratorImpl.encapsulateData(signature.getPkcs7(), document);
            in = new SMIMEPkcs7InputStream(pkcs7);
        } else {
            in = new SMIMEInputStream(signature, document);
        }
        return in;
    }

    private static byte[] encapsulateData(byte[] pkcs7, InputStream data) throws IOException {
        CertStore certsAndCrls;
        CMSSignedData signedData;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        try {
            signedData = new CMSSignedData(pkcs7);
        }
        catch (CMSException e) {
            e.printStackTrace();
            return null;
        }
        try {
            if (Security.getProvider("BC") == null) {
                BouncyCastleProvider p = new BouncyCastleProvider();
                Security.addProvider((Provider)p);
            }
            certsAndCrls = signedData.getCertificatesAndCRLs("Collection", "BC");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[4096];
        int l = data.read(b);
        while (l > 0) {
            out.write(b, 0, l);
            l = data.read(b);
        }
        CMSProcessableByteArray content = new CMSProcessableByteArray(out.toByteArray());
        SignerInformationStore sis = signedData.getSignerInfos();
        Iterator it = sis.getSigners().iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            AlgorithmIdentifier digAlgId = SMIMEGeneratorImpl.makeAlgId(signer.getDigestAlgOID(), signer.getDigestAlgParams());
            digestAlgs.add((DEREncodable)digAlgId);
            signerInfos.add((DEREncodable)signer.toSignerInfo());
        }
        ASN1Set certificates = null;
        ArrayList certs = new ArrayList();
        try {
            certs.addAll(SMIMEGeneratorImpl.getCertificatesFromStore(certsAndCrls));
        }
        catch (CertStoreException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
            return null;
        }
        if (certs.size() != 0) {
            certificates = SMIMEGeneratorImpl.createBerSetFromList(certs);
        }
        ASN1Set certrevlist = null;
        ArrayList crls = new ArrayList();
        try {
            crls.addAll(SMIMEGeneratorImpl.getCRLsFromStore(certsAndCrls));
        }
        catch (CertStoreException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (CRLException e) {
            e.printStackTrace();
            return null;
        }
        if (crls.size() != 0) {
            certrevlist = SMIMEGeneratorImpl.createBerSetFromList(crls);
        }
        DERObjectIdentifier contentTypeOID = CMSObjectIdentifiers.data;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            content.write((OutputStream)bOut);
        }
        catch (CMSException e) {
            e.printStackTrace();
            return null;
        }
        BERConstructedOctetString octs = new BERConstructedOctetString(bOut.toByteArray());
        ContentInfo encInfo = new ContentInfo(contentTypeOID, (DEREncodable)octs);
        SignedData sd = new SignedData((ASN1Set)new DERSet((DEREncodableVector)digestAlgs), encInfo, certificates, certrevlist, (ASN1Set)new DERSet((DEREncodableVector)signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, (DEREncodable)sd);
        CMSSignedData attachedSignature = new CMSSignedData(contentInfo);
        return attachedSignature.getEncoded();
    }

    private static DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        return aIn.readObject();
    }

    private static AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), (DEREncodable)SMIMEGeneratorImpl.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), (DEREncodable)new DERNull());
    }

    private static ASN1Set createBerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((DEREncodable)it.next());
        }
        return new BERSet((DEREncodableVector)v);
    }

    private static List getCertificatesFromStore(CertStore certStore) throws CertStoreException, IOException, CertificateEncodingException {
        ArrayList<X509CertificateStructure> certs = new ArrayList<X509CertificateStructure>();
        Iterator<? extends Certificate> it = certStore.getCertificates(null).iterator();
        while (it.hasNext()) {
            X509Certificate c = (X509Certificate)it.next();
            certs.add(X509CertificateStructure.getInstance((Object)ASN1Object.fromByteArray((byte[])c.getEncoded())));
        }
        return certs;
    }

    private static List getCRLsFromStore(CertStore certStore) throws CertStoreException, IOException, CRLException {
        ArrayList<CertificateList> crls = new ArrayList<CertificateList>();
        Iterator<? extends CRL> it = certStore.getCRLs(null).iterator();
        while (it.hasNext()) {
            X509CRL c = (X509CRL)it.next();
            crls.add(CertificateList.getInstance((Object)ASN1Object.fromByteArray((byte[])c.getEncoded())));
        }
        return crls;
    }
}

