/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.api.ParsedCertificate;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.impl.MIMEInputStream;
import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.impl.SignatureProviderInterface;
import es.caib.signatura.impl.ValidadorProxy;
import es.caib.signatura.provider.impl.common.ParsedCertificateImpl;
import es.caib.signatura.provider.impl.common.SHA1Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.tsp.TSTInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class SMIMESignatureImpl
implements SignatureProviderInterface {
    private X509Certificate[] certificateChain;
    private String contentType;
    private byte[] signatureBytes;
    private Date timeStamp;

    public SMIMESignatureImpl() {
    }

    public SMIMESignatureImpl(byte[] pkcs7, String contentType, boolean isBinary) throws Exception {
        this.signatureBytes = pkcs7;
        this.extractCertificate();
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getSignatureBytes() {
        return null;
    }

    public String getCertCaName() {
        if (this.certificateChain == null || this.certificateChain.length == 0) {
            throw new Error("No se encuentra cadena de certificaci\u00f3n.");
        }
        return this.certificateChain[this.certificateChain.length - 1].getSubjectX500Principal().getName();
    }

    public String getCertSubjectCommonName() {
        ParsedCertificate Parsed = this.getParsedCertificate();
        return Parsed.getName();
    }

    public String getCertSubjectAlternativeNames() {
        StringBuffer altNameSB = new StringBuffer("");
        String altNameString = null;
        try {
            Collection<List<?>> generalNames = this.certificateChain[0].getSubjectAlternativeNames();
            Iterator<List<?>> itr = generalNames.iterator();
            while (itr.hasNext()) {
                List<?> list = itr.next();
                int tagNo = (Integer)list.get(0);
                switch (tagNo) {
                    case 0: {
                        altNameSB.append(",otherName=");
                        break;
                    }
                    case 1: {
                        altNameSB.append(",rfc822Name=");
                        break;
                    }
                    case 2: {
                        altNameSB.append(",dNSName=");
                        break;
                    }
                    case 3: {
                        altNameSB.append(",x400Address=");
                        break;
                    }
                    case 4: {
                        altNameSB.append(",directoryName=");
                        break;
                    }
                    case 5: {
                        altNameSB.append(",ediPartyName=");
                        break;
                    }
                    case 6: {
                        altNameSB.append(",uniformResourceIdentifier=");
                        break;
                    }
                    case 7: {
                        altNameSB.append(",iPAddress=");
                        break;
                    }
                    case 8: {
                        altNameSB.append(",registeredID=");
                    }
                }
                altNameSB.append(list.get(1).toString());
                if (altNameSB.length() <= 0) continue;
                altNameString = altNameSB.substring(1, altNameSB.length());
            }
        }
        catch (Exception ex) {
            return null;
        }
        return altNameString;
    }

    private void extractCertificate() throws Exception {
        ByteArrayInputStream voidContentData = new ByteArrayInputStream(new byte[0]);
        CMSTypedStream typedIn = new CMSTypedStream((InputStream)voidContentData);
        CMSSignedDataParser parser = new CMSSignedDataParser(typedIn, this.signatureBytes);
        parser.getSignedContent().drain();
        CertStore certs = null;
        try {
            if (Security.getProvider("BC") == null) {
                Provider p = (Provider)this.getClass().getClassLoader().loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
                Security.addProvider(p);
            }
            certs = parser.getCertificatesAndCRLs("Collection", "BC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SignerInformationStore signersStore = parser.getSignerInfos();
        Collection signers = signersStore.getSigners();
        Iterator it = signers.iterator();
        if (it.hasNext()) {
            ASN1Set values;
            Attribute att;
            X509Certificate userCertificate = null;
            SignerInformation signer = null;
            signer = (SignerInformation)it.next();
            Collection<? extends Certificate> certCollection = certs.getCertificates((CertSelector)signer.getSID());
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            if (certIt.hasNext()) {
                userCertificate = (X509Certificate)certIt.next();
            }
            certCollection = certs.getCertificates(null);
            certIt = certCollection.iterator();
            LinkedList<Certificate> allCertificates = new LinkedList<Certificate>();
            while (certIt.hasNext()) {
                allCertificates.addFirst(certIt.next());
            }
            boolean finishExtraction = allCertificates.size() == 0;
            X509Certificate currentCertificate = userCertificate;
            LinkedList<X509Certificate> certificateChainList = new LinkedList<X509Certificate>();
            certificateChainList.addFirst(userCertificate);
            while (!finishExtraction) {
                ListIterator iterator = allCertificates.listIterator();
                boolean nextCertificate = false;
                X509Certificate certificateFromIterator = null;
                while (iterator.hasNext() && !nextCertificate) {
                    certificateFromIterator = (X509Certificate)iterator.next();
                    nextCertificate = ((Object)certificateFromIterator.getSubjectDN()).toString().compareTo(((Object)currentCertificate.getIssuerDN()).toString()) == 0;
                }
                if (nextCertificate) {
                    certificateChainList.addLast(certificateFromIterator);
                    currentCertificate = certificateFromIterator;
                }
                finishExtraction = !nextCertificate || ((Object)currentCertificate.getIssuerDN()).toString().compareTo(((Object)currentCertificate.getSubjectDN()).toString()) == 0;
            }
            this.certificateChain = certificateChainList.toArray(new X509Certificate[certificateChainList.size()]);
            if (signer.getUnsignedAttributes() != null && (att = signer.getUnsignedAttributes().get(new DERObjectIdentifier("1.2.840.113549.1.9.16.2.14"))) != null && (values = att.getAttrValues()).size() > 0) {
                DEREncodable token = values.getObjectAt(0);
                CMSSignedDataParser parserTS = new CMSSignedDataParser(token.getDERObject().getDEREncoded());
                CMSTypedStream content = parserTS.getSignedContent();
                ASN1InputStream tsInput = new ASN1InputStream(content.getContentStream());
                DERObject obj = tsInput.readObject();
                TSTInfo tstInfo = new TSTInfo((ASN1Sequence)obj);
                this.timeStamp = tstInfo.getGenTime().getDate();
            }
        } else {
            throw new SignatureVerifyException((Throwable)new Exception("No signer"));
        }
    }

    private boolean isInvertedCertificateChain(X509Certificate[] certificateChain) {
        return this.isRootCA(certificateChain[0]);
    }

    private void invertCertificateChain(X509Certificate[] certificateChain) {
        for (int i = 0; i < certificateChain.length / 2; ++i) {
            X509Certificate certificate = certificateChain[i];
            certificateChain[i] = certificateChain[certificateChain.length - 1 - i];
            certificateChain[certificateChain.length - 1 - i] = certificate;
        }
    }

    private boolean isRootCA(X509Certificate cert) {
        boolean isRootCa = false;
        try {
            SignaturaProperties signaturaProperties = new SignaturaProperties();
            String[] roots = signaturaProperties.getRootCAs();
            String commonName = SMIMESignatureImpl.getCACommonName(cert);
            for (int i = 0; i < roots.length && !isRootCa; ++i) {
                isRootCa = roots[i].compareTo(commonName) == 0;
            }
        }
        catch (Exception e) {
            return true;
        }
        return isRootCa;
    }

    private static String getCACommonName(X509Certificate cert) throws IOException, CertificateEncodingException {
        String ou = "";
        byte[] b = cert.getEncoded();
        ASN1InputStream asn1is = new ASN1InputStream(b);
        DERObject obj = asn1is.readObject();
        X509CertificateStructure certificate = new X509CertificateStructure((ASN1Sequence)obj);
        asn1is.close();
        X509Name name = certificate.getIssuer();
        Vector v = name.getOIDs();
        Vector value = name.getValues();
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i).equals(X509Name.CN)) {
                if (SigDebug.isActive()) {
                    SigDebug.write((String)("getCACommonName(): " + value.get(i).toString()));
                }
                return value.get(i).toString();
            }
            if (!v.get(i).equals(X509Name.OU)) continue;
            ou = value.get(i).toString();
        }
        if (SigDebug.isActive()) {
            SigDebug.write((String)("getCACommonName(): " + ou));
        }
        return ou;
    }

    protected X509Certificate[] getTimeStampCertificates(Collection certCollection) throws Exception {
        Iterator certIt = certCollection.iterator();
        Vector v = new Vector();
        while (certIt.hasNext()) {
            v.add(certIt.next());
        }
        return v.toArray(new X509Certificate[v.size()]);
    }

    public Date getDate() throws SignatureTimestampException {
        return this.timeStamp;
    }

    public boolean verify() throws SignatureVerifyException {
        try {
            this.certificateChain[0].checkValidity();
        }
        catch (CertificateExpiredException cee) {
            System.out.println("CMSSignature Certificat rebutjat, el certificat ha caducat.");
            return false;
        }
        catch (CertificateNotYetValidException cve) {
            System.out.println("CMSSignature Certificat rebutjat, el certificat encara no \u00e9s v\u00e0lid.");
            return false;
        }
        boolean isVerified = true;
        try {
            X509Certificate[] certificateChain = this.getCertificateChain();
            X509Certificate[] validationCertificateChain = new X509Certificate[certificateChain.length];
            for (int i = 0; i < validationCertificateChain.length; ++i) {
                validationCertificateChain[i] = certificateChain[i];
            }
            ValidadorProxy validador = new ValidadorProxy();
            if (validador.isValidadorInstalado()) {
                ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    SignaturaProperties properties = new SignaturaProperties();
                    isVerified = !properties.needsRecognizedCertificate(this.contentType) ? validador.validarAutenticacion(validationCertificateChain) : validador.validarFirma(validationCertificateChain);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(prevCL);
                }
            }
            return isVerified;
        }
        catch (SignatureVerifyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureVerifyException((Throwable)e);
        }
    }

    public X509Certificate getCert() {
        return this.certificateChain[0];
    }

    public boolean verifyAPosterioriTimestamp(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        MIMEInputStream mimeContentStream = new MIMEInputStream(contentStream, this.contentType);
        return this.verifyAPosterioriTimestampRaw((InputStream)mimeContentStream);
    }

    protected boolean verifyAPosterioriTimestampRaw(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean verified = true;
        try {
            boolean timeStampVerified;
            boolean hasTimestamp;
            CMSTypedStream typedIn = new CMSTypedStream(contentStream);
            SignaturaProperties signaturaProperties = new SignaturaProperties();
            boolean needsTimestamp = signaturaProperties.needsTimeStamp(this.contentType);
            CMSSignedDataParser parser = new CMSSignedDataParser(typedIn, this.signatureBytes);
            CMSTypedStream da = parser.getSignedContent();
            parser.getSignedContent().drain();
            CertStore mainCerts = parser.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signersStore = parser.getSignerInfos();
            Collection signers = signersStore.getSigners();
            Iterator it = signers.iterator();
            if (it.hasNext()) {
                Attribute att;
                SignerInformation signer = (SignerInformation)it.next();
                boolean bl = verified = verified && signer.verify(this.certificateChain[0], "BC");
                if (!verified) {
                    verified = signer.verify(this.certificateChain[this.certificateChain.length - 1], "BC");
                }
                byte[] digest = signer.getContentDigest();
                hasTimestamp = false;
                timeStampVerified = false;
                if (signer.getUnsignedAttributes() != null && (att = signer.getUnsignedAttributes().get(new DERObjectIdentifier("1.2.840.113549.1.9.16.2.14"))) != null) {
                    hasTimestamp = true;
                    ASN1Set values = att.getAttrValues();
                    if (values.size() > 0) {
                        DEREncodable token = values.getObjectAt(0);
                        try {
                            CMSSignedData cmsSD = new CMSSignedData(token.getDERObject().getDEREncoded());
                            TimeStampToken tst = new TimeStampToken(cmsSD);
                            try {
                                timeStampVerified = this.verifyTimestamp(tst, signer, digest);
                            }
                            catch (Exception e) {
                                throw new SignatureVerifyException((Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (!hasTimestamp) {
                    return false;
                }
            } else {
                throw new SignatureVerifyException((Throwable)new Exception("No signer"));
            }
            verified = verified && (timeStampVerified && hasTimestamp && needsTimestamp || !needsTimestamp);
        }
        catch (Exception e) {
            throw new SignatureVerifyException((Throwable)e);
        }
        return verified;
    }

    public boolean verify(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        MIMEInputStream mimeContentStream = new MIMEInputStream(contentStream, this.contentType);
        return this.verifyRaw((InputStream)mimeContentStream);
    }

    protected boolean verifyRaw(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean verified = true;
        try {
            boolean timeStampVerified;
            boolean hasTimestamp;
            CMSTypedStream typedIn = new CMSTypedStream(contentStream);
            SignaturaProperties signaturaProperties = new SignaturaProperties();
            boolean needsTimestamp = signaturaProperties.needsTimeStamp(this.contentType);
            CMSSignedDataParser parser = new CMSSignedDataParser(typedIn, this.signatureBytes);
            CMSTypedStream da = parser.getSignedContent();
            parser.getSignedContent().drain();
            CertStore mainCerts = parser.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signersStore = parser.getSignerInfos();
            Collection signers = signersStore.getSigners();
            Iterator it = signers.iterator();
            if (it.hasNext()) {
                Attribute att;
                SignerInformation signer = (SignerInformation)it.next();
                for (int i = 0; i < this.certificateChain.length; ++i) {
                    X509Certificate certificate = this.certificateChain[i];
                }
                boolean bl = verified = verified && signer.verify(this.getCert(), "BC");
                if (!verified) {
                    verified = signer.verify(this.certificateChain[this.certificateChain.length - 1], "BC");
                }
                byte[] digest = signer.getContentDigest();
                hasTimestamp = false;
                timeStampVerified = false;
                if (signer.getUnsignedAttributes() != null && (att = signer.getUnsignedAttributes().get(new DERObjectIdentifier("1.2.840.113549.1.9.16.2.14"))) != null) {
                    hasTimestamp = true;
                    ASN1Set values = att.getAttrValues();
                    if (values.size() > 0) {
                        DEREncodable token = values.getObjectAt(0);
                        try {
                            CMSSignedData cmsSD = new CMSSignedData(token.getDERObject().getDEREncoded());
                            TimeStampToken tst = new TimeStampToken(cmsSD);
                            try {
                                timeStampVerified = this.verifyTimestamp(tst, signer, digest);
                            }
                            catch (Exception e) {
                                throw new SignatureVerifyException((Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            throw new SignatureVerifyException((Throwable)e);
                        }
                    }
                }
            } else {
                throw new SignatureVerifyException((Throwable)new Exception("No signer"));
            }
            verified = verified && (needsTimestamp && hasTimestamp && timeStampVerified || !needsTimestamp);
        }
        catch (Exception e) {
            throw new SignatureVerifyException((Throwable)e);
        }
        return verified;
    }

    protected boolean verifyTimestamp(TimeStampToken tst, SignerInformation si, byte[] documentDigest) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean timeStampVerified;
        block5: {
            timeStampVerified = false;
            try {
                Collection<? extends Certificate> certificates;
                CertStore certs;
                byte[] signatureDigest = SHA1Util.digest(si.getSignature());
                if (tst == null || (certs = tst.getCertificatesAndCRLs("Collection", "BC")) == null || (certificates = certs.getCertificates((CertSelector)tst.getSID())) == null || certificates.size() <= 0) break block5;
                X509Certificate timeStampCertificate = this.getTimeStampCertificates(certificates)[0];
                try {
                    tst.validate(timeStampCertificate, "BC");
                    timeStampVerified = true;
                    TimeStampTokenInfo tsTokenInfo = tst.getTimeStampInfo();
                    byte[] hashTimeStamp = tsTokenInfo.getMessageImprintDigest();
                    timeStampVerified = timeStampVerified && hashTimeStamp.length == signatureDigest.length;
                    for (int i = 0; i < signatureDigest.length && timeStampVerified; ++i) {
                        timeStampVerified = timeStampVerified && hashTimeStamp[i] == signatureDigest[i];
                    }
                }
                catch (Exception e) {
                    throw new SignatureVerifyException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw new SignatureVerifyException((Throwable)e);
            }
        }
        return timeStampVerified;
    }

    public ParsedCertificate getParsedCertificate() {
        try {
            return new ParsedCertificateImpl(this.certificateChain, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setContentType(String contentType) throws Exception {
        this.contentType = contentType;
    }

    public void setSignedData(byte[] pkcs7) throws Exception {
        this.signatureBytes = pkcs7;
        this.extractCertificate();
    }

    public byte[] getPkcs7() {
        return null;
    }
}

