/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.afirma.rfc3161.AFirmaURLStreamHandlerFactoryImpl;
import es.caib.signatura.afirma.rfc3161.RFC3161Connection;
import es.caib.signatura.afirma.rfc3161.TsaOutputStream;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.provider.impl.common.SHA1Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public class TimeStampManager {
    private SignaturaProperties properties = null;
    private static Random r = new Random(System.currentTimeMillis());
    private TimeStampToken lastTimeStampTokenGenerated = null;
    private static String OID_MAP_TSA2 = "1.3.4.6.1.3.4.6";

    public TimeStampToken getLastTimeStampTokenGenerated() {
        return this.lastTimeStampTokenGenerated;
    }

    private URL getURLPrincipal(X509Certificate cert) throws IOException, SignatureTimestampException {
        URL url;
        String proveidor;
        if (SigDebug.isActive()) {
            SigDebug.write((String)("Obtenint proveidor de segell de temps per " + cert.getIssuerX500Principal().getName()));
        }
        if ((proveidor = this.properties.getTimestampService(cert.getIssuerX500Principal().getName())) == null || proveidor.length() == 0) {
            proveidor = this.properties.getTimestampService("default");
        }
        if (proveidor == null || proveidor.length() == 0) {
            throw new SignatureTimestampException("No se ha configurado un servidor de sello de tiempo para " + cert.getIssuerX500Principal().getName());
        }
        if (SigDebug.isActive()) {
            SigDebug.write((String)("Trobat proveidor de segell de temps per " + cert.getIssuerX500Principal().getName() + ", \u00e9s: " + proveidor));
        }
        try {
            url = new URL(proveidor);
        }
        catch (MalformedURLException urle) {
            String protocol = proveidor.substring(0, proveidor.indexOf(":"));
            url = new URL(null, proveidor, new AFirmaURLStreamHandlerFactoryImpl().createURLStreamHandler(protocol));
        }
        return url;
    }

    private String getPrincipalApplicationId(X509Certificate cert) throws IOException, SignatureTimestampException {
        String applicationId;
        if (SigDebug.isActive()) {
            SigDebug.write((String)("Obtenint identificador applicationId per al segell de temps per " + cert.getIssuerX500Principal().getName()));
        }
        if ((applicationId = this.properties.getTimestampServiceApplicationId(cert.getIssuerX500Principal().getName())) == null) {
            applicationId = this.properties.getTimestampServiceApplicationId("default");
        }
        if (SigDebug.isActive()) {
            SigDebug.write((String)("Trobat applicationId del proveidor de segell de temps per " + cert.getIssuerX500Principal().getName() + ", \u00e9s: " + applicationId));
        }
        return applicationId;
    }

    private String getPrincipalPolicyId(X509Certificate cert) throws IOException, SignatureTimestampException {
        String policyOID;
        if (SigDebug.isActive()) {
            SigDebug.write((String)("Obtenint identificador policyOID per al segell de temps per " + cert.getIssuerX500Principal().getName()));
        }
        if ((policyOID = this.properties.getTimestampServicePolicyOID(cert.getIssuerX500Principal().getName())) == null) {
            policyOID = this.properties.getTimestampServicePolicyOID("default");
        }
        if (SigDebug.isActive()) {
            SigDebug.write((String)("Trobat policyOID del proveidor de segell de temps per " + cert.getIssuerX500Principal().getName() + ", \u00e9s: " + policyOID));
        }
        return policyOID;
    }

    public TimeStampManager() {
        try {
            this.properties = new SignaturaProperties();
        }
        catch (Exception e) {
            throw new Error("No se ha podido obtener la configuraci\u00f3n de la API de firma digital.", e);
        }
    }

    private TimeStampToken generateTimeStamp(X509Certificate cert, byte[] digest, String digestAlgorithm) throws IOException, TSPException, SignatureTimestampException {
        try {
            String policyOID;
            TimeStampRequestGenerator generator = new TimeStampRequestGenerator();
            generator.setCertReq(true);
            String applicationId = this.getPrincipalApplicationId(cert);
            if (applicationId != null && !"".equals(applicationId)) {
                generator.addExtension(OID_MAP_TSA2, false, (ASN1Encodable)new DEROctetString(applicationId.getBytes()));
            }
            if ((policyOID = this.getPrincipalPolicyId(cert)) != null && !"".equals(policyOID)) {
                generator.setReqPolicy(policyOID);
            }
            byte[] nonce = new byte[16];
            r.nextBytes(nonce);
            TimeStampRequest req = generator.generate(digestAlgorithm, digest, new BigInteger(nonce));
            URL url = this.getURLPrincipal(cert);
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                return this.getHTTPTimestamp(conn, req);
            }
            if (conn instanceof RFC3161Connection) {
                return this.getRFC3161TimeStamp((RFC3161Connection)conn, req);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignatureTimestampException((Throwable)e);
        }
        return null;
    }

    private TimeStampToken getRFC3161TimeStamp(RFC3161Connection conn, TimeStampRequest req) throws IOException, SignatureTimestampException, TSPException, CMSException {
        TsaOutputStream dataoutputstream = conn.getTsaOutputStream();
        dataoutputstream.write(req.getEncoded());
        dataoutputstream.flush();
        DERSequence asn = (DERSequence)conn.getTsaInputStream().readObject();
        DERSequence info = (DERSequence)asn.getObjectAt(0);
        DERInteger status = (DERInteger)info.getObjectAt(0);
        dataoutputstream.close();
        conn.getTsaInputStream().close();
        if (status.getValue().intValue() != 0 && status.getValue().intValue() != 1) {
            throw new SignatureTimestampException("No se ha podido obtener el sello de tiempo RFC3161: " + status.getValue().intValue());
        }
        return new TimeStampToken(new CMSSignedData(asn.getObjectAt(1).getDERObject().getDEREncoded()));
    }

    private TimeStampToken getHTTPTimestamp(URLConnection conn, TimeStampRequest req) throws IOException, TSPException, SignatureTimestampException {
        conn.setRequestProperty("Content-Type", "application/timestamp-query");
        ((HttpURLConnection)conn).setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDefaultUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        OutputStream out = conn.getOutputStream();
        out.write(req.getEncoded());
        out.flush();
        out.close();
        InputStream in = conn.getInputStream();
        TimeStampResponse response = new TimeStampResponse(in);
        in.close();
        response.validate(req);
        if (response.getFailInfo() != null) {
            throw new SignatureTimestampException("No se ha podido obtener el sello de tiempo: PKIFailInfo:" + response.getFailInfo());
        }
        return response.getTimeStampToken();
    }

    public CMSSignedData addTimestamp(X509Certificate cert, CMSSignedData signedData, byte[] digest, String algorithm) throws IOException, TSPException, SignatureTimestampException {
        try {
            Collection ss = signedData.getSignerInfos().getSigners();
            SignerInformation si = (SignerInformation)ss.iterator().next();
            TimeStampToken tok = this.generateTimeStamp(cert, digest, algorithm);
            ASN1InputStream asn1InputStream = new ASN1InputStream(tok.getEncoded());
            DERObject tstDER = asn1InputStream.readObject();
            DERSet ds = new DERSet((DEREncodable)tstDER);
            Attribute a = new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.16.2.14"), (ASN1Set)ds);
            DEREncodableVector dv = new DEREncodableVector();
            dv.add((DEREncodable)a);
            AttributeTable at = new AttributeTable(dv);
            si = SignerInformation.replaceUnsignedAttributes((SignerInformation)si, (AttributeTable)at);
            ss.clear();
            ss.add(si);
            SignerInformationStore sis = new SignerInformationStore(ss);
            signedData = CMSSignedData.replaceSigners((CMSSignedData)signedData, (SignerInformationStore)sis);
            this.lastTimeStampTokenGenerated = tok;
        }
        catch (Exception e) {
            return null;
        }
        return signedData;
    }

    public CMSSignedData addTimestamp(X509Certificate cert, CMSSignedData signedData) throws IOException, TSPException, SignatureTimestampException {
        byte[] digest;
        Collection ss = signedData.getSignerInfos().getSigners();
        SignerInformation si = (SignerInformation)ss.iterator().next();
        try {
            digest = SHA1Util.digest(si.getSignature());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureTimestampException((Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw new SignatureTimestampException((Throwable)e);
        }
        return this.addTimestamp(cert, signedData, digest, TSPAlgorithms.SHA1);
    }

    public CMSSignedData addWrongTimestamp(X509Certificate cert, CMSSignedData signedData, byte[] digest, String digestAlogrithm) throws IOException, TSPException, SignatureTimestampException {
        return signedData;
    }

    public Date getTimeStamp(X509Certificate cert) throws IOException, TSPException, SignatureTimestampException {
        TimeStampRequestGenerator generator = new TimeStampRequestGenerator();
        generator.setCertReq(true);
        byte[] nonce = new byte[16];
        r.nextBytes(nonce);
        byte[] emptyBuffer = new byte[new SHA1Digest().getDigestSize()];
        TimeStampRequest req = generator.generate(TSPAlgorithms.SHA1, emptyBuffer, new BigInteger(nonce));
        byte[] encoded = req.getEncoded();
        URL url = this.getURLPrincipal(cert);
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("Host", url.getHost() + ":" + url.getPort());
        conn.setRequestProperty("Content-type", "application/timestamp-query");
        conn.setRequestProperty("Content-length", Integer.toString(encoded.length));
        conn.setDoInput(true);
        conn.setDoOutput(true);
        OutputStream out = conn.getOutputStream();
        out.write(encoded);
        out.flush();
        out.close();
        InputStream in = conn.getInputStream();
        TimeStampResponse response = new TimeStampResponse(in);
        in.close();
        response.validate(req);
        return response.getTimeStampToken().getTimeStampInfo().getGenTime();
    }
}

