package es.caib.signatura.api;

import java.io.IOException;
import java.security.cert.X509Certificate;


	/** 
	 * Interface to access to the information contained into a digital certificate. It provides needed methods to get different attributes
	 * of the certificate.
	 * 
	 * @author Pau Carré Cardona
	 * @version 1.0
	 * @see Certificate
	 * 
	 */

public interface Certificate {
	
	/**
	 * Gets the name of the certification authority.
	 * 
	 * @return the name of the certificate authority.
	 */
	public String getCertCaName();

	/**
	 * Gets the subject's Common Name of the certificate.
	 * 
	 * @return the subject common name.
	 */
	public String getCertSubjectCommonName();

	/**
	 * 
	 * Gets the concatenation of the subject's alternate name as follows: name0 = value, name1 = value, ...
	 * 
	 * @return a string containing the subject's alternate name of the certificate.
	 */
	public String getCertSubjectAlternativeNames();


	/**
	 * Returns the X509 Certificate.
	 * 
	 * @return the X509Certificate.
	 */  
	public X509Certificate getCert();
	  
	/**
	 * Gets a ParsedCertificate object with the subject's credentials.
	 * 
	 * @return a ParsedCertificate object with the subject's credentials.
	 */  
	public ParsedCertificate getParsedCertificate();

	/**
	 * 
	 * Verify the certificate and its certification chain.
	 * 
	 * @return <code>true</code> if verification is successful <code>false</code> otherwise.
	 * 
	 * @throws IOException if unable to access to the file.
	 * @throws CertificateVerifyException if it hasn't been able to finish the verification process.
	 */
	public  boolean verify()
    	throws IOException, CertificateVerifyException;
		
}
