package es.caib.signatura.api;

/**
 * Interface to access to the certificate information. It abstracts subject's information encoding.
 */
public interface ParsedCertificate {

	/**
	 * Gets the NIF/CIF of the certificate holder.
	 * In case of legal persons, it gets the CIF of the legal person.
	 * 
	 * @return the subject NIF.
	 */
	public abstract String getNif();

	/**
	 * Gets the subject's common name of the certificate.
	 * 
	 * @return the subject's common name.
	 */
	public abstract String getName();

	/**
	 * Gets the NIF of the responsible person for the certificate. Only applies if it's a legal person's certificate.
	 * 
	 * @return the responsible person's NIF
	 */
	public abstract String getNifResponsable();

	/**
	 * Determines if it is a natural person's certificate.
	 * 
	 * @return true if it is a natural person's certificate; false otherwise.
	 */
	public abstract boolean isPersonaFisica();

	/**
	 * Determines if it is a legal person's certificate (not natural person's certificate).
	 * 
	 * @return true if it is a legal person's certificate; false otherwise.
	 */
	public abstract boolean isPersonaJuridica();

}