package es.caib.signatura.api;

import java.io.IOException;
import java.io.InputStream;
/**
 * Interfaz que define los métodos de un intérprete de smimes. 
 * @author u91940
 *
 */

public interface SMIMEParser {
	/**
	 * Devuelve un nuevo intérprete para el smime pasado como argumento
	 * @param smime Documento a interpretar
	 * @return Nuevo intérprete para el documento pasado como argumento
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws IOException
	 * @throws SignatureException
	 */
	public SMIMEParser getInstance(InputStream smime) throws InstantiationException, IllegalAccessException, IOException, SignatureException ;
	
	/**
	 * Interpreta el documento smime pasado como argumento
	 * @param mimeIS Documento a interpretar
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws IOException
	 * @throws SignatureException
	 */
	public void parse(InputStream mimeIS) throws InstantiationException, IllegalAccessException, IOException, SignatureException ;

	/**
	 * Devuelve el objeto firmado que contiene el smime. Suele devolver un array de bytes.
	 * @return Objeto que ha sido firmado (normalmente como byte[])
	 */
	public Object getSignedObject();
	
	/**
	 * Desagrupa las firmas que contiene el smime para poder tratarlas individualmente, y las devuelve en un array.
	 * 
	 * @return Firmas que contiene el documento desagrupadas.
	 */
	public Signature [] getSignatures();

}
