package es.caib.signatura.api;

import java.net.URL;

/**
 * Excepción que se produce cuando el componente local del API de firma necesita ser actualizado
 * 
 * @author u07286
 *
 */
public class UpgradeNeededException extends Exception {

	private URL  url;
	
	/**
	 * Constructor
	 * 
	 * @param message
	 * @param url
	 * @param cause
	 */
	public UpgradeNeededException(String message, URL url, Throwable cause) {
		super(message, cause);
		this.url = url;
	}

	/** 
	 * Constructor
	 * 
	 * @param message
	 * @param url
	 */
	public UpgradeNeededException(String message, URL url) {
		super(message);
		this.url = url;
	}

	/**
	 * Obtener la URL desde la cual se puede actualizar. Normalmente será un enlace al
	 * descriptor Java Web Start.
	 * <br>
	 * Véase el código de ejemplo para saber cómo acceder a la URL en función de si se 
	 * está ejecutando desde un applet o una aplicación Swing.
	 * 
	 * @return URL de actualización
	 */
	public URL getUrl() {
		return url;
	}

}
