package es.caib.signatura.impl;

import java.io.FileDescriptor;
import java.io.FilePermission;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;

public class CAIBSecurityManager extends java.lang.SecurityManager {
	private java.lang.SecurityManager proxy;
	private static boolean isRegistered = false;
	private ClassLoader trustedClassLoader;
	private ClassLoader systemClassLoader;
	private ThreadLocal checkIn = new ThreadLocal() {
		private boolean ckechInBoolean = false; 
        protected synchronized Object initialValue() {
            return new Boolean(ckechInBoolean);
        }
        public synchronized void set(Object booleanObject) {
        	if(booleanObject != null){
        		if(booleanObject instanceof Boolean){
        			Boolean booleanValue = (Boolean)booleanObject;
        			ckechInBoolean = booleanValue.booleanValue();
        		}
        	}
        }
        public synchronized Object get() {
            return new Boolean(ckechInBoolean);
        }
    };


	private boolean hasAllPermission ()
	{
		if ( getInCheck() )
			return true;
		try{
			checkIn.set(new Boolean(true));
			Class classes [] = getClassContext();
			for (int i = classes.length - 1; i >= 0; i--)
			{
				try{
					ClassLoader cl = classes[i].getClassLoader();
					if (classes[i] != CAIBSecurityManager.class &&
						cl == CAIBSecurityManager.class.getClassLoader() &&
						classes[i].getPackage().getName().startsWith("es.caib.signatura."))
					{
						checkIn.set(new Boolean(false));
						return true;
					}
				}catch(Exception e){
					System.out.println("WARNING. Excepcion en security manager:");
					e.printStackTrace(System.out);
					/*
					 * Se ignora la excepcion dado que 
					 * se puede dar que alguna clase 
					 * no se pueda inicializar
					 */
				}
			}
		}finally{
			checkIn.set(new Boolean(false));			
		}
		return false;
	}
	
	
	public static void register ()
	{
		AccessController.doPrivileged(
				new PrivilegedAction() {
					public Object run() {
						try {
							if ( ! isRegistered  && System.getSecurityManager() != null)
							{
								System.setSecurityManager( new CAIBSecurityManager (System.getSecurityManager()));
								isRegistered = true;
							}
						} catch (Throwable t) {
							t.printStackTrace() ;
						}
						return null;
					};
				}
			);
	}
	
	public CAIBSecurityManager(java.lang.SecurityManager proxy) {
		this.proxy = proxy;
		try {
			trustedClassLoader = ClassLoaderFactory.getFactory().getMasterClassLoader();
			systemClassLoader = getClass().getClassLoader();
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}

	public void checkAccept(String host, int port) {
		proxy.checkAccept(host, port);
	}

	public void checkAccess(Thread t) {
		proxy.checkAccess(t);
	}

	public void checkAccess(ThreadGroup g) {
		proxy.checkAccess(g);
	}

	public void checkAwtEventQueueAccess() {
		proxy.checkAwtEventQueueAccess();
	}

	public void checkConnect(String host, int port, Object context) {
		if (! hasAllPermission())
			proxy.checkConnect(host, port, context);
	}

	public void checkConnect(String host, int port) {
		if (hasAllPermission())
			return;
		proxy.checkConnect(host, port);
	}

	public void checkCreateClassLoader() {
		if (!hasAllPermission())
			proxy.checkCreateClassLoader();
	}

	public void checkDelete(String file) {
		if (hasAllPermission() && 
				file.startsWith(System.getProperty("java.io.tmpdir")) && 
				file.endsWith("pkcs11.cfg"))
			return;
		proxy.checkDelete(file);
	}

	public void checkExec(String cmd) {
		if (! hasAllPermission())
			proxy.checkExec(cmd);
	}

	public void checkExit(int status) {
		proxy.checkExit(status);
	}

	public void checkLink(String lib) {
		if (! hasAllPermission())
			proxy.checkLink(lib);
}

	public void checkListen(int port) {
		proxy.checkListen(port);
	}
	
	public void checkMemberAccess(Class arg0, int arg1) {
		if(hasAllPermission()){
			return;
		}
		proxy.checkMemberAccess(arg0, arg1);
	}

	public void checkMulticast(InetAddress maddr, byte ttl) {
		proxy.checkMulticast(maddr, ttl);
	}

	public void checkMulticast(InetAddress maddr) {
		proxy.checkMulticast(maddr);
	}

	public void checkPackageAccess(String pkg) {
		 if(hasAllPermission()){
			 return;
		 }
		if (pkg.startsWith("sun.security.pkcs11")){
			return ;
		}
		proxy.checkPackageAccess(pkg);
		
	}

	public void checkPackageDefinition(String pkg) {
		proxy.checkPackageDefinition(pkg);
	}

	public void checkPermission(Permission perm, Object context) {
		if( perm instanceof java.util.logging.LoggingPermission && hasAllPermission()){
			return;
		}
		if(perm instanceof java.lang.RuntimePermission && hasAllPermission()){
			return;
		}
		proxy.checkPermission(perm, context);
	}

	public void checkPermission(Permission perm) {
		if (perm instanceof FilePermission)
		{
			FilePermission fperm = (FilePermission) perm;
			if ("read".equals(fperm.getActions()) && hasAllPermission())
			{
				return;
			}
		}
		if (perm instanceof SecurityPermission && perm.getName().startsWith("authProvider.SunPKCS11-"))
			return;
		
		if(perm instanceof java.util.logging.LoggingPermission && hasAllPermission()){
			return;
		}
		if(perm instanceof java.lang.RuntimePermission && hasAllPermission()){
			return;
		}
		
		/**PJR: añadimos permisos para poder añadir el nuevo proveedor del protocolo de afirma rfc3161 **/
		if(perm instanceof java.net.NetPermission &&  "specifyStreamHandler".equals(perm.getName()) && hasAllPermission()){
			return;
		}
		
		proxy.checkPermission(perm);
	}

	public void checkPrintJobAccess() {
		proxy.checkPrintJobAccess();
	}

	public void checkPropertiesAccess() {
		if (! hasAllPermission())
			proxy.checkPropertiesAccess();
	}

	public void checkPropertyAccess(String key) {

		if (! hasAllPermission())
			proxy.checkPropertyAccess(key);
	}

	public void checkRead(FileDescriptor fd) {

		if (! hasAllPermission())
			proxy.checkRead(fd);
	}

	public void checkRead(String file, Object context) {	

		if (! hasAllPermission())
			proxy.checkRead(file, context);
	}

	public void checkRead(String file) {	

		if (! hasAllPermission())
			proxy.checkRead(file);
	}

	public void checkSecurityAccess(String target) {		
		if ( (target.startsWith("putProviderProperty.") ||
				target.startsWith ("insertProvider.")) &&
			hasAllPermission())
		{
			return ;
		}
		proxy.checkSecurityAccess(target);
	}

	public void checkSetFactory() {	

		proxy.checkSetFactory();
	}

	public void checkSystemClipboardAccess() {	

		proxy.checkSystemClipboardAccess();
	}

	public boolean checkTopLevelWindow(Object window) {	

		return proxy.checkTopLevelWindow(window);
	}

	public void checkWrite(FileDescriptor fd) {	

		if(hasAllPermission()) return;
		proxy.checkWrite(fd);
	}

	public void checkWrite(String file) {
		if (hasAllPermission() && (
				file.startsWith(System.getProperty("java.io.tmpdir")) && 
				file.endsWith("pkcs11.cfg") ||
				file.equals(System.getProperty("java.home")+"/lib/signaturacaib/signatura_api.properties")  ||
				file.contains("serviceLog.txt")
				)
			)
			return;
		proxy.checkWrite(file);
	}

	public boolean equals(Object obj) {	

		return proxy.equals(obj);
	}

	public boolean getInCheck() {
		boolean toReturn = false;
		if(checkIn.get() != null){
			if(checkIn.get() instanceof Boolean){
				if(((Boolean)checkIn.get()).booleanValue()){
					toReturn = true;
				}
			}
		}
		toReturn = toReturn || proxy.getInCheck();
		return toReturn;
	}

	public Object getSecurityContext() {

		return proxy.getSecurityContext();
	}

	public ThreadGroup getThreadGroup() {
		return proxy.getThreadGroup();
	}

	public int hashCode() {
		return proxy.hashCode();
	}

	public String toString() {
		return proxy.toString();
	}
	
}
