package es.caib.signatura.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;

public class ClassLoaderFactory {
	private static ClassLoaderFactory theFactory = null;
	private static ClassLoader masterClassLoader = null;
	private static Hashtable childClassLoader = new Hashtable();
	private static File libDir = null;
	
	private ClassLoaderFactory () throws FileNotFoundException
	{
		//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: ClassLoaderFactory:enter" );
		if (masterClassLoader == null)
		{
			try {
				libDir = locateSignaturaDir();
				masterClassLoader = createClassLoader (libDir, getClass().getClassLoader());
			} catch (Throwable e){			
			}
		}
		//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: ClassLoaderFactory: return" );
	}

	/**
	 * 
	 */
	private File locateSignaturaDir() {
		File libDir = null;
		try {
			String signaturaDir = System.getProperty ("es.caib.signatura.library_path");
			if (signaturaDir != null)
			{
				File sigDir = new File(signaturaDir);
				if (sigDir.isAbsolute() && sigDir.isDirectory())
					libDir = sigDir;
				else 
				{
					//* DEBUG OFF */ System.out.println("Signaturadir no absolute");
					URL url = this.getClass().getResource("ClassLoaderFactory.class");
					if ("jar".equals(url.getProtocol()))
					{
						int i  = url.getFile().lastIndexOf('!');
						if (i > 0)
						{
							URL jarFileUrl = new URL(url.getFile().substring(0, i));
							if ("file".equals(jarFileUrl.getProtocol()))
							{
								File f = new File (jarFileUrl.getFile());
								File newLibDir = new File (f.getParentFile(), signaturaDir);
								//* DEBUG OFF */ System.out.println ("newlibdir="+newLibDir.getPath());
								if (newLibDir.isDirectory())
								{
									libDir = newLibDir;
								}
							}
						}
					}
				}
			}
		} catch (Throwable e) {
			e.printStackTrace();
		}
		if (libDir == null)
		{
			String java_home = System.getProperty("java.home");
			libDir = new File (new File (java_home), "lib/signaturacaib");
		}
		return libDir;
	}
	
	public static synchronized  ClassLoaderFactory getFactory () throws FileNotFoundException
	{
		//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: getFactory:enter" );
		if (theFactory == null) {
			//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: getFactory:new LoaderFactory" );
			theFactory = new ClassLoaderFactory ();
		}
		//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: getFactory:return" );
		return theFactory;
	}

	public File getLibraryDir ()
	{
		return libDir;
	}
	
	
	private synchronized static URLClassLoader createClassLoader(File dir, ClassLoader parentClassLoader) throws FileNotFoundException {
		//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: createClassLoader:enter " + dir.toString() );
		File files [] = dir.listFiles();
		if (files == null) {
			throw new FileNotFoundException(dir.getPath());
		}

		URL urls [] = new URL [ files.length ];
		for (int i = 0; i < files.length; i++)
		{
			try {
				urls [ i ] = files [ i ] .toURL();
				//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: createClassLoader: new url " + urls[i] );
			} catch (MalformedURLException e) {
				System.err.println(e.toString());
			}
		}

		//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: createClassLoader: new URLClassLoader " + urls.toString() );
		return new ExclusiveURLClassLoader (urls, parentClassLoader);
	}

	public synchronized  ClassLoader getMasterClassLoader ()
	{
		return masterClassLoader;
	}
	
	public synchronized ClassLoader getClassLoader(String name) throws FileNotFoundException
	{
		//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: getClassLoader: enter" );
		ClassLoader c = (ClassLoader) childClassLoader.get(name);
		if (c == null)
		{
			//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: getClassLoader: createClassLoader " + libDir + ", " + name  );
			c = createClassLoader (new File (libDir, name), getMasterClassLoader());
			childClassLoader.put(name, c);
		}
		//* DEBUG OFF */ System.out.println( "DEBUG ClassLoaderFactory: getClassLoader: return" );
		return c;
	}
}
