package es.caib.signatura.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;

import sun.misc.CompoundEnumeration;

/**
 * Classloader que carrega una llista de classes de manera exclusiva.
 * 
 * @author u91940
 * 
 */
public class ExclusiveURLClassLoader extends URLClassLoader {

	public ExclusiveURLClassLoader(URL[] arg0) {
		super(arg0);

	}

	public ExclusiveURLClassLoader(URL[] arg0, ClassLoader arg1) {
		super(arg0, arg1);

	}

	public ExclusiveURLClassLoader(URL[] arg0, ClassLoader arg1,
			URLStreamHandlerFactory arg2) {
		super(arg0, arg1, arg2);

	}

	/**
	 * 
	 * Busca i carrega una classe, per� mirant primer si est� en el directori de
	 * classes exclusives. Si no el troba, solicita al classloader delegat que
	 * ho provi de carregar ell.
	 */

	protected synchronized Class loadClass(String name, boolean resolve)
			throws ClassNotFoundException {
		// Primer mirem si ja està carregada
		try {
			Class c = findLoadedClass(name);
			if (c == null) {
				try {
					c = findClass(name);
				} catch (ClassNotFoundException e) {
					// Solicitem la c�rrega al classloader delegat
					if (getParent() != null) {
						c = getParent().loadClass(name);
					} else {
						c = ClassLoader.getSystemClassLoader().loadClass(name);
					}

				}
			}
			if (resolve) {
				resolveClass(c);
			}
			return c;
		} catch (RuntimeException t) {
			t.printStackTrace(System.out);
			throw t;
		} catch (Error t) {
			t.printStackTrace(System.out);
			throw t;
		} finally {
		}
	}

	public URL getResource(String name) {
		URL url;

		url = findResource(name);

		if (url == null) {
			if (getParent() != null)
				url = getParent().getResource(name);
			else
				url = ClassLoader.getSystemResource(name);
		}
		return url;
	}

	/***************************************************************************
	 * public Enumeration getResources(String name) throws IOException {
	 * Enumeration[] tmp = new Enumeration[2];
	 * 
	 * tmp[0] = findResources(name);
	 * 
	 * if (getParent() != null) { tmp[0] = getParent().getResources(name); }
	 * 
	 * 
	 * return new CompoundEnumeration(tmp); }
	 **************************************************************************/

}
