package es.caib.signatura.impl;

import es.caib.signatura.api.Signature;

import java.io.InputStream;

public interface GeneradorSMIMEParalelo {

  /**
   * Devuelve un SMIME a partir del documento original que se obtiene del <code>contentStream</code> con las firmas
   * indicadas en <code>firmas</code> en paralelo en el SMIME. 
   * @param contentStream El flujo de datos del que leer el documento original. 
   * @param firmas El conjunto de firmas que se anyadiran en paralelo.
   * @return Un flujo de datos que contiene el SMIME firmado en paraelelo. 
   */
   public SMIMEInputStream generarSMIMEParalelo(InputStream contentStream, Signature[] signatures) throws Exception;
  
}
