package es.caib.signatura.impl;

import es.caib.signatura.api.ParsedCertificate;

public class ParsedCertificateProxy implements ParsedCertificate {
	private boolean personaFisica;
	private boolean personaJuridica;
	private String name;
	private String nif;
	private String nifResponsable;
	
	public ParsedCertificateProxy (ParsedCertificate parsed)
	{
		personaFisica = parsed.isPersonaFisica();
		personaJuridica = parsed.isPersonaJuridica();
		name = parsed.getName();
		nif = parsed.getNif();
		nifResponsable = parsed.getNifResponsable();
	}
	/**
	 * @return the personaFisica
	 */
	public boolean isPersonaFisica() {
		return personaFisica;
	}
	/**
	 * @param personaFisica the personaFisica to set
	 */
	public void setPersonaFisica(boolean personaFisica) {
		this.personaFisica = personaFisica;
	}
	/**
	 * @return the personaJuridica
	 */
	public boolean isPersonaJuridica() {
		return personaJuridica;
	}
	/**
	 * @param personaJuridica the personaJuridica to set
	 */
	public void setPersonaJuridica(boolean personaJuridica) {
		this.personaJuridica = personaJuridica;
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return the nif
	 */
	public String getNif() {
		return nif;
	}
	/**
	 * @param nif the nif to set
	 */
	public void setNif(String nif) {
		this.nif = nif;
	}
	/**
	 * @return the nifResponsable
	 */
	public String getNifResponsable() {
		return nifResponsable;
	}
	/**
	 * @param nifResponsable the nifResponsable to set
	 */
	public void setNifResponsable(String nifResponsable) {
		this.nifResponsable = nifResponsable;
	}
	

}
