package es.caib.signatura.impl;

import java.io.File;
import java.io.FileWriter;
// import java.io.InputStream;
import java.io.Writer;
// import java.util.Properties;


public class SigDebug {
	public static final int DEBUG_LEVEL_NONE = 0;
	public static final int DEBUG_LEVEL_NORMAL = 1;
	public static final int DEBUG_LEVEL_VERBOSE = 2;
	
	private static int level = 0;
	private static boolean active = true;
	private static boolean verbose = true;
	
	private static String missatge = null;
	
	private static File fitxerDebug = null;
	
	public static final String NL = "\n";
	
	public static void setLevel( int l ) {
		level = l;
		active = level > 0;
		verbose = level > 1;
	}

	public static void setLevel( String l ) {
		try {
			if( l != null && l.length() > 0 ) {
				setLevel( Integer.parseInt( l ) );
			}
		} catch(Throwable t) { }
	}

	public static void setFitxerDebug( File f ) {
		fitxerDebug = f;
	}

	/**
	 * Escribe el mensaje de debug al log correspondiente.
	 * 
	 * @param msg Mensaje a escribir.
	 */
	public static void write( String msg ) {
		System.out.println( msg );
		System.out.flush();
		if( fitxerDebug != null ) 
		{
			try {
				Writer log = new FileWriter( fitxerDebug, true );
				log.write( msg + NL );
				log.flush();
				log.close();
			} catch( Exception e ) {
				e.printStackTrace();
			}
		}
		/*else
		{
			System.out.println( msg );
			System.out.flush();
		}*/
	}
	
	public static boolean isActive()
	{
		return active;
	}
	
	public static boolean isVerbose()
	{
		return verbose;
	}

	public static int getLevel()
	{
		return level;
	}
}
