package es.caib.signatura.impl;

import java.net.URL;
import java.net.URLEncoder;

import es.caib.signatura.api.SignerFactory;



/**
 * 
 */
public class SigUtil
{

	// Codigo de los sistemas operativos.
	public static String		OS_UNAVAILABLE		= "No disponible";

	public static String		OS_UNKNOWN			= "Desconocido";

	public static String		OS_WINDOWS			= "windows";

	public static String		OS_LINUX			= "Linux";

	public static String		OS_MAC				= "Mac";

	public static String		OS_REGEXP_WINDOWS	= "\\A(?i:win).*\\z";

	// 	Comença per win, ignore case.

	public static String		OS_REGEXP_LINUX		= "\\A(?i:linux).*\\z";

	// 	Comença per linux, ignore case.

	public static String		OS_REGEXP_MAC		= "\\A(?i:mac).*\\z";

	// 	Comença per mac, ignore case.

	// private final static String	INSTALL_URL			= "http://www.caib.es:8080/signaturacaib/install.jnlp";
	// private final static String	INSTALL_URL			= "http://www.caib.es:80/signaturacaib/install.jnlp";

	/**
	 * Obtiene el código del sistema operativo actual en que corre
	 * la máquina virtual de Java.
	 * 
	 * <p>Devuelve OS_UNKNOWN si no es capz de determinar el sistema operativo
	 * y OS_UNAVAILABLE si ha tenido problemas (seguramente de seguridad) para
	 * obtener la información de la JVM.
	 * 
	 * @return Sistema operativo en que se ejecuta la JVM.
	 */
	public static String getCurrentOs()
	{
		// if( SigDebug.isActive() ) SigDebug.write("Detección del OS");
		String currentOsName = null;
		try {
			currentOsName = System.getProperty("os.name");
		} catch (Throwable t) {
			currentOsName = null;
			// if( SigDebug.isActive() ) SigDebug.write("    Error obteniendo el sistema operativo: " + t.toString());
			t.printStackTrace();
		}

		if (currentOsName == null || currentOsName.length() == 0) {
			// if( SigDebug.isActive() ) SigDebug.write("    Incapaz de obtener el sistema operativo.");
			return OS_UNAVAILABLE;
		}

		if (currentOsName != null) {
			// if( SigDebug.isActive() ) SigDebug.write("    Nombre del sistema operativo: " + currentOsName);
			if (currentOsName.matches(OS_REGEXP_WINDOWS)) {
				// if( SigDebug.isActive() ) SigDebug.write("  - Sistema operativo Windows.");
				return OS_WINDOWS;
			} else if (currentOsName.matches(OS_REGEXP_LINUX)) {
				// if( SigDebug.isActive() ) SigDebug.write("  - Sistema operativo Linux.");
				return OS_LINUX;
			} else if (currentOsName.matches(OS_REGEXP_MAC)) {
				// if( SigDebug.isActive() ) SigDebug.write("  - Sistema operativo Mac.");
				return OS_MAC;
			}
		}
		// if( SigDebug.isActive() ) SigDebug.write("  - Sistema operativo desconocido.");
		return OS_UNKNOWN;
	}

	/**
	 * Obtiene el path de la JVM de java que executa el procés actual.
	 * 
	 * @return Path del JVM o null si no lo puede calcular.
	 */
	public static String getCurrentJVMPath()
	{
		try {
			return System.getProperty("java.home");
		} catch (Throwable t) {
			t.printStackTrace();
		}

		return null;
	}

	/**
	 * Obtiene la URL de instalación de la API.
	 * 
	 * @return URL de actualización.
	 */
	public static URL getUpgradeUrl()
	{
		try {
			SignerFactory sf = new SignerFactory();
			String updateSite = sf.getUpdateSite().toString();
			if ( updateSite != null && !updateSite.equals("")) {
				String installUrl = updateSite + "/install.jnlp";
				// if( SigDebug.isActive() ) SigDebug.write("Obtenint URL d'actualitzacio ...");
				String surl = installUrl + "?os=" + URLEncoder.encode(getCurrentOs(), "UTF-8");
				String jvm = getCurrentJVMPath();
				if (jvm != null && jvm.length() > 0) {
					surl += "&jvm=" + URLEncoder.encode(jvm, "UTF-8");
				}
				URL url = new URL(surl);
				// if( SigDebug.isActive() ) SigDebug.write("   URL = " + url.toString()); 
				return url;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
}
