package es.caib.signatura.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;


import java.security.AccessControlException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.MissingResourceException;
import java.util.Vector;

import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureSignException;
import es.caib.signatura.api.SignerFactory;
/**
 * 
 * @author u07286
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SignaturaProperties {

	// private static final String UPDATE_SITE = "http://www.caib.es:80/signaturacaib/";
	// private static final String UPDATE_SITE = "http://www.caib.es/signaturacaib/";
	private static final String CONFIGURATION_FILE = "signatura_api.properties";
	private static final String PROPERTIES_CACHE="/.signaturacaib/signatura_api.properties";
	private static final String ENVIRONMENT="comun.properties";

	static private Properties properties;

	public SignaturaProperties() throws FileNotFoundException, IOException {
		this(null);
	}
	
	public SignaturaProperties(Map signerConfiguration) throws FileNotFoundException, IOException {
		
		if (properties == null) {
			getPackagedProperties();
			getCacheProperties();
			getWWWProperties();
			if (signerConfiguration != null) {
				getUserProperties(signerConfiguration);
			}
		}
	}

	private void getPackagedProperties() throws FileNotFoundException,
			IOException {
		InputStream inputStream = getClass().getResourceAsStream(
				CONFIGURATION_FILE);
		if (inputStream == null) {
			throw new FileNotFoundException();
		}
		Properties tempProperties = new Properties();
		tempProperties.load(inputStream);
		inputStream.close();
		properties = tempProperties;
	}

	public void getCacheProperties() {
		try {
			File f = getCacheFile();
			Properties tempProperties = new Properties();
			tempProperties.load(new FileInputStream(f));
			updateProperties(tempProperties);
		} catch (FileNotFoundException e) {
		} catch (IOException e) {
		}
	}

	private File getCacheFile() {
		File f = new File(System.getProperty("user.home")
				+ PROPERTIES_CACHE);
		return f;
	}

	private boolean updateProperties(Properties tempProperties) {
		if (properties == null) {
			properties = tempProperties;
			return true;
		} else {
			try {
				Integer currentVersion = Integer.decode(properties
						.getProperty("build.number"));
				Integer newVersion = Integer.decode(tempProperties
						.getProperty("build.number"));
				if (newVersion.longValue() > currentVersion.longValue()) {
					properties = tempProperties;
					return true;
				}
			} catch (NumberFormatException e) {
			}
		}
		return false;
	}

	public void getWWWProperties() {
		try {
			if (getUpdateSite() != null) {
				URL url = new URL(
						getUpdateSite()+ "/" + CONFIGURATION_FILE);
				Properties tempProperties = new Properties();
				tempProperties.load(url.openStream());
				if (updateProperties(tempProperties)) {
					try {
						File f = getCacheFile();
						if (! f.getParentFile().isDirectory())
							f.getParentFile().mkdirs();
						tempProperties.store(new FileOutputStream(f),
								"Descargado en fecha " + new Date());
					} catch( Throwable t ) {
						t.printStackTrace();
					}
				}
			}
		} catch (FileNotFoundException e) {
		} catch (IOException e) {
		}
	}
	
	public void getUserProperties(Map userProperties) throws IOException {
		properties = (Properties) userProperties;
	}

	protected String getProperty(String name) {
		String value;
		value = properties.getProperty(name);
		if (value == null) {
			int i = name.indexOf(';');
			if (i > 0)
				value = properties.getProperty(name.substring(0, i));
		}
		if (value == null)
			value = properties.getProperty("altres");
		return value;
	}

	public boolean needsRecognizedCertificate(String contentType) {
		boolean DEFAULT_VALUE=true;
		
		String propertieValue = getProperty(contentType);
		if (propertieValue == null)
			return DEFAULT_VALUE; //PJR 05-02-09 posem a true 

		String[] signType = propertieValue.split(",");

		if (signType == null || signType.length < 2)
			return DEFAULT_VALUE;

		return signType[1].equalsIgnoreCase("CR");
	}

	public boolean needsTimeStamp(String contentType) {
		//FIXME això només és per a fer una prova.
		boolean DEFAULT_VALUE=false;
		
		String propertieValue = getProperty(contentType);
		if (propertieValue == null)
			return DEFAULT_VALUE;
		String[] signType = propertieValue.split(",");

		if (signType == null || signType.length < 2)
			return DEFAULT_VALUE;

		return signType[0].equalsIgnoreCase("SAST");
	}

	/**
	 *	Comprova si un contentType fa servir signatura del document original.
	 *	
	 *	Es llegeix un tercer parámetre en la llista de propietats del content 
	 *	type. Si aquest tercer parámetre es RAW, retorna cert. Si aquest tercer 
	 *	parámetre no hi és o te un valor diferent, retorna false.
	 */
	public boolean needsRawSignature( String contentType )
	{
		String propertieValue = getProperty(contentType);
		if (propertieValue == null)
			return false;
		String[] signType = propertieValue.split(",");

		if (signType == null || signType.length < 3)
			return false;

		return signType[2].equalsIgnoreCase("RAW");
	}
	
	public boolean needsAdvancedSignature(String contentType)
			throws SignatureSignException {
		return true;
	}

	public boolean enDesenvolupament(){
		try{
			return new ValidadorProxy() . isEnDesenvolupament();
		}catch(Exception e){
			
		}
		return true;
	}
	
	public String getTimestampService(String principalName) {
		return properties.getProperty("ts." + principalName);
	}

	public String getTimestampServiceApplicationId(String principalName) {
		return properties.getProperty("ts.applicationId." + principalName);
	}
	
	public String getTimestampServicePolicyOID(String name) {
		return properties.getProperty("ts.policyOID." + name);		
	}
	
	private String[] getMultiProperty (String name)
	{
		int i = 1;
		Vector v = new Vector ();
		while ( properties.getProperty(name+"."+i) != null)
		{
			v.add (properties.getProperty(name+"."+i));
			i++;
		}
		return (String [] ) v.toArray( new String [v.size()]);
	}
	
	public String[] getRecognizedPolicies ()
	{
		return getMultiProperty ("policy.recognized");
	}

	public String[] getRecognizedSecureDevicePolicies ()
	{
		return getMultiProperty ("policy.recognizedsecuredevice");
	}

	public String[] getAdvancedPolicies ()
	{
		return getMultiProperty ("policy.advanced");
	}

	public String[] getRecognizedExtensions ()
	{
		return getMultiProperty ("extension.recognized");
	}

	public String[] getAmbigousPoliciess ()
	{
		return getMultiProperty ("policy.ambigous");
	}

	public String[] getRootCAs ()
	{
		return getMultiProperty ("ca");
	}

	public String[] getPKCS11Drivers ()
	{
		return getMultiProperty ("pkcs11");
	}

	public String getCertificateParser(String id) {
		
		return properties.getProperty(id);
	}

	public String getPKCS11DriversDescription(String library) {
		String [] providersDescs=getMultiProperty ("pkcs11");
		int i=0;
		for(i=0;i<providersDescs.length;i++){
			if(providersDescs[i].equals(library)){
				return  getMultiProperty ("pkcs11.description")[i];
			}
		}
		return null;
	}
	
	public URL getUpdateSite() throws FileNotFoundException, IOException {
		InputStream inputStream = getClass().getResourceAsStream("version.properties");
		if (inputStream == null) {
			throw new FileNotFoundException();
		}
		Properties tempProperties = new Properties();
		tempProperties.load(inputStream);
		inputStream.close();
		String updateSite = tempProperties.getProperty("updateSite");
		if (updateSite != null && !updateSite.equals(""))
			return new URL(updateSite);
		else {
			return null;
		}
	}

}