package es.caib.signatura.impl;

import java.security.cert.X509Certificate;
import es.caib.signatura.api.Signature;


/** Interfaz que encapsula la firma digital de un documento, proporcionando los métodos necesarios para obtener
 * tanto la firma como otros de interés: nombre de la entidad certificadora, nombre del certificado usado o 
 * la cadena de SubjectAlternativeNames
 * @author Jesús Reyes (3dígits)
 * @version 1.0
 * @see Signature
 * 
 */


public interface SignatureProviderInterface extends Signature {

	public void setSignedData ( byte pkcs7 [ ] ) throws Exception;
	public void setContentType (String contentType) throws Exception;
	public X509Certificate[] getCertificateChain() throws Exception;
  
}