package es.caib.signatura.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.Properties;

import es.caib.signatura.api.SignatureVerifyException;



/**
 * Clase del lado del cliente que se utiliza para conectarse con la aplicacion de
 * verificacion de certificados enviar peticiones de validacoin de certificados o cadenas de certificacion
 * y devolvera el XML con la respuesta.
 *
 * Esta clase necesita el archivo de configuracion validator.properties con los siguientes parametros
 *
 * URL_SERVIDOR = Indica la URL donde se encuentra el servidor de validacion de certificados
 * ENTORNO = Indica el entorno en el que se quiere verificar (DESARROLLO o PRODUCCION)
 *
 *
 */
public class ValidadorProxy {

    private static String entorno;
	private static Method validadorMethod;
	
    public ValidadorProxy() {
    }
    
    static {
		ClassLoaderFactory factory;
		Properties p;
		try {
			factory = ClassLoaderFactory.getFactory();
			InputStream inputStream = factory.getMasterClassLoader().getResourceAsStream("es/caib/signatura/comun/comun.properties");
			if (inputStream ==null) 
				throw new RuntimeException (  "Resource /es/caib/signatura/comun/comun.properties not found" );

			p = new Properties();
			p.load(inputStream);
			inputStream.close();
		} catch (IOException e1) {
			throw new RuntimeException ( e1 );
		}
		entorno = p.getProperty("ENTORNO");

		if (entorno == null) {
			throw new RuntimeException( "El fichero comun.properties no es correcto");
		}
		try {
	    		Class validador = factory.getMasterClassLoader().loadClass( "es.caib.signatura.cliente.ValidadorCertificados2" );
	    		
	    		Method initmethod = validador.getMethod("init", new Class [] {File.class, String.class} );
	    		initmethod.invoke(null, new Object [] {factory.getLibraryDir(),entorno});
	    		validadorMethod = validador.getMethod("validate", new Class[] {
	    				(new X509Certificate[0]).getClass(), String.class } );		    		
		} catch ( Exception e ) {
			System.err.println ("WARNING: Cannot check certificate revocation status.");
			// No hay validador => Simplemente no se valida
		}
    }


    public boolean isValidadorInstalado() {
    	return getMethod() != null;
    }
    
	private static Method getMethod() {
		return validadorMethod;
	}

	public boolean validarAutenticacion(X509Certificate[] certificateChain)
		throws SignatureVerifyException
	{
		return invoke(certificateChain, "AUTENTIC");
	}

	/**
	 * @param certificateChain
	 * @param result
	 * @return
	 * @throws SignatureVerifyException
	 */
	private static boolean invoke(X509Certificate[] certificateChain, String proposito ) throws SignatureVerifyException {
		try {
			Boolean result = (Boolean) getMethod().invoke(null, new Object [] {
					certificateChain,
					proposito });
			return result.booleanValue ();
		} catch (IllegalArgumentException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		} catch (InvocationTargetException e) {
			throw new SignatureVerifyException(e.getTargetException());
		}
	}

	public boolean validarFirma(X509Certificate[] certificateChain) throws SignatureVerifyException {
		return invoke(certificateChain, "FIRMA");
	}

	public boolean isEnDesenvolupament() {
		return "DESARROLLO".equals(entorno);
	}
	
	

}
