package es.caib.signatura.provider.tradise;

import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.api.Signer;
import es.caib.signatura.impl.SignatureProviderInterface;

/**
 * Implementación de la interfaz <code>SignatureData</code> para usar con la
 * entidad certificadora Tradisea
 * 
 * @author Jesús Reyes (3dígits)
 * @version 0.98
 * @see Signer
 * @see Signature
 * 
 */
public class TradiseSignatureTest extends TradiseSignature {

	public TradiseSignatureTest(SignatureProviderInterface impl) {
		super(impl);
	}


	public TradiseSignatureTest(byte[] pkcs7, String contentType) throws SignatureDataException {
		super(pkcs7, contentType);
	}


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static final String CLASS_LOADER = "tradise-dev";


	protected String getClassLoaderName() {
		return CLASS_LOADER;
	}

}
