/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import [Ljava.security.cert.X509Certificate;;
import es.caib.signatura.api.ParsedCertificate;
import es.caib.signatura.api.SMIMEParser;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureCertNotFoundException;
import es.caib.signatura.api.SignatureException;
import es.caib.signatura.api.SignaturePrivKeyException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.api.Signer;
import es.caib.signatura.impl.CAIBSecurityManager;
import es.caib.signatura.impl.ClassLoaderFactory;
import es.caib.signatura.impl.GeneradorSMIMEParalelo;
import es.caib.signatura.impl.SMIMEGenerator;
import es.caib.signatura.impl.SMIMEInputStream;
import es.caib.signatura.impl.SMIMEParserProxy;
import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.impl.SignerProviderInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CAIBSigner
implements Signer {
    private static LinkedHashMap realSigners = null;
    private SignaturaProperties properties = null;
    private static ClassLoaderFactory factory;
    private static Object lock;

    private SignerProviderInterface getSigner(String certificateName, String contentType) throws SignatureCertNotFoundException {
        boolean recognized = this.properties.needsRecognizedCertificate(contentType);
        Iterator signersIterator = realSigners.values().iterator();
        while (signersIterator.hasNext()) {
            SignerProviderInterface s = (SignerProviderInterface)signersIterator.next();
            try {
                String[] certs = s.getCertList(recognized);
                for (int j = 0; j < certs.length; ++j) {
                    if (!certs[j].equals(certificateName)) continue;
                    return s;
                }
            }
            catch (SignatureCertNotFoundException e) {
            }
            catch (SignaturePrivKeyException e) {
            }
        }
        throw new SignatureCertNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCertList(String contentType) throws SignatureCertNotFoundException, SignaturePrivKeyException {
        Object object = lock;
        synchronized (object) {
            Iterator signersIterator;
            Vector<String> v = new Vector<String>();
            Collection signersCollection = realSigners.values();
            if (signersCollection != null && (signersIterator = signersCollection.iterator()) != null) {
                while (signersIterator.hasNext()) {
                    SignerProviderInterface s = (SignerProviderInterface)signersIterator.next();
                    boolean recognized = this.properties.needsRecognizedCertificate(contentType);
                    try {
                        String[] certs = s.getCertList(recognized);
                        for (int j = 0; j < certs.length; ++j) {
                            if (v.contains(certs[j])) continue;
                            v.add(certs[j]);
                        }
                    }
                    catch (SignatureCertNotFoundException e) {
                    }
                    catch (SignaturePrivKeyException e) {
                        e.printStackTrace();
                    }
                    catch (Throwable e) {
                        System.err.println("CANNOT LOAD on signature provider " + s.getClass().getName());
                        e.printStackTrace();
                    }
                }
            }
            return v.toArray(new String[v.size()]);
        }
    }

    public Signature sign(String fileName, String certificateName, String password, String contentType) throws IOException, SignatureException {
        return this.sign(new FileInputStream(fileName), certificateName, password, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature sign(InputStream contentStream, String certificateName, String password, String contentType) throws IOException, SignatureException {
        Object object = lock;
        synchronized (object) {
            boolean recognized = this.properties.needsRecognizedCertificate(contentType);
            boolean timeStamp = this.properties.needsTimeStamp(contentType);
            boolean rawSign = this.properties.needsRawSignature(contentType);
            SignerProviderInterface signer = this.getSigner(certificateName, contentType);
            if (SigDebug.isActive()) {
                SigDebug.write("Comprovacio password null.");
            }
            if (password == null) {
                if (SigDebug.isActive()) {
                    SigDebug.write("Posem el password a cadena buida.");
                }
                password = "";
            }
            if (SigDebug.isActive()) {
                SigDebug.write("CAIBSigned.sign: password " + (password.length() == 0 ? "es" : "no es") + " buit.");
            }
            return signer.sign(contentStream, certificateName, password, contentType, recognized, timeStamp, rawSign);
        }
    }

    public Signature sign(URL url, String certificateName, String password, String contentType) throws IOException, SignatureException {
        return this.sign(url.openStream(), certificateName, password, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signPDF(InputStream contentStream, OutputStream signedStream, String certificateName, String password, String contentType, String url, int position) throws IOException, SignatureException {
        Object object = lock;
        synchronized (object) {
            boolean recognized = this.properties.needsRecognizedCertificate(contentType);
            SignerProviderInterface signer = this.getSigner(certificateName, contentType);
            if (SigDebug.isActive()) {
                SigDebug.write("Comprovacio password null.");
            }
            if (password == null) {
                if (SigDebug.isActive()) {
                    SigDebug.write("Posem el password a cadena buida.");
                }
                password = "";
            }
            if (SigDebug.isActive()) {
                SigDebug.write("CAIBSigned.sign: password " + (password.length() == 0 ? "es" : "no es") + " buit.");
            }
            signer.signPDF(contentStream, signedStream, certificateName, password, contentType, recognized, url, position);
        }
    }

    public OutputStream signPDF(InputStream contentStream, String certificateName, String password, String contentType, String url, int position) throws IOException, SignatureException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.signPDF(contentStream, out, certificateName, password, contentType, url, position);
        return out;
    }

    public boolean verify(InputStream contentStream, Signature signatureData) throws SignatureProviderException, IOException, SignatureVerifyException {
        try {
            boolean isVerified = false;
            isVerified = signatureData.verify(contentStream);
            return isVerified;
        }
        catch (SignatureVerifyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureVerifyException(e);
        }
    }

    public boolean verifyAPosterioriTimeStamp(InputStream contentStream, Signature signatureData) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean isVerified = false;
        try {
            isVerified = signatureData.verifyAPosterioriTimestamp(contentStream);
        }
        catch (SignatureVerifyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureVerifyException(e);
        }
        return isVerified;
    }

    public boolean verify(String fileName, Signature signatureData) throws FileNotFoundException, SignatureProviderException, IOException, SignatureVerifyException {
        return this.verify(new FileInputStream(fileName), signatureData);
    }

    public boolean verify(URL url, Signature signatureData) throws SignatureProviderException, IOException, SignatureVerifyException {
        return this.verify(url.openStream(), signatureData);
    }

    public boolean verifyAPosterioriTimeStamp(String fileName, Signature signatureData) throws FileNotFoundException, SignatureProviderException, IOException, SignatureVerifyException {
        return this.verifyAPosterioriTimeStamp(new FileInputStream(fileName), signatureData);
    }

    public boolean verifyAPosterioriTimeStamp(URL url, Signature signatureData) throws SignatureProviderException, IOException, SignatureVerifyException {
        return this.verifyAPosterioriTimeStamp(url.openStream(), signatureData);
    }

    public void generateSMIME(InputStream document, Signature signature, OutputStream smime) throws IOException {
        int read;
        SMIMEGenerator smimeGenerator;
        try {
            Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.common.SMIMEGeneratorImpl");
            smimeGenerator = (SMIMEGenerator)c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        InputStream in = smimeGenerator.generateSMIME(document, signature);
        byte[] b = new byte[8192];
        while ((read = in.read(b)) > 0) {
            smime.write(b, 0, read);
        }
        in.close();
    }

    public void generateSMIMEParalell(InputStream document, Signature[] signatures, OutputStream smime) throws IOException, SignatureException {
        try {
            int read;
            Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.common.GeneradorSMIMEParaleloImpl");
            GeneradorSMIMEParalelo generadorSMIMEParalelo = (GeneradorSMIMEParalelo)c.newInstance();
            SMIMEInputStream in = generadorSMIMEParalelo.generarSMIMEParalelo(document, signatures);
            byte[] b = new byte[8192];
            while ((read = in.read(b)) > 0) {
                smime.write(b, 0, read);
            }
            in.close();
        }
        catch (IOException iox) {
            throw iox;
        }
        catch (Exception e) {
            throw new SignatureException(e.getMessage());
        }
    }

    public Date getCurrentDate(String certificateName, String password, String contentType) throws SignatureTimestampException, SignatureException, IOException {
        if (password == null) {
            password = "";
        }
        if (SigDebug.isActive()) {
            SigDebug.write("CAIBSigned.getCurrentDate: password " + (password.length() == 0 ? "es" : "no es") + " buit.");
        }
        boolean recognized = this.properties.needsRecognizedCertificate(contentType);
        return this.getSigner(certificateName, contentType).getCurrentDate(certificateName, password, recognized);
    }

    public CAIBSigner() throws FileNotFoundException {
        this(null);
    }

    public CAIBSigner(Map signerConfiguration) throws FileNotFoundException {
        CAIBSecurityManager.register();
        if (factory == null) {
            factory = ClassLoaderFactory.getFactory();
            realSigners = new LinkedHashMap();
        }
        try {
            if (Security.getProvider("BC") == null) {
                ClassLoader c = factory.getFactory().getMasterClassLoader();
                Provider p = (Provider)factory.getFactory().getMasterClassLoader().loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
                Security.addProvider(p);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.properties = signerConfiguration == null ? new SignaturaProperties() : new SignaturaProperties(signerConfiguration);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        if (SigDebug.getLevel() == 0) {
            SigDebug.setLevel(this.properties.getProperty("debugLevel"));
        }
        if (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("tradise") == -1) {
            try {
                this.addTradiseSigner("tradise");
                SigDebug.write("[DBG] ACTIVAT TRADISE.");
            }
            catch (FileNotFoundException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File dirDev = new File(factory.getLibraryDir(), "tradise-dev");
            if (dirDev.isDirectory()) {
                try {
                    this.addTradiseSigner("tradise-dev");
                    SigDebug.write("[DBG] ACTIVAT TRADISE TEST.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("PKCS11") == -1) {
            String[] drivers = this.properties.getPKCS11Drivers();
            for (int i = 0; i < drivers.length; ++i) {
                this.addPKCS11Signer(drivers[i]);
                SigDebug.write("[DBG] ACTIVAT PKCS11 " + drivers[i] + ".");
            }
        }
        if (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("MSCRYPTOAPI") == -1) {
            try {
                this.addMscryptoapiSigner();
                SigDebug.write("[DBG] ACTIVAT MSCRYPTOAPI.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("BC") == -1) {
            try {
                this.addBcCryptoApiSigner();
                SigDebug.write("[DBG] ACTIVAT BC.");
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException && System.getProperty("caib-crypto-keystore") == null) {
                    SigDebug.write("[DBG] El usuario no tiene keystore por defecto para el BcCryptoApiSigner.");
                }
                e.printStackTrace();
            }
        }
    }

    private void addPKCS11Signer(String libraryName) {
        File f = new File(libraryName);
        if (f.isAbsolute()) {
            String name = f.getName();
            if (realSigners.get(name) == null) {
                this.addPKCS11Signer(name, f);
            }
        } else if (realSigners.get(libraryName) == null) {
            String path = System.getProperty("java.library.path");
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                File next = new File(tokenizer.nextToken());
                f = new File(next, libraryName);
                if (this.addPKCS11Signer(libraryName, f)) {
                    return;
                }
                f = new File(next, libraryName + ".dll");
                if (!this.addPKCS11Signer(libraryName, f)) continue;
                return;
            }
        }
    }

    private boolean addPKCS11Signer(String libraryName, File f) {
        if (f.canRead()) {
            String providerName = this.properties.getPKCS11DriversDescription(libraryName);
            try {
                File cfg = File.createTempFile(libraryName, "pkcs11.cfg");
                PrintWriter writer = new PrintWriter(new FileWriter(cfg));
                writer.println("name=" + libraryName);
                writer.println("library=" + f.getAbsolutePath());
                writer.close();
                cfg.deleteOnExit();
                Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.pkcs11.PKCS11Signer");
                Constructor<?> constructor = c.getConstructor(String.class, String.class);
                realSigners.put(libraryName, constructor.newInstance(cfg.getAbsolutePath(), providerName));
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    private void addTradiseSigner(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException, FileNotFoundException {
        if (realSigners.get(name) == null) {
            ClassLoader loader = factory.getClassLoader(name);
            Class<?> c = loader.loadClass("es.caib.signatura.provider.impl.tradise.TradiseSigner");
            realSigners.put(name, c.newInstance());
        }
    }

    public String getAPIVersion() {
        try {
            InputStream inputStream = CAIBSigner.class.getResourceAsStream("version.properties");
            if (inputStream == null) {
                throw new FileNotFoundException();
            }
            Properties tempProperties = new Properties();
            tempProperties.load(inputStream);
            inputStream.close();
            return tempProperties.getProperty("Version");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addBcCryptoApiSigner() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.bccryptoapi.BcCryptoApiSigner");
        realSigners.put("bccryptoapi", c.newInstance());
        if (SigDebug.isActive()) {
            SigDebug.write("CAIBSigner: addBcCryptoApiSigner: Cargados los certificados del keystore");
        }
    }

    private void addMscryptoapiSigner() {
        try {
            File f;
            String libraryName = System.getProperty("java.home") + "\\lib\\signaturacaib\\mscryptofunctions.dll";
            if (SigDebug.isActive()) {
                SigDebug.write("CAIBSigner: addMscryptoapiSigner: Path mscryptofunctions = " + libraryName);
            }
            if ((f = new File(libraryName)).canRead()) {
                Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.mscryptoapi.MscryptoapiSigner");
                realSigners.put("mscryptoapi", c.newInstance());
                if (SigDebug.isActive()) {
                    SigDebug.write("CAIBSigner: addMscryptoapiSigner: Cargada mscryptofunctions.dll");
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("No se puede cargar la biblioteca mscryptofunctions.dll");
            return;
        }
    }

    public SMIMEParser getSMIMEParser(InputStream smime) throws InstantiationException, IllegalAccessException, IOException, SignatureException {
        return new SMIMEParserProxy(smime);
    }

    public ParsedCertificate parseCertificate(X509Certificate certificate) {
        try {
            Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.common.ParsedCertificateImpl");
            Constructor<?> constructor = c.getConstructor(X509Certificate;.class, Boolean.TYPE);
            return (ParsedCertificate)constructor.newInstance(new X509Certificate[]{certificate}, new Boolean(false));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        lock = new Object();
    }
}

