/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.api.ParsedCertificate;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.impl.ClassLoaderFactory;
import es.caib.signatura.impl.SignatureProviderInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;

public class CMSSignature
implements Signature,
Serializable {
    protected byte[] signatureBytes = null;
    private String contentType = null;
    private static final long serialVersionUID = 1L;
    private transient SignatureProviderInterface impl = null;

    public CMSSignature(byte[] pkcs7, String contentType) throws SignatureDataException {
        this.signatureBytes = pkcs7;
        this.contentType = contentType;
        try {
            this.init();
        }
        catch (IOException e) {
            throw new SignatureDataException(e);
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setPkcs7(byte[] pkcs7) {
        this.signatureBytes = pkcs7;
    }

    public CMSSignature(SignatureProviderInterface impl) {
        this.impl = impl;
        this.signatureBytes = impl.getPkcs7();
        this.contentType = impl.getContentType();
    }

    private void init() throws IOException {
        if (this.impl == null) {
            try {
                ClassLoader cl = ClassLoaderFactory.getFactory().getMasterClassLoader();
                Class<?> clazz = cl.loadClass(this.getInternalClassName());
                this.impl = (SignatureProviderInterface)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.impl.setContentType(this.contentType);
            this.impl.setSignedData(this.signatureBytes);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse signature");
        }
    }

    protected String getInternalClassName() {
        return "es.caib.signatura.provider.impl.common.CMSSignatureImpl";
    }

    public String getCertCaName() {
        return this.impl.getCertCaName();
    }

    public String getCertSubjectCommonName() {
        return this.impl.getCertSubjectCommonName();
    }

    public String getCertSubjectAlternativeNames() {
        return this.impl.getCertSubjectAlternativeNames();
    }

    public byte[] getPkcs7() {
        return this.signatureBytes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public Date getDate() throws SignatureTimestampException {
        return this.impl.getDate();
    }

    public boolean verify() throws SignatureVerifyException {
        return this.impl.verify();
    }

    public String getContentType() {
        return this.contentType;
    }

    public X509Certificate getCert() {
        return this.impl.getCert();
    }

    public X509Certificate[] getCertificateChain() throws Exception {
        return this.impl.getCertificateChain();
    }

    public ParsedCertificate getParsedCertificate() {
        return this.impl.getParsedCertificate();
    }

    public boolean verify(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean isVerified = true;
        try {
            isVerified = isVerified && this.impl.verify(contentStream);
        }
        catch (SignatureVerifyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureVerifyException(e);
        }
        return isVerified;
    }

    public boolean verifyAPosterioriTimestamp(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean isVerified = true;
        try {
            boolean bl = isVerified = isVerified && this.impl.verifyAPosterioriTimestamp(contentStream);
            if (isVerified) {
                this.setPkcs7(this.impl.getPkcs7());
            }
        }
        catch (SignatureVerifyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureVerifyException(e);
        }
        return isVerified;
    }
}

