/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.api.Certificate;
import es.caib.signatura.api.CertificateVerifyException;
import es.caib.signatura.api.ParsedCertificate;
import es.caib.signatura.impl.ClassLoaderFactory;
import es.caib.signatura.impl.ParsedCertificateProxy;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CertificateImpl
implements Certificate {
    private X509Certificate[] certificateChain = null;

    public CertificateImpl(X509Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
    }

    public String getCertCaName() {
        if (this.certificateChain == null || this.certificateChain.length == 0) {
            throw new Error("No se encuentra cadena de certificaci\u00f3n.");
        }
        return this.certificateChain[this.certificateChain.length - 1].getSubjectX500Principal().getName();
    }

    public String getCertSubjectCommonName() {
        ParsedCertificate Parsed = this.getParsedCertificate();
        return Parsed.getName();
    }

    public String getCertSubjectAlternativeNames() {
        StringBuffer altNameSB = new StringBuffer("");
        String altNameString = null;
        try {
            Collection<List<?>> generalNames = this.certificateChain[0].getSubjectAlternativeNames();
            Iterator<List<?>> itr = generalNames.iterator();
            while (itr.hasNext()) {
                List<?> list = itr.next();
                int tagNo = (Integer)list.get(0);
                switch (tagNo) {
                    case 0: {
                        altNameSB.append(",otherName=");
                        break;
                    }
                    case 1: {
                        altNameSB.append(",rfc822Name=");
                        break;
                    }
                    case 2: {
                        altNameSB.append(",dNSName=");
                        break;
                    }
                    case 3: {
                        altNameSB.append(",x400Address=");
                        break;
                    }
                    case 4: {
                        altNameSB.append(",directoryName=");
                        break;
                    }
                    case 5: {
                        altNameSB.append(",ediPartyName=");
                        break;
                    }
                    case 6: {
                        altNameSB.append(",uniformResourceIdentifier=");
                        break;
                    }
                    case 7: {
                        altNameSB.append(",iPAddress=");
                        break;
                    }
                    case 8: {
                        altNameSB.append(",registeredID=");
                    }
                }
                altNameSB.append(list.get(1).toString());
                if (altNameSB.length() <= 0) continue;
                altNameString = altNameSB.substring(1, altNameSB.length());
            }
        }
        catch (Exception ex) {
            return null;
        }
        return altNameString;
    }

    public X509Certificate getCert() {
        return this.certificateChain[0];
    }

    public ParsedCertificate getParsedCertificate() {
        try {
            ClassLoader cl = ClassLoaderFactory.getFactory().getMasterClassLoader();
            Class<?> clazz = cl.loadClass("es.caib.signatura.provider.impl.common.ParsedCertificatImpl");
            Constructor<?> constructor = clazz.getConstructor(this.certificateChain.getClass(), Boolean.TYPE);
            ParsedCertificate parsed = (ParsedCertificate)constructor.newInstance(this.certificateChain, new Boolean(false));
            return new ParsedCertificateProxy(parsed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean verify() throws IOException, CertificateVerifyException {
        boolean isValid = true;
        boolean bl = isValid = isValid && this.verifyCertificateChain();
        if (!isValid) {
            this.invertCertificateChain();
            boolean bl2 = isValid = isValid && this.verifyCertificateChain();
            if (!isValid) {
                this.invertCertificateChain();
            }
        }
        return isValid;
    }

    private void invertCertificateChain() {
        for (int i = 0; i < this.certificateChain.length / 2; ++i) {
            X509Certificate temporalCertificate = this.certificateChain[this.certificateChain.length - 1 - i];
            this.certificateChain[this.certificateChain.length - 1 - i] = this.certificateChain[i];
            this.certificateChain[i] = temporalCertificate;
        }
    }

    private boolean verifyCertificateChain() throws IOException, CertificateVerifyException {
        int i;
        boolean isValid = true;
        for (i = 0; i < this.certificateChain.length && isValid; ++i) {
            try {
                this.certificateChain[i].checkValidity();
                continue;
            }
            catch (CertificateExpiredException cee) {
                isValid = false;
                continue;
            }
            catch (CertificateNotYetValidException cve) {
                isValid = false;
            }
        }
        for (i = 0; i < this.certificateChain.length - 1 && isValid; ++i) {
            try {
                this.certificateChain[i].verify(this.certificateChain[i + 1].getPublicKey());
                continue;
            }
            catch (InvalidKeyException e) {
                isValid = false;
                continue;
            }
            catch (CertificateException e) {
                isValid = false;
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                throw new CertificateVerifyException(e);
            }
            catch (NoSuchProviderException e) {
                throw new CertificateVerifyException(e);
            }
            catch (SignatureException e) {
                isValid = false;
            }
        }
        try {
            isValid = isValid && this.verifyCertificateWebServices(this.certificateChain);
        }
        catch (Exception e) {
            throw new CertificateVerifyException(e);
        }
        return isValid;
    }

    private boolean verifyCertificateWebServices(X509Certificate[] certificateChain) throws CertificateVerifyException {
        return true;
    }
}

