/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.impl.ExclusiveURLClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;

public class ClassLoaderFactory {
    private static ClassLoaderFactory theFactory = null;
    private static ClassLoader masterClassLoader = null;
    private static Hashtable childClassLoader = new Hashtable();
    private static File libDir = null;

    private ClassLoaderFactory() throws FileNotFoundException {
        if (masterClassLoader == null) {
            try {
                libDir = this.locateSignaturaDir();
                masterClassLoader = ClassLoaderFactory.createClassLoader(libDir, this.getClass().getClassLoader());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private File locateSignaturaDir() {
        File libDir = null;
        try {
            String signaturaDir = System.getProperty("es.caib.signatura.library_path");
            if (signaturaDir != null) {
                File sigDir = new File(signaturaDir);
                if (sigDir.isAbsolute() && sigDir.isDirectory()) {
                    libDir = sigDir;
                } else {
                    File f;
                    File newLibDir;
                    URL jarFileUrl;
                    int i;
                    URL url = this.getClass().getResource("ClassLoaderFactory.class");
                    if ("jar".equals(url.getProtocol()) && (i = url.getFile().lastIndexOf(33)) > 0 && "file".equals((jarFileUrl = new URL(url.getFile().substring(0, i))).getProtocol()) && (newLibDir = new File((f = new File(jarFileUrl.getFile())).getParentFile(), signaturaDir)).isDirectory()) {
                        libDir = newLibDir;
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (libDir == null) {
            String java_home = System.getProperty("java.home");
            libDir = new File(new File(java_home), "lib/signaturacaib");
        }
        return libDir;
    }

    public static synchronized ClassLoaderFactory getFactory() throws FileNotFoundException {
        if (theFactory == null) {
            theFactory = new ClassLoaderFactory();
        }
        return theFactory;
    }

    public File getLibraryDir() {
        return libDir;
    }

    private static synchronized URLClassLoader createClassLoader(File dir, ClassLoader parentClassLoader) throws FileNotFoundException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new FileNotFoundException(dir.getPath());
        }
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                urls[i] = files[i].toURL();
                continue;
            }
            catch (MalformedURLException e) {
                System.err.println(e.toString());
            }
        }
        return new ExclusiveURLClassLoader(urls, parentClassLoader);
    }

    public synchronized ClassLoader getMasterClassLoader() {
        return masterClassLoader;
    }

    public synchronized ClassLoader getClassLoader(String name) throws FileNotFoundException {
        ClassLoader c = (ClassLoader)childClassLoader.get(name);
        if (c == null) {
            c = ClassLoaderFactory.createClassLoader(new File(libDir, name), this.getMasterClassLoader());
            childClassLoader.put(name, c);
        }
        return c;
    }
}

