/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.impl.Base64;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class MIMEInputStream
extends FilterInputStream {
    private boolean finished;
    private byte[] headData = null;
    private int headDataOff;
    private int headDataSize;
    private String contentType = null;
    private boolean inHead;
    private byte[] bodyData = new byte[66];
    private int bodyDataOff;
    private int bodyDataSize;

    public MIMEInputStream(InputStream is, String contentType) throws UnsupportedEncodingException {
        super(is);
        this.contentType = contentType;
        String mime = new String("");
        mime = mime + "Content-Type: " + contentType + "\r\n";
        mime = mime + "Content-Transfer-Encoding: base64\r\n\r\n";
        this.headData = mime.getBytes("UTF-8");
        this.headDataOff = 0;
        this.headDataSize = this.headData.length;
        this.inHead = true;
    }

    public synchronized void close() throws IOException {
        this.finished = true;
        super.close();
    }

    public synchronized int read() throws IOException {
        byte b;
        if (this.inHead) {
            b = this.headData[this.headDataOff];
            ++this.headDataOff;
            if (this.headDataOff == this.headDataSize) {
                this.inHead = false;
                this.bodyDataSize = this.getBodyData(this.bodyData);
                if (this.bodyDataSize == -1) {
                    this.finished = true;
                } else {
                    this.bodyDataOff = 0;
                }
            }
        } else {
            if (this.finished) {
                return -1;
            }
            b = this.bodyData[this.bodyDataOff];
            ++this.bodyDataOff;
            if (this.bodyDataOff == this.bodyDataSize) {
                this.bodyDataSize = this.getBodyData(this.bodyData);
                if (this.bodyDataSize == -1) {
                    this.finished = true;
                } else {
                    this.bodyDataOff = 0;
                }
            }
        }
        return b & 0xFF;
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            int c = this.read();
            if (c < 0) {
                return i == 0 ? -1 : i;
            }
            buffer[offset++] = (byte)c;
        }
        return length;
    }

    public synchronized long skip(long n) throws IOException {
        for (long i = 0L; i < n; ++i) {
            if (this.read() >= 0) continue;
            return i;
        }
        return n;
    }

    public synchronized int available() throws IOException {
        if (this.inHead) {
            return this.headDataSize - this.headDataOff;
        }
        return this.bodyDataSize - this.bodyDataOff;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Base64InputStream does not support mark/reset");
    }

    public boolean markSupported() {
        return false;
    }

    private int getBodyData(byte[] bodyData) throws IOException {
        int read;
        int size = 0;
        byte[] inputBuffer = new byte[48];
        size = 0;
        do {
            if ((read = this.in.read(inputBuffer, size, inputBuffer.length - size)) >= 0 || size != 0) continue;
            return -1;
        } while (read >= 0 && (size += read) < inputBuffer.length);
        if (size >= 0) {
            byte[] result = Base64.toBase64(inputBuffer, 0, size);
            size = result.length;
            System.arraycopy(result, 0, bodyData, 0, size);
        }
        return size;
    }
}

