/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.api.Signature;
import es.caib.signatura.impl.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class SMIMEInputStream
extends InputStream {
    private static final int CHUNK_SIZE = 48;
    String boundary;
    Signature signature;
    InputStream content;
    String contentType;
    private int status;
    private static final int STATUS_IDLE = 0;
    private static final int STATUS_HEADER = 1;
    private static final int STATUS_CONTENT_HEADER = 2;
    private static final int STATUS_CONTENT_BODY = 3;
    private static final int STATUS_SIGNATURE_HEADER = 4;
    private static final int STATUS_SIGNATURE_BODY = 5;
    private static final int STATUS_FOOTER = 6;
    private static final int STATUS_END = 7;
    private boolean contentSizeMultiple = false;
    private boolean signatureSizeMultiple = false;
    int bufferOffset;
    byte[] buffer;
    byte[] signatureData;
    int signatureDataOffset;

    public SMIMEInputStream(Signature signature, InputStream content) throws UnsupportedEncodingException {
        this.signature = signature;
        this.content = content;
        this.contentType = signature.getContentType();
        this.status = 0;
        this.bufferOffset = 0;
        this.buffer = null;
        this.boundary = "----CAIB_BOUNDARY_" + System.currentTimeMillis() + "_DGTIC";
        this.signatureData = signature.getPkcs7();
        this.signatureDataOffset = 0;
    }

    public SMIMEInputStream(byte[] pkcs7, InputStream content, String contentType) {
        this.content = content;
        this.contentType = contentType;
        this.status = 0;
        this.bufferOffset = 0;
        this.buffer = null;
        this.boundary = "----CAIB_BOUNDARY_" + System.currentTimeMillis() + "_DGTIC";
        this.signatureData = pkcs7;
        this.signatureDataOffset = 0;
    }

    public synchronized void close() throws IOException {
        this.status = 7;
        this.content.close();
    }

    public synchronized int read() throws IOException {
        while (true) {
            if (this.buffer != null && this.bufferOffset < this.buffer.length) {
                byte b = this.buffer[this.bufferOffset++];
                return b;
            }
            if (this.status == 7) {
                return -1;
            }
            this.fetchData();
        }
    }

    public synchronized int read(byte[] targetBuffer, int offset, int length) throws IOException {
        while (true) {
            if (this.buffer != null && this.bufferOffset < this.buffer.length) {
                int actualLength = this.buffer.length - this.bufferOffset;
                if (actualLength > length) {
                    actualLength = length;
                }
                System.arraycopy(this.buffer, this.bufferOffset, targetBuffer, offset, actualLength);
                this.bufferOffset += actualLength;
                return actualLength;
            }
            if (this.status == 7) {
                return -1;
            }
            this.fetchData();
        }
    }

    public synchronized int available() throws IOException {
        while (this.buffer == null || this.bufferOffset >= this.buffer.length) {
            if (this.status == 7) {
                return -1;
            }
            if (this.status == 3) {
                return this.content.available();
            }
            this.fetchData();
        }
        return this.buffer.length - this.bufferOffset;
    }

    private void fetchData() throws IOException {
        switch (this.status) {
            case 0: {
                this.buffer = this.fetchIdle();
                break;
            }
            case 1: {
                this.buffer = this.fetchHeader();
                break;
            }
            case 2: {
                this.buffer = this.fetchContentHeader();
                break;
            }
            case 3: {
                this.buffer = this.fetchContentBody();
                break;
            }
            case 4: {
                this.buffer = this.fetchSignatureHeader();
                break;
            }
            case 5: {
                this.buffer = this.fetchSignatureBody();
                break;
            }
            case 6: {
                this.buffer = this.fetchFooter();
                break;
            }
            default: {
                this.buffer = null;
            }
        }
        this.bufferOffset = 0;
    }

    private byte[] fetchFooter() {
        try {
            this.status = 7;
            String outString = this.signatureSizeMultiple ? "" : "\r\n";
            outString = outString + "--" + this.boundary + "--\r\n";
            return outString.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] fetchContentBody() throws IOException {
        int read;
        byte[] b = new byte[48];
        int offset = 0;
        this.contentSizeMultiple = false;
        do {
            if ((read = this.content.read(b, offset, b.length - offset)) > 0) continue;
            if (offset % 48 == 0) {
                this.contentSizeMultiple = true;
            }
            this.status = 4;
            break;
        } while ((offset += read) != b.length);
        return Base64.toBase64(b, 0, offset);
    }

    private byte[] fetchContentHeader() {
        try {
            this.status = 3;
            return ("--" + this.boundary + "\r\n" + "Content-Type: " + this.contentType + "\r\n" + "Content-Transfer-Encoding: base64\r\n" + "\r\n").getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] fetchSignatureBody() {
        int len = this.signatureData.length - this.signatureDataOffset;
        this.signatureSizeMultiple = false;
        if (len <= 0) {
            if (this.signatureDataOffset % 48 == 0) {
                this.signatureSizeMultiple = true;
            }
            this.status = 6;
            return null;
        }
        if (len > 48) {
            len = 48;
        }
        byte[] result = Base64.toBase64(this.signatureData, this.signatureDataOffset, len);
        this.signatureDataOffset += len;
        return result;
    }

    private byte[] fetchSignatureHeader() {
        try {
            this.status = 5;
            String outString = this.contentSizeMultiple ? "" : "\r\n";
            outString = outString + "--" + this.boundary + "\r\n" + "Content-Type: application/pkcs7-signature; name=smime.p7s; smime-type=signed-data\r\n" + "Content-Transfer-Encoding: base64\r\n" + "Content-Disposition: attachment; filename=\"smime.p7s\"\r\n" + "Content-Description: S/MIME Cryptographic Signature\r\n" + "\r\n";
            return outString.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] fetchHeader() {
        try {
            this.status = 2;
            return ("Content-Type: multipart/signed; protocol=\"application/pkcs7-signature\"; micalg=\"sha1\";boundary=\"" + this.boundary + "\"\r\n" + "\r\n").getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] fetchIdle() {
        this.status = 1;
        return null;
    }

    public synchronized long skip(long n) throws IOException {
        for (long i = 0L; i < n; ++i) {
            if (this.read() >= 0) continue;
            return i;
        }
        return n;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Base64InputStream does not support mark/reset");
    }

    public boolean markSupported() {
        return false;
    }
}

