/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.api.SignatureSignException;
import es.caib.signatura.impl.ValidadorProxy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class SignaturaProperties {
    private static final String CONFIGURATION_FILE = "signatura_api.properties";
    private static final String PROPERTIES_CACHE = "/.signaturacaib/signatura_api.properties";
    private static final String ENVIRONMENT = "comun.properties";
    private static Properties properties;

    public SignaturaProperties() throws FileNotFoundException, IOException {
        this(null);
    }

    public SignaturaProperties(Map signerConfiguration) throws FileNotFoundException, IOException {
        if (properties == null) {
            this.getPackagedProperties();
            this.getCacheProperties();
            this.getWWWProperties();
            if (signerConfiguration != null) {
                this.getUserProperties(signerConfiguration);
            }
        }
    }

    private void getPackagedProperties() throws FileNotFoundException, IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(CONFIGURATION_FILE);
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        Properties tempProperties = new Properties();
        tempProperties.load(inputStream);
        inputStream.close();
        properties = tempProperties;
    }

    public void getCacheProperties() {
        try {
            File f = this.getCacheFile();
            Properties tempProperties = new Properties();
            tempProperties.load(new FileInputStream(f));
            this.updateProperties(tempProperties);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File getCacheFile() {
        File f = new File(System.getProperty("user.home") + PROPERTIES_CACHE);
        return f;
    }

    private boolean updateProperties(Properties tempProperties) {
        if (properties == null) {
            properties = tempProperties;
            return true;
        }
        try {
            Integer currentVersion = Integer.decode(properties.getProperty("build.number"));
            Integer newVersion = Integer.decode(tempProperties.getProperty("build.number"));
            if (newVersion.longValue() > currentVersion.longValue()) {
                properties = tempProperties;
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void getWWWProperties() {
        try {
            if (this.getUpdateSite() != null) {
                URL url = new URL(this.getUpdateSite() + "/" + CONFIGURATION_FILE);
                Properties tempProperties = new Properties();
                tempProperties.load(url.openStream());
                if (this.updateProperties(tempProperties)) {
                    try {
                        File f = this.getCacheFile();
                        if (!f.getParentFile().isDirectory()) {
                            f.getParentFile().mkdirs();
                        }
                        tempProperties.store(new FileOutputStream(f), "Descargado en fecha " + new Date());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getUserProperties(Map userProperties) throws IOException {
        properties = (Properties)userProperties;
    }

    protected String getProperty(String name) {
        int i;
        String value = properties.getProperty(name);
        if (value == null && (i = name.indexOf(59)) > 0) {
            value = properties.getProperty(name.substring(0, i));
        }
        if (value == null) {
            value = properties.getProperty("altres");
        }
        return value;
    }

    public boolean needsRecognizedCertificate(String contentType) {
        boolean DEFAULT_VALUE = true;
        String propertieValue = this.getProperty(contentType);
        if (propertieValue == null) {
            return DEFAULT_VALUE;
        }
        String[] signType = propertieValue.split(",");
        if (signType == null || signType.length < 2) {
            return DEFAULT_VALUE;
        }
        return signType[1].equalsIgnoreCase("CR");
    }

    public boolean needsTimeStamp(String contentType) {
        boolean DEFAULT_VALUE = false;
        String propertieValue = this.getProperty(contentType);
        if (propertieValue == null) {
            return DEFAULT_VALUE;
        }
        String[] signType = propertieValue.split(",");
        if (signType == null || signType.length < 2) {
            return DEFAULT_VALUE;
        }
        return signType[0].equalsIgnoreCase("SAST");
    }

    public boolean needsRawSignature(String contentType) {
        String propertieValue = this.getProperty(contentType);
        if (propertieValue == null) {
            return false;
        }
        String[] signType = propertieValue.split(",");
        if (signType == null || signType.length < 3) {
            return false;
        }
        return signType[2].equalsIgnoreCase("RAW");
    }

    public boolean needsAdvancedSignature(String contentType) throws SignatureSignException {
        return true;
    }

    public boolean enDesenvolupament() {
        try {
            return new ValidadorProxy().isEnDesenvolupament();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public String getTimestampService(String principalName) {
        return properties.getProperty("ts." + principalName);
    }

    public String getTimestampServiceApplicationId(String principalName) {
        return properties.getProperty("ts.applicationId." + principalName);
    }

    public String getTimestampServicePolicyOID(String name) {
        return properties.getProperty("ts.policyOID." + name);
    }

    private String[] getMultiProperty(String name) {
        int i = 1;
        Vector<String> v = new Vector<String>();
        while (properties.getProperty(name + "." + i) != null) {
            v.add(properties.getProperty(name + "." + i));
            ++i;
        }
        return v.toArray(new String[v.size()]);
    }

    public String[] getRecognizedPolicies() {
        return this.getMultiProperty("policy.recognized");
    }

    public String[] getRecognizedSecureDevicePolicies() {
        return this.getMultiProperty("policy.recognizedsecuredevice");
    }

    public String[] getAdvancedPolicies() {
        return this.getMultiProperty("policy.advanced");
    }

    public String[] getRecognizedExtensions() {
        return this.getMultiProperty("extension.recognized");
    }

    public String[] getAmbigousPoliciess() {
        return this.getMultiProperty("policy.ambigous");
    }

    public String[] getRootCAs() {
        return this.getMultiProperty("ca");
    }

    public String[] getPKCS11Drivers() {
        return this.getMultiProperty("pkcs11");
    }

    public String getCertificateParser(String id) {
        return properties.getProperty(id);
    }

    public String getPKCS11DriversDescription(String library) {
        String[] providersDescs = this.getMultiProperty("pkcs11");
        int i = 0;
        for (i = 0; i < providersDescs.length; ++i) {
            if (!providersDescs[i].equals(library)) continue;
            return this.getMultiProperty("pkcs11.description")[i];
        }
        return null;
    }

    public URL getUpdateSite() throws FileNotFoundException, IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("version.properties");
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        Properties tempProperties = new Properties();
        tempProperties.load(inputStream);
        inputStream.close();
        String updateSite = tempProperties.getProperty("updateSite");
        if (updateSite != null && !updateSite.equals("")) {
            return new URL(updateSite);
        }
        return null;
    }
}

