/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.impl.ClassLoaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.Properties;

public class ValidadorProxy {
    private static String entorno;
    private static Method validadorMethod;

    public boolean isValidadorInstalado() {
        return ValidadorProxy.getMethod() != null;
    }

    private static Method getMethod() {
        return validadorMethod;
    }

    public boolean validarAutenticacion(X509Certificate[] certificateChain) throws SignatureVerifyException {
        return ValidadorProxy.invoke(certificateChain, "AUTENTIC");
    }

    private static boolean invoke(X509Certificate[] certificateChain, String proposito) throws SignatureVerifyException {
        try {
            Boolean result = (Boolean)ValidadorProxy.getMethod().invoke(null, certificateChain, proposito);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new SignatureVerifyException(e.getTargetException());
        }
    }

    public boolean validarFirma(X509Certificate[] certificateChain) throws SignatureVerifyException {
        return ValidadorProxy.invoke(certificateChain, "FIRMA");
    }

    public boolean isEnDesenvolupament() {
        return "DESARROLLO".equals(entorno);
    }

    static {
        Properties p;
        ClassLoaderFactory factory;
        try {
            factory = ClassLoaderFactory.getFactory();
            InputStream inputStream = factory.getMasterClassLoader().getResourceAsStream("es/caib/signatura/comun/comun.properties");
            if (inputStream == null) {
                throw new RuntimeException("Resource /es/caib/signatura/comun/comun.properties not found");
            }
            p = new Properties();
            p.load(inputStream);
            inputStream.close();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        entorno = p.getProperty("ENTORNO");
        if (entorno == null) {
            throw new RuntimeException("El fichero comun.properties no es correcto");
        }
        try {
            Class<?> validador = factory.getMasterClassLoader().loadClass("es.caib.signatura.cliente.ValidadorCertificados2");
            Method initmethod = validador.getMethod("init", File.class, String.class);
            initmethod.invoke(null, factory.getLibraryDir(), entorno);
            validadorMethod = validador.getMethod("validate", new X509Certificate[0].getClass(), String.class);
        }
        catch (Exception e) {
            System.err.println("WARNING: Cannot check certificate revocation status.");
        }
    }
}

