/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.api.ParsedCertificate;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.impl.ClassLoaderFactory;
import es.caib.signatura.impl.SignatureProviderInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.Date;

public class WebSignature
implements Signature,
Serializable {
    protected byte[] signatureBytes = null;
    private String contentType = null;
    private static final long serialVersionUID = 1L;
    private transient SignatureProviderInterface impl = null;
    private static final int INTERNET_EXPLORER = 1;
    private static final int MOZILLA_FIREFOX = 2;
    private int origin;

    public WebSignature(String firma) throws SignatureDataException {
        if (firma.startsWith("FF:")) {
            this.origin = 2;
        } else if (firma.startsWith("IE:")) {
            this.origin = 1;
        } else {
            throw new SignatureDataException();
        }
        int len = firma.indexOf(":", 3);
        try {
            Class<?> base64Class = ClassLoaderFactory.getFactory().getMasterClassLoader().loadClass("org.bouncycastle.util.encoders.Base64");
            Method m = base64Class.getMethod("decode", String.class);
            this.signatureBytes = (byte[])m.invoke(null, firma.substring(len + 1));
            this.contentType = firma.substring(3, len);
            this.init();
        }
        catch (Exception e) {
            throw new SignatureDataException(e);
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setPkcs7(byte[] pkcs7) {
        this.signatureBytes = pkcs7;
    }

    private void init() throws IOException {
        if (this.impl == null) {
            try {
                ClassLoader cl = ClassLoaderFactory.getFactory().getMasterClassLoader();
                Class<?> clazz = cl.loadClass(this.getInternalClassName());
                this.impl = (SignatureProviderInterface)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.impl.setContentType(this.contentType);
            this.impl.setSignedData(this.signatureBytes);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse signature");
        }
    }

    protected String getInternalClassName() {
        if (this.origin == 1) {
            return "es.caib.signatura.provider.impl.common.CapicomSignatureImpl";
        }
        if (this.origin == 2) {
            return "es.caib.signatura.provider.impl.common.CMSSignatureImplv2";
        }
        throw new RuntimeException("Signature type unknown " + this.origin);
    }

    public String getCertCaName() {
        return this.impl.getCertCaName();
    }

    public String getCertSubjectCommonName() {
        return this.impl.getCertSubjectCommonName();
    }

    public String getCertSubjectAlternativeNames() {
        return this.impl.getCertSubjectAlternativeNames();
    }

    public byte[] getPkcs7() {
        return this.signatureBytes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public Date getDate() throws SignatureTimestampException {
        return this.impl.getDate();
    }

    public boolean verify() throws SignatureVerifyException {
        return this.impl.verify();
    }

    public String getContentType() {
        return this.contentType;
    }

    public X509Certificate getCert() {
        return this.impl.getCert();
    }

    public X509Certificate[] getCertificateChain() throws Exception {
        return this.impl.getCertificateChain();
    }

    public ParsedCertificate getParsedCertificate() {
        return this.impl.getParsedCertificate();
    }

    public boolean verify(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean isVerified = true;
        try {
            isVerified = isVerified && this.impl.verify(contentStream);
        }
        catch (SignatureVerifyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureVerifyException(e);
        }
        return isVerified;
    }

    public boolean verifyAPosterioriTimestamp(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean isVerified = true;
        try {
            boolean bl = isVerified = isVerified && this.impl.verifyAPosterioriTimestamp(contentStream);
            if (isVerified) {
                this.setPkcs7(this.impl.getPkcs7());
            }
        }
        catch (SignatureVerifyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureVerifyException(e);
        }
        return isVerified;
    }
}

