/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.api;

import es.caib.signatura.api.Signer;
import es.caib.signatura.api.UpgradeNeededException;
import es.caib.signatura.impl.CAIBSigner;
import es.caib.signatura.impl.SigUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class SignerFactory {
    static boolean started = false;
    private static Map signerConfiguration = null;
    public String updateSite = null;
    private String configurationFile = null;
    private String propertiesCache = null;

    public SignerFactory() {
    }

    public SignerFactory(Map signerConfig) {
        signerConfiguration = signerConfig;
    }

    public String getAPIVersion() throws FileNotFoundException, IOException {
        InputStream inputStream = SignerFactory.class.getResourceAsStream("version.properties");
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        Properties tempProperties = new Properties();
        tempProperties.load(inputStream);
        inputStream.close();
        return tempProperties.getProperty("Version");
    }

    public void configUpdateSite() throws FileNotFoundException, IOException {
        InputStream inputStream = SignerFactory.class.getResourceAsStream("version.properties");
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        Properties tempProperties = new Properties();
        tempProperties.load(inputStream);
        inputStream.close();
        this.updateSite = tempProperties.getProperty("updateSite");
        this.configurationFile = tempProperties.getProperty("configurationFile");
        this.propertiesCache = tempProperties.getProperty("propertiesCache");
    }

    public String getUpdateSite() throws FileNotFoundException, IOException {
        this.configUpdateSite();
        return this.updateSite;
    }

    public Signer getSigner() throws UpgradeNeededException {
        try {
            if (!started) {
                started = true;
            }
            CAIBSigner s = null;
            if (signerConfiguration != null) {
                s = new CAIBSigner(signerConfiguration);
            } else {
                this.configUpdateSite();
                s = new CAIBSigner(this.updateSite, new URL(this.configurationFile), this.propertiesCache);
            }
            if (!this.isValidVersion(this.getAPIVersion(), s.getAPIVersion())) {
                System.out.println("Necesita actualizarse a la versi\u00f3n " + this.getAPIVersion() + " o superior. Actualmente tiene instalada la versi\u00f3n " + s.getAPIVersion());
                throw new UpgradeNeededException("Necesita actualizarse a la versi\u00f3n " + this.getAPIVersion() + " o superior. Actualmente tiene instalada la versi\u00f3n " + s.getAPIVersion(), SigUtil.getUpgradeUrl());
            }
            return s;
        }
        catch (Throwable e) {
            throw new UpgradeNeededException("Sistema de firma no instalado, o requiere reiniciar navegador", SigUtil.getUpgradeUrl(), e);
        }
    }

    private boolean isValidVersion(String apiVersion, String jreVersion) {
        if (jreVersion == null) {
            return false;
        }
        if (apiVersion == null) {
            return false;
        }
        String[] splitJRE = jreVersion.split("[.-]");
        String[] splitAPI = apiVersion.split("[.-]");
        for (int i = 0; i < Math.max(splitAPI.length, splitJRE.length); ++i) {
            try {
                int v2;
                int v1 = i < splitJRE.length ? Integer.parseInt(splitJRE[i]) : -1;
                int n = v2 = i < splitAPI.length ? Integer.parseInt(splitAPI[i]) : -1;
                if (v1 > v2) {
                    return true;
                }
                if (v1 >= v2) continue;
                return false;
            }
            catch (NumberFormatException e) {
                if (i >= splitJRE.length) {
                    return false;
                }
                if (splitJRE[i].compareTo(splitAPI[i]) > 0) {
                    return true;
                }
                if (splitJRE[i].compareTo(splitAPI[i]) >= 0) continue;
                return false;
            }
        }
        return true;
    }
}

