/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.api.SignerFactory;
import java.net.URL;
import java.net.URLEncoder;

public class SigUtil {
    public static String OS_UNAVAILABLE = "No disponible";
    public static String OS_UNKNOWN = "Desconocido";
    public static String OS_WINDOWS = "windows";
    public static String OS_LINUX = "Linux";
    public static String OS_MAC = "Mac";
    public static String OS_REGEXP_WINDOWS = "\\A(?i:win).*\\z";
    public static String OS_REGEXP_LINUX = "\\A(?i:linux).*\\z";
    public static String OS_REGEXP_MAC = "\\A(?i:mac).*\\z";

    public static String getCurrentOs() {
        String currentOsName = null;
        try {
            currentOsName = System.getProperty("os.name");
        }
        catch (Throwable t) {
            currentOsName = null;
            t.printStackTrace();
        }
        if (currentOsName == null || currentOsName.length() == 0) {
            return OS_UNAVAILABLE;
        }
        if (currentOsName != null) {
            if (currentOsName.matches(OS_REGEXP_WINDOWS)) {
                return OS_WINDOWS;
            }
            if (currentOsName.matches(OS_REGEXP_LINUX)) {
                return OS_LINUX;
            }
            if (currentOsName.matches(OS_REGEXP_MAC)) {
                return OS_MAC;
            }
        }
        return OS_UNKNOWN;
    }

    public static String getCurrentJVMPath() {
        try {
            return System.getProperty("java.home");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static URL getUpgradeUrl() {
        try {
            SignerFactory sf = new SignerFactory();
            String updateSite = sf.getUpdateSite();
            if (updateSite != null && !updateSite.equals("")) {
                String installUrl = updateSite + "/install.jnlp";
                String surl = installUrl + "?os=" + URLEncoder.encode(SigUtil.getCurrentOs(), "UTF-8");
                URL url = new URL(surl);
                return url;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

