/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.impl.ClassLoaderFactory;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.net.InetAddress;
import java.net.NetPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.logging.LoggingPermission;

public class CAIBSecurityManager
extends SecurityManager {
    private SecurityManager proxy;
    private static boolean isRegistered = false;
    private ClassLoader trustedClassLoader;
    private ClassLoader systemClassLoader;
    private ThreadLocal checkIn = new ThreadLocal(){
        private boolean ckechInBoolean = false;

        protected synchronized Object initialValue() {
            return new Boolean(this.ckechInBoolean);
        }

        public synchronized void set(Object booleanObject) {
            if (booleanObject != null && booleanObject instanceof Boolean) {
                Boolean booleanValue = (Boolean)booleanObject;
                this.ckechInBoolean = booleanValue;
            }
        }

        public synchronized Object get() {
            return new Boolean(this.ckechInBoolean);
        }
    };
    static /* synthetic */ Class class$es$caib$signatura$impl$CAIBSecurityManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAllPermission() {
        if (this.getInCheck()) {
            return true;
        }
        try {
            this.checkIn.set(new Boolean(true));
            Class<?>[] classes = this.getClassContext();
            for (int i = classes.length - 1; i >= 0; --i) {
                try {
                    ClassLoader cl = classes[i].getClassLoader();
                    if (classes[i] == (class$es$caib$signatura$impl$CAIBSecurityManager == null ? CAIBSecurityManager.class$("es.caib.signatura.impl.CAIBSecurityManager") : class$es$caib$signatura$impl$CAIBSecurityManager) || cl != (class$es$caib$signatura$impl$CAIBSecurityManager == null ? CAIBSecurityManager.class$("es.caib.signatura.impl.CAIBSecurityManager") : class$es$caib$signatura$impl$CAIBSecurityManager).getClassLoader() || !classes[i].getPackage().getName().startsWith("es.caib.signatura.")) continue;
                    this.checkIn.set(new Boolean(false));
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    System.out.println("WARNING. Exception at security manager:");
                    e.printStackTrace(System.out);
                }
            }
        }
        finally {
            this.checkIn.set(new Boolean(false));
        }
        return false;
    }

    public static void register() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (!isRegistered && System.getSecurityManager() != null) {
                        System.setSecurityManager(new CAIBSecurityManager(System.getSecurityManager()));
                        isRegistered = true;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public CAIBSecurityManager(SecurityManager proxy) {
        this.proxy = proxy;
        try {
            this.trustedClassLoader = ClassLoaderFactory.getFactory().getMasterClassLoader();
            this.systemClassLoader = this.getClass().getClassLoader();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void checkAccept(String host, int port) {
        this.proxy.checkAccept(host, port);
    }

    public void checkAccess(Thread t) {
        this.proxy.checkAccess(t);
    }

    public void checkAccess(ThreadGroup g) {
        this.proxy.checkAccess(g);
    }

    public void checkAwtEventQueueAccess() {
        this.proxy.checkAwtEventQueueAccess();
    }

    public void checkConnect(String host, int port, Object context) {
        if (!this.hasAllPermission()) {
            this.proxy.checkConnect(host, port, context);
        }
    }

    public void checkConnect(String host, int port) {
        if (this.hasAllPermission()) {
            return;
        }
        this.proxy.checkConnect(host, port);
    }

    public void checkCreateClassLoader() {
        if (!this.hasAllPermission()) {
            this.proxy.checkCreateClassLoader();
        }
    }

    public void checkDelete(String file) {
        if (this.hasAllPermission() && file.startsWith(System.getProperty("java.io.tmpdir")) && file.endsWith("pkcs11.cfg")) {
            return;
        }
        this.proxy.checkDelete(file);
    }

    public void checkExec(String cmd) {
        if (!this.hasAllPermission()) {
            this.proxy.checkExec(cmd);
        }
    }

    public void checkExit(int status) {
        this.proxy.checkExit(status);
    }

    public void checkLink(String lib) {
        if (!this.hasAllPermission()) {
            this.proxy.checkLink(lib);
        }
    }

    public void checkListen(int port) {
        this.proxy.checkListen(port);
    }

    public void checkMemberAccess(Class arg0, int arg1) {
        if (this.hasAllPermission()) {
            return;
        }
        this.proxy.checkMemberAccess(arg0, arg1);
    }

    public void checkMulticast(InetAddress maddr, byte ttl) {
        this.proxy.checkMulticast(maddr, ttl);
    }

    public void checkMulticast(InetAddress maddr) {
        this.proxy.checkMulticast(maddr);
    }

    public void checkPackageAccess(String pkg) {
        if (this.hasAllPermission()) {
            return;
        }
        if (pkg.startsWith("sun.security.pkcs11")) {
            return;
        }
        this.proxy.checkPackageAccess(pkg);
    }

    public void checkPackageDefinition(String pkg) {
        this.proxy.checkPackageDefinition(pkg);
    }

    public void checkPermission(Permission perm, Object context) {
        if (perm instanceof LoggingPermission && this.hasAllPermission()) {
            return;
        }
        if (perm instanceof RuntimePermission && this.hasAllPermission()) {
            return;
        }
        this.proxy.checkPermission(perm, context);
    }

    public void checkPermission(Permission perm) {
        FilePermission fperm;
        if (perm instanceof FilePermission && "read".equals((fperm = (FilePermission)perm).getActions()) && this.hasAllPermission()) {
            return;
        }
        if (perm instanceof SecurityPermission && perm.getName().startsWith("authProvider.SunPKCS11-")) {
            return;
        }
        if (perm instanceof SecurityPermission && perm.getName().startsWith("authProvider.SunMSCAPI")) {
            return;
        }
        if (perm instanceof LoggingPermission && this.hasAllPermission()) {
            return;
        }
        if (perm instanceof RuntimePermission && this.hasAllPermission()) {
            return;
        }
        if (perm instanceof NetPermission && "specifyStreamHandler".equals(perm.getName()) && this.hasAllPermission()) {
            return;
        }
        this.proxy.checkPermission(perm);
    }

    public void checkPrintJobAccess() {
        this.proxy.checkPrintJobAccess();
    }

    public void checkPropertiesAccess() {
        if (!this.hasAllPermission()) {
            this.proxy.checkPropertiesAccess();
        }
    }

    public void checkPropertyAccess(String key) {
        if (!this.hasAllPermission()) {
            this.proxy.checkPropertyAccess(key);
        }
    }

    public void checkRead(FileDescriptor fd) {
        if (!this.hasAllPermission()) {
            this.proxy.checkRead(fd);
        }
    }

    public void checkRead(String file, Object context) {
        if (!this.hasAllPermission()) {
            this.proxy.checkRead(file, context);
        }
    }

    public void checkRead(String file) {
        if (!this.hasAllPermission()) {
            this.proxy.checkRead(file);
        }
    }

    public void checkSecurityAccess(String target) {
        if ((target.startsWith("putProviderProperty.") || target.startsWith("insertProvider.")) && this.hasAllPermission()) {
            return;
        }
        this.proxy.checkSecurityAccess(target);
    }

    public void checkSetFactory() {
        this.proxy.checkSetFactory();
    }

    public void checkSystemClipboardAccess() {
        this.proxy.checkSystemClipboardAccess();
    }

    public boolean checkTopLevelWindow(Object window) {
        return this.proxy.checkTopLevelWindow(window);
    }

    public void checkWrite(FileDescriptor fd) {
        if (this.hasAllPermission()) {
            return;
        }
        this.proxy.checkWrite(fd);
    }

    public void checkWrite(String file) {
        if (this.hasAllPermission() && (file.startsWith(System.getProperty("java.io.tmpdir")) && file.endsWith("pkcs11.cfg") || file.contains("signatura_api.properties") || file.contains("serviceLog.txt"))) {
            return;
        }
        this.proxy.checkWrite(file);
    }

    public boolean equals(Object obj) {
        return this.proxy.equals(obj);
    }

    public boolean getInCheck() {
        boolean toReturn = false;
        if (this.checkIn.get() != null && this.checkIn.get() instanceof Boolean && ((Boolean)this.checkIn.get()).booleanValue()) {
            toReturn = true;
        }
        toReturn = toReturn || this.proxy.getInCheck();
        return toReturn;
    }

    public Object getSecurityContext() {
        return this.proxy.getSecurityContext();
    }

    public ThreadGroup getThreadGroup() {
        return this.proxy.getThreadGroup();
    }

    public int hashCode() {
        return this.proxy.hashCode();
    }

    public String toString() {
        return this.proxy.toString();
    }
}

