/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import [Ljava.security.cert.X509Certificate;;
import es.caib.signatura.api.ParsedCertificate;
import es.caib.signatura.api.SMIMEParser;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureCertNotFoundException;
import es.caib.signatura.api.SignatureException;
import es.caib.signatura.api.SignaturePrivKeyException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.api.Signer;
import es.caib.signatura.impl.CAIBSecurityManager;
import es.caib.signatura.impl.ClassLoaderFactory;
import es.caib.signatura.impl.GeneradorSMIMEParalelo;
import es.caib.signatura.impl.LocalSignerProviderInterface;
import es.caib.signatura.impl.RemoteSignerProviderInterface;
import es.caib.signatura.impl.SMIMEGenerator;
import es.caib.signatura.impl.SMIMEInputStream;
import es.caib.signatura.impl.SMIMEParserProxy;
import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.impl.SignerProviderInterface;
import es.caib.signatura.impl.ui.FirefoxSignerProfileChooser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CAIBSigner
implements Signer {
    private static LinkedHashMap realSigners = null;
    private static LinkedHashMap remoteRealSigners = null;
    private SignaturaProperties properties = null;
    private static ClassLoaderFactory factory;
    private static Object lock;

    private SignerProviderInterface getSigner(String certificateName, String contentType) throws SignatureCertNotFoundException {
        Object[] providerCerts;
        SignerProviderInterface s;
        boolean recognized = this.properties.needsRecognizedCertificate(contentType);
        Iterator signersIterator = realSigners.values().iterator();
        Iterator remoteSignersIterator = remoteRealSigners.values().iterator();
        LinkedList<SignerProviderInterface> providers = new LinkedList<SignerProviderInterface>();
        LinkedList<Object> certs = new LinkedList<Object>();
        block8: while (signersIterator.hasNext()) {
            s = (LocalSignerProviderInterface)signersIterator.next();
            try {
                providerCerts = s.getCertList(recognized);
                for (int j = 0; j < providerCerts.length; ++j) {
                    if (!providerCerts[j].getCommonName().equals(certificateName)) continue;
                    providers.add(s);
                    certs.add(providerCerts[j]);
                    continue block8;
                }
            }
            catch (SignatureCertNotFoundException e) {
            }
            catch (SignaturePrivKeyException e) {
            }
            catch (ProviderException e) {
            }
        }
        while (remoteSignersIterator.hasNext()) {
            s = (RemoteSignerProviderInterface)remoteSignersIterator.next();
            try {
                providerCerts = s.getCertList(recognized);
                for (int j = 0; j < providerCerts.length; ++j) {
                    if (!((String)providerCerts[j]).equals(certificateName)) continue;
                    System.out.println("Seleccionado " + certificateName + " con el provider " + s.getClass().getName());
                    return s;
                }
            }
            catch (SignatureCertNotFoundException e) {
            }
            catch (SignaturePrivKeyException e) {
            }
            catch (ProviderException e) {
            }
        }
        if (SigDebug.isActive()) {
            SigDebug.write("CAIBSIGNER: filtrando certificados con el CN '" + certificateName + "' entre signers...");
        }
        if (certs.size() > 0) {
            s = null;
            Date validSince = null;
            int i = 0;
            for (i = 0; i < providers.size(); ++i) {
                LocalSignerProviderInterface key = (LocalSignerProviderInterface)providers.get(i);
                ParsedCertificate parsed = (ParsedCertificate)certs.get(i);
                if (SigDebug.isActive()) {
                    SigDebug.write("CAIBSIGNER: comprobando signer " + key);
                    SigDebug.write("CAIBSIGNER: Emisi\u00f3n: " + parsed.getValidSince().getTime());
                }
                if (validSince != null) {
                    if (SigDebug.isActive()) {
                        SigDebug.write("CAIBSIGNER: Stored Emisi\u00f3n: " + validSince.getTime());
                    } else if (SigDebug.isActive()) {
                        SigDebug.write("CAIBSIGNER: Stored Emisi\u00f3n: null");
                    }
                }
                if (validSince == null || validSince.getTime() < parsed.getValidSince().getTime()) {
                    if (SigDebug.isActive()) {
                        SigDebug.write("CAIBSIGNER: El certificado del signer " + key.getClass().getName() + " tiene una fecha de emisi\u00f3n m\u00e1s reciente que el del signer almacenado " + s.getClass().getName());
                        SigDebug.write("CAIBSIGNER: Actualizando datos temporales");
                    }
                    validSince = parsed.getValidSince();
                    s = key;
                    continue;
                }
                if (!SigDebug.isActive()) continue;
                SigDebug.write("CAIBSIGNER: El certificado del signer " + key.getClass().getName() + " tiene una fecha de emisi\u00f3n menor o igual que el del signer almacenado " + s.getClass().getName());
                SigDebug.write("CAIBSIGNER: DESCARTADO...");
            }
            if (SigDebug.isActive()) {
                SigDebug.write("CAIBSIGNER: filtro de certificados duplicados para '" + certificateName + "' completado");
            }
            if (s != null) {
                System.out.println("Seleccionado " + certificateName + " con el provider " + s.getClass().getName());
                return s;
            }
            throw new SignatureCertNotFoundException();
        }
        throw new SignatureCertNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCertList(String contentType) throws SignatureCertNotFoundException, SignaturePrivKeyException {
        Object object = lock;
        synchronized (object) {
            Iterator remoteSignersIterator;
            Object[] certs;
            boolean recognized;
            SignerProviderInterface s;
            Iterator signersIterator;
            Vector<Object> v = new Vector<Object>();
            Collection signersCollection = realSigners.values();
            Collection remoteSignersCollection = remoteRealSigners.values();
            if (signersCollection != null && (signersIterator = signersCollection.iterator()) != null) {
                while (signersIterator.hasNext()) {
                    s = (LocalSignerProviderInterface)signersIterator.next();
                    recognized = this.properties.needsRecognizedCertificate(contentType);
                    try {
                        certs = s.getCertList(recognized);
                        for (int j = 0; j < certs.length; ++j) {
                            if (v.contains(certs[j].getCommonName())) continue;
                            v.add(certs[j].getCommonName());
                        }
                    }
                    catch (SignatureCertNotFoundException e) {
                    }
                    catch (SignaturePrivKeyException e) {
                        e.printStackTrace();
                    }
                    catch (Throwable e) {
                        System.err.println("CANNOT LOAD on signature provider " + s.getClass().getName());
                        e.printStackTrace();
                    }
                }
            }
            if (remoteSignersCollection != null && (remoteSignersIterator = remoteSignersCollection.iterator()) != null) {
                while (remoteSignersIterator.hasNext()) {
                    s = (RemoteSignerProviderInterface)remoteSignersIterator.next();
                    recognized = this.properties.needsRecognizedCertificate(contentType);
                    try {
                        certs = s.getCertList(recognized);
                        for (int j = 0; j < certs.length; ++j) {
                            if (v.contains(certs[j])) continue;
                            v.add(certs[j]);
                        }
                    }
                    catch (SignatureCertNotFoundException e) {
                    }
                    catch (SignaturePrivKeyException e) {
                        e.printStackTrace();
                    }
                    catch (Throwable e) {
                        System.err.println("CANNOT LOAD on signature provider " + s.getClass().getName());
                        e.printStackTrace();
                    }
                }
            }
            return v.toArray(new String[v.size()]);
        }
    }

    public Signature sign(String fileName, String certificateName, String password, String contentType) throws IOException, SignatureException {
        return this.sign(new FileInputStream(fileName), certificateName, password, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature sign(InputStream contentStream, String certificateName, String password, String contentType) throws IOException, SignatureException {
        Object object = lock;
        synchronized (object) {
            boolean recognized = this.properties.needsRecognizedCertificate(contentType);
            boolean timeStamp = this.properties.needsTimeStamp(contentType);
            boolean rawSign = this.properties.needsRawSignature(contentType);
            SignerProviderInterface signer = this.getSigner(certificateName, contentType);
            if (password == null) {
                if (SigDebug.isActive()) {
                    SigDebug.write("Password is null.");
                }
                password = "";
            }
            if (SigDebug.isActive()) {
                SigDebug.write("CAIBSigned.sign: password is" + (password.length() == 0 ? "" : " not") + " empty.");
            }
            return signer.sign(contentStream, certificateName, password, contentType, recognized, timeStamp, rawSign);
        }
    }

    public Signature sign(URL url, String certificateName, String password, String contentType) throws IOException, SignatureException {
        return this.sign(url.openStream(), certificateName, password, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signPDF(InputStream contentStream, OutputStream signedStream, String certificateName, String password, String contentType, String url, int position, boolean allowMultipleSignature) throws IOException, SignatureException {
        Object object = lock;
        synchronized (object) {
            boolean recognized = this.properties.needsRecognizedCertificate(contentType);
            SignerProviderInterface signer = this.getSigner(certificateName, contentType);
            if (SigDebug.isActive()) {
                SigDebug.write("Comprovacio password null.");
            }
            if (password == null) {
                if (SigDebug.isActive()) {
                    SigDebug.write("Posem el password a cadena buida.");
                }
                password = "";
            }
            if (SigDebug.isActive()) {
                SigDebug.write("CAIBSigned.sign: password " + (password.length() == 0 ? "es" : "no es") + " buit.");
            }
            signer.signPDF(contentStream, signedStream, certificateName, password, contentType, recognized, url, position, allowMultipleSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signPDF(InputStream pdfInputStream, OutputStream signedStream, String certificateName, String password, String contentType, String textoAdicional, int stampOptions, float top, float left, float height, float width, float rotation, boolean allowMultipleSignature) throws IOException, SignatureException {
        Object object = lock;
        synchronized (object) {
            boolean recognized = this.properties.needsRecognizedCertificate(contentType);
            SignerProviderInterface signer = this.getSigner(certificateName, contentType);
            if (SigDebug.isActive()) {
                SigDebug.write("Comprovacio password null.");
            }
            if (password == null) {
                if (SigDebug.isActive()) {
                    SigDebug.write("Posem el password a cadena buida.");
                }
                password = "";
            }
            if (SigDebug.isActive()) {
                SigDebug.write("CAIBSigned.sign: password " + (password.length() == 0 ? "es" : "no es") + " buit.");
            }
            signer.signPDF(pdfInputStream, signedStream, certificateName, password, contentType, recognized, textoAdicional, stampOptions, top, left, height, width, rotation, allowMultipleSignature);
        }
    }

    public void signPDF(InputStream contentStream, OutputStream signedStream, String certificateName, String password, String contentType, String url, int position) throws IOException, SignatureException {
        this.signPDF(contentStream, signedStream, certificateName, password, contentType, url, position, false);
    }

    public OutputStream signPDF(InputStream contentStream, String certificateName, String password, String contentType, String url, int position, boolean allowMultipleSignature) throws IOException, SignatureException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.signPDF(contentStream, out, certificateName, password, contentType, url, position, allowMultipleSignature);
        return out;
    }

    public OutputStream signPDF(InputStream contentStream, String certificateName, String password, String contentType, String url, int position) throws IOException, SignatureException {
        return this.signPDF(contentStream, certificateName, password, contentType, url, position, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void certifyDigitalCopy(InputStream contentStream, OutputStream signedStream, String certificateName, String password, String contentType, String url, String localidad, float x, float y, float rotation) throws IOException, SignatureException {
        Object object = lock;
        synchronized (object) {
            boolean recognized = this.properties.needsRecognizedCertificate(contentType);
            SignerProviderInterface signer = this.getSigner(certificateName, contentType);
            if (SigDebug.isActive()) {
                SigDebug.write("Comprovacio password null.");
            }
            if (password == null) {
                if (SigDebug.isActive()) {
                    SigDebug.write("Posem el password a cadena buida.");
                }
                password = "";
            }
            if (SigDebug.isActive()) {
                SigDebug.write("CAIBSigned.certify: password " + (password.length() == 0 ? "es" : "no es") + " buit.");
            }
            signer.certifyDigitalCopy(contentStream, signedStream, certificateName, password, contentType, recognized, url, localidad, x, y, rotation, this.properties);
        }
    }

    public boolean verify(InputStream contentStream, Signature signatureData) throws SignatureProviderException, IOException, SignatureVerifyException {
        try {
            boolean isVerified = false;
            isVerified = signatureData.verify(contentStream);
            return isVerified;
        }
        catch (SignatureVerifyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureVerifyException(e);
        }
    }

    public boolean verifyAPosterioriTimeStamp(InputStream contentStream, Signature signatureData) throws SignatureProviderException, IOException, SignatureVerifyException {
        boolean isVerified = false;
        try {
            isVerified = signatureData.verifyAPosterioriTimestamp(contentStream);
        }
        catch (SignatureVerifyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureVerifyException(e);
        }
        return isVerified;
    }

    public boolean verify(String fileName, Signature signatureData) throws FileNotFoundException, SignatureProviderException, IOException, SignatureVerifyException {
        return this.verify(new FileInputStream(fileName), signatureData);
    }

    public boolean verify(URL url, Signature signatureData) throws SignatureProviderException, IOException, SignatureVerifyException {
        return this.verify(url.openStream(), signatureData);
    }

    public boolean verifyAPosterioriTimeStamp(String fileName, Signature signatureData) throws FileNotFoundException, SignatureProviderException, IOException, SignatureVerifyException {
        return this.verifyAPosterioriTimeStamp(new FileInputStream(fileName), signatureData);
    }

    public boolean verifyAPosterioriTimeStamp(URL url, Signature signatureData) throws SignatureProviderException, IOException, SignatureVerifyException {
        return this.verifyAPosterioriTimeStamp(url.openStream(), signatureData);
    }

    public void generateSMIME(InputStream document, Signature signature, OutputStream smime) throws IOException {
        int read;
        SMIMEGenerator smimeGenerator;
        try {
            Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.common.SMIMEGeneratorImpl");
            smimeGenerator = (SMIMEGenerator)c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        InputStream in = smimeGenerator.generateSMIME(document, signature);
        byte[] b = new byte[8192];
        while ((read = in.read(b)) > 0) {
            smime.write(b, 0, read);
        }
        in.close();
    }

    public void generateSMIMEParalell(InputStream document, Signature[] signatures, OutputStream smime) throws IOException, SignatureException {
        try {
            int read;
            Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.common.GeneradorSMIMEParaleloImpl");
            GeneradorSMIMEParalelo generadorSMIMEParalelo = (GeneradorSMIMEParalelo)c.newInstance();
            SMIMEInputStream in = generadorSMIMEParalelo.generarSMIMEParalelo(document, signatures);
            byte[] b = new byte[8192];
            while ((read = in.read(b)) > 0) {
                smime.write(b, 0, read);
            }
            in.close();
        }
        catch (IOException iox) {
            throw iox;
        }
        catch (Exception e) {
            throw new SignatureException(e.getMessage());
        }
    }

    public Date getCurrentDate(String certificateName, String password, String contentType) throws SignatureTimestampException, SignatureException, IOException {
        if (password == null) {
            password = "";
        }
        if (SigDebug.isActive()) {
            SigDebug.write("CAIBSigned.getCurrentDate: password " + (password.length() == 0 ? "is" : "is not") + " null.");
        }
        boolean recognized = this.properties.needsRecognizedCertificate(contentType);
        return this.getSigner(certificateName, contentType).getCurrentDate(certificateName, password, recognized);
    }

    public String getAPIVersion() {
        try {
            InputStream inputStream = CAIBSigner.class.getResourceAsStream("version.properties");
            if (inputStream == null) {
                throw new FileNotFoundException();
            }
            Properties tempProperties = new Properties();
            tempProperties.load(inputStream);
            inputStream.close();
            return tempProperties.getProperty("Version");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CAIBSigner() throws FileNotFoundException {
        this.preInitialize();
        try {
            this.properties = new SignaturaProperties();
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        this.initialize();
    }

    public CAIBSigner(String updateSite, URL configurationFile, String propertiesCachePath) throws FileNotFoundException {
        this.preInitialize();
        try {
            this.properties = new SignaturaProperties(updateSite, configurationFile, propertiesCachePath);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        this.initialize();
    }

    public CAIBSigner(Map signerConfiguration) throws FileNotFoundException {
        this.preInitialize();
        try {
            this.properties = new SignaturaProperties(signerConfiguration);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        this.initialize();
    }

    protected void preInitialize() throws FileNotFoundException {
        CAIBSecurityManager.register();
        if (factory == null) {
            factory = ClassLoaderFactory.getFactory();
            realSigners = new LinkedHashMap();
            remoteRealSigners = new LinkedHashMap();
        }
    }

    protected void initialize() throws FileNotFoundException {
        block40: {
            try {
                InputStream inputStream;
                if (Security.getProvider("BC") == null) {
                    Provider p = (Provider)factory.getMasterClassLoader().loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
                    Security.addProvider(p);
                }
                if ((inputStream = factory.getMasterClassLoader().getResourceAsStream("es/caib/signatura/provider/impl/lunaPCI/LunaPCISigner.class")) != null) {
                    Provider p;
                    if (Security.getProvider("LunaJCE") == null) {
                        p = (Provider)factory.getMasterClassLoader().loadClass("com.chrysalisits.cryptox.LunaJCEProvider").newInstance();
                        Security.addProvider(p);
                    }
                    if (Security.getProvider("LunaJCA") == null) {
                        p = (Provider)factory.getMasterClassLoader().loadClass("com.chrysalisits.crypto.LunaJCAProvider").newInstance();
                        Security.addProvider(p);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (SigDebug.getLevel() == 0) {
                SigDebug.setLevel(this.properties.getProperty("debugLevel"));
            }
            if (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("tradise") == -1) {
                try {
                    this.addTradiseSigner("tradise");
                    SigDebug.write("[DBG] ACTIVAT TRADISE.");
                }
                catch (FileNotFoundException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                File dirDev = new File(factory.getLibraryDir(), "tradise-dev");
                if (dirDev.isDirectory()) {
                    try {
                        this.addTradiseSigner("tradise-dev");
                        SigDebug.write("[DBG] ACTIVAT TRADISE TEST.");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("PKCS11") == -1) {
                String[] drivers = this.properties.getPKCS11Drivers();
                for (int i = 0; i < drivers.length; ++i) {
                    try {
                        if (!this.addPKCS11Signer(drivers[i])) continue;
                        SigDebug.write("[DBG] ACTIVAT PKCS11 " + drivers[i] + ".");
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            if (System.getProperty("os.name").contains("Windows") && (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("MSCRYPTOAPI") == -1)) {
                try {
                    this.addMscryptoapiSigner();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("LUNAPCI") == -1) {
                try {
                    if (this.addLunaPCISigner()) {
                        SigDebug.write("[DBG] ACTIVAT LUNAPCI.");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("WEBSERVICESIGNER") == -1) {
                try {
                    if (this.addWebServiceSigner()) {
                        SigDebug.write("[DBG] ACTIVAT WEBSERVICESIGNER.");
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("FIREFOXSIGNER") == -1) {
                try {
                    if (this.addFirefoxSigner(factory)) {
                        SigDebug.write("[DBG] ACTIVAT FIREFOXSIGNER.");
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (System.getProperty("es.caib.provider.unactive") == null || System.getProperty("es.caib.provider.unactive").indexOf("BC") == -1) {
                if (System.getProperty("caib-crypto-keystore-password") != null) {
                    try {
                        if (this.addBcCryptoApiSigner()) {
                            SigDebug.write("[DBG] ACTIVAT BC.");
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof SignatureException && e.getMessage().contains(".keystore")) {
                            SigDebug.write("WARNING (BC): el usuario no posee keystore por defecto. No se cargar\u00e1 el signer de BC.");
                            break block40;
                        }
                        e.printStackTrace();
                    }
                } else {
                    SigDebug.write("[DBG] System properties needed for BC signer are not set");
                }
            }
        }
    }

    private boolean addPKCS11Signer(String libraryName) throws Exception {
        File f = new File(libraryName);
        if (f.isAbsolute()) {
            String name = f.getName();
            if (realSigners.get(name) == null && this.addPKCS11Signer(name, f)) {
                return true;
            }
        } else if (realSigners.get(libraryName) == null) {
            String path = System.getProperty("java.library.path");
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                File next = new File(tokenizer.nextToken());
                f = new File(next, libraryName);
                if (this.addPKCS11Signer(libraryName, f)) {
                    return true;
                }
                f = new File(next, libraryName + ".dll");
                if (!this.addPKCS11Signer(libraryName, f)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean addPKCS11Signer(String libraryName, File f) throws Exception {
        if (f.canRead()) {
            String providerName = this.properties.getPKCS11DriversDescription(libraryName);
            File cfg = File.createTempFile(libraryName, "pkcs11.cfg");
            PrintWriter writer = new PrintWriter(new FileWriter(cfg));
            writer.println("name=" + libraryName);
            writer.println("library=" + f.getAbsolutePath());
            writer.close();
            cfg.deleteOnExit();
            Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.pkcs11.PKCS11Signer");
            Constructor<?> constructor = c.getConstructor(String.class, String.class);
            realSigners.put(libraryName, constructor.newInstance(cfg.getAbsolutePath(), providerName));
            return true;
        }
        return false;
    }

    private void addTradiseSigner(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException, FileNotFoundException {
        if (realSigners.get(name) == null) {
            ClassLoader loader = factory.getClassLoader(name);
            Class<?> c = loader.loadClass("es.caib.signatura.provider.impl.tradise.TradiseSigner");
            realSigners.put(name, c.newInstance());
        }
    }

    private boolean addBcCryptoApiSigner() throws SignatureException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.bccryptoapi.BcCryptoApiSigner");
        realSigners.put("bccryptoapi", c.newInstance());
        if (SigDebug.isActive()) {
            SigDebug.write("CAIBSigner: addBcCryptoApiSigner: Keystore certificates loaded.");
        }
        return true;
    }

    private boolean addWebServiceSigner() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        InputStream inputStream = factory.getMasterClassLoader().getResourceAsStream("es/caib/signatura/provider/impl/webServiceSigner/WebServiceSigner.class");
        if (inputStream != null) {
            Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.webServiceSigner.WebServiceSigner");
            remoteRealSigners.put("WebServiceSigner", c.newInstance());
            if (SigDebug.isActive()) {
                SigDebug.write("CAIBSigner: addWebServiceSigner: WebServiceSigner loaded.");
            }
            return true;
        }
        return false;
    }

    private void addMscryptoapiSigner() {
        if (realSigners.get("mscryptoapi") == null) {
            boolean is64bits;
            String fullVersion = System.getProperty("java.version");
            int lastIndex = fullVersion.lastIndexOf(".");
            String version = fullVersion.substring(0, lastIndex);
            float versionNumber = Float.valueOf(version).floatValue();
            boolean bl = is64bits = System.getProperty("os.arch").indexOf("64") != -1;
            if ((double)versionNumber >= 1.6 && is64bits) {
                try {
                    Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.sunmscapi.SunMSCAPIProvider");
                    realSigners.put("mscryptoapi", c.newInstance());
                    if (SigDebug.isActive()) {
                        SigDebug.write("CAIBSigner: addMscryptoapiSigner: es.caib.signatura.provider.impl.sunmscapi.SunMSCAPIProvider");
                    }
                    SigDebug.write("[DBG] ACTIVAT MSCAPI.");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    SigDebug.write("es.caib.signatura.provider.impl.sunmscapi.SunMSCAPIProvider cannot be loaded.");
                }
            } else {
                try {
                    File f;
                    String libraryName = System.getProperty("java.home") + "\\lib\\signaturacaib\\mscryptofunctions.dll";
                    if (SigDebug.isActive()) {
                        SigDebug.write("CAIBSigner: addMscryptoapiSigner: Path mscryptofunctions = " + libraryName);
                    }
                    if ((f = new File(libraryName)).canRead()) {
                        Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.mscryptoapi.MscryptoapiSigner");
                        realSigners.put("mscryptoapi", c.newInstance());
                        if (SigDebug.isActive()) {
                            SigDebug.write("CAIBSigner: addMscryptoapiSigner: Cargada mscryptofunctions.dll");
                        }
                    }
                    SigDebug.write("[DBG] ACTIVAT MSCRYPTOAPI.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SigDebug.write("mscryptofunctions.dll cannot be loaded.");
                }
            }
        }
    }

    private boolean addLunaPCISigner() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        InputStream inputStream = factory.getMasterClassLoader().getResourceAsStream("es/caib/signatura/provider/impl/lunaPCI/LunaPCISigner.class");
        if (inputStream != null) {
            Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.lunaPCI.LunaPCISigner");
            realSigners.put("lunaPCI", c.newInstance());
            if (SigDebug.isActive()) {
                SigDebug.write("CAIBSigner: addLunaPCISigner: Cargados los certificados del dispositivo");
            }
            return true;
        }
        return false;
    }

    public SMIMEParser getSMIMEParser(InputStream smime) throws InstantiationException, IllegalAccessException, IOException, SignatureException {
        return new SMIMEParserProxy(smime);
    }

    public ParsedCertificate parseCertificate(X509Certificate certificate) {
        try {
            Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.common.ParsedCertificateImpl");
            Constructor<?> constructor = c.getConstructor(X509Certificate;.class, Boolean.TYPE);
            return (ParsedCertificate)constructor.newInstance(new X509Certificate[]{certificate}, new Boolean(false));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean addFirefoxSigner(ClassLoaderFactory factory) throws Exception {
        String osName = null;
        String[] nssDirs = null;
        String nssLibraryDirectory = null;
        String profilesPath = null;
        String[] profileDirs = null;
        String homeDir = System.getProperty("user.home").replaceAll("\\\\", "/");
        if (System.getProperty("os.name").contains("Windows")) {
            osName = "windows";
            String programFiles32 = System.getenv("ProgramFiles").replaceAll("\\\\", "/");
            String programFiles64 = System.getenv("ProgramFiles(x86)");
            if (programFiles64 != null && !"".equals(programFiles64)) {
                programFiles64 = programFiles64.replaceAll("\\\\", "/");
                nssDirs = System.getProperty("os.arch").indexOf("64") != -1 ? new String[]{programFiles64 + "/Mozilla Firefox"} : new String[]{programFiles32 + "/Mozilla Firefox"};
            } else {
                nssDirs = new String[]{programFiles32 + "/Mozilla Firefox"};
            }
            String appdata = System.getenv("APPDATA").replaceAll("\\\\", "/");
            profileDirs = new String[]{appdata + "/Mozilla/Firefox/Profiles"};
        } else if (System.getProperty("os.name").contains("Linux")) {
            osName = "linux";
            File sysLibPath = new File("/usr/lib");
            File[] firefoxLibDirs = sysLibPath.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().contains("firefox");
                }
            });
            nssDirs = new String[firefoxLibDirs.length];
            int i = 0;
            for (i = 0; i < firefoxLibDirs.length; ++i) {
                nssDirs[i] = firefoxLibDirs[i].getAbsolutePath();
            }
            profileDirs = new String[]{homeDir + "/.mozilla/firefox"};
        } else if (System.getProperty("os.name").contains("Mac OS")) {
            osName = "mac";
            nssDirs = new String[]{"/Applications/Firefox.app/Contents/MacOS"};
            profileDirs = new String[]{homeDir + "/Library/Mozilla/Firefox/Profiles", homeDir + "/Library/Application Support/Firefox/Profiles"};
        } else {
            SigDebug.write("WARNING: OS not supported yet '" + System.getProperty("os.name") + "'");
            return false;
        }
        for (int i = 0; i < nssDirs.length; ++i) {
            SigDebug.write("NSSDir: " + nssDirs[i]);
        }
        if (nssDirs != null) {
            nssLibraryDirectory = CAIBSigner.firefoxSignerFindNSSLibraryDirectory(nssDirs, osName);
        }
        SigDebug.write("nssLibraryDirectory: " + nssLibraryDirectory);
        if (nssLibraryDirectory == null) {
            SigDebug.write("WARNING: NSS library directory not found");
            return false;
        }
        CAIBSigner.firefoxSignerLoadNSSLibraries(nssLibraryDirectory, osName);
        profilesPath = CAIBSigner.firefoxSignerFindProfilesDirectory(profileDirs);
        if (profilesPath == null) {
            SigDebug.write("WARNING: Profiles directory not found");
            return false;
        }
        File profilesDir = new File(profilesPath);
        File[] profilesDirFiles = CAIBSigner.firefoxSignerFilterProfileDirectories(profilesDir.listFiles());
        if (profilesDirFiles.length > 0) {
            int i = 0;
            try {
                if (profilesDirFiles.length > 1) {
                    i = CAIBSigner.firefoxSignerAskForUserProfile(profilesDirFiles);
                }
                String providerConfig = CAIBSigner.firefoxSignerGetProviderConfig(profilesDirFiles[i], profilesPath, nssLibraryDirectory);
                Class<?> c = factory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.firefox.FirefoxSigner");
                Constructor<?> constructor = c.getConstructor(String.class, String.class);
                realSigners.put("FIREFOXSIGNER", constructor.newInstance(providerConfig, profilesDirFiles[i].getName()));
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        } else {
            SigDebug.write("WARNING: No avalaible Firefox profiles found");
            return false;
        }
        return true;
    }

    private static int firefoxSignerAskForUserProfile(File[] profilesDirFiles) throws Exception {
        return FirefoxSignerProfileChooser.getFirefoxProfile(profilesDirFiles);
    }

    private static String firefoxSignerFindNSSLibraryDirectory(String[] dirs, String osName) {
        boolean found = false;
        String nssLibraryDirectory = null;
        String libName = null;
        if ("windows".equals(osName)) {
            libName = "/softokn3.dll";
        } else if ("linux".equals(osName)) {
            libName = "/libsoftokn3.so";
        } else if ("mac".equals(osName)) {
            libName = "/libsoftokn3.dylib";
        } else {
            return null;
        }
        for (int i = 0; i < dirs.length; ++i) {
            found = new File(dirs[i] + libName).exists();
            if (!found) continue;
            nssLibraryDirectory = dirs[i];
            break;
        }
        return nssLibraryDirectory;
    }

    private static String firefoxSignerFindProfilesDirectory(String[] dirs) {
        boolean found = false;
        String profilesPath = null;
        for (int i = 0; i < dirs.length; ++i) {
            boolean bl = found = new File(dirs[i]).exists() && new File(dirs[i]).isDirectory();
            if (!found) continue;
            profilesPath = dirs[i];
            break;
        }
        return profilesPath;
    }

    private static void firefoxSignerLoadNSSLibraries(String nssLibraryDirectory, String osName) {
        if ("windows".equals(osName)) {
            try {
                System.load(nssLibraryDirectory + "/mozcrt19.dll");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.load(nssLibraryDirectory + "/sqlite3.dll");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.load(nssLibraryDirectory + "/nspr4.dll");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.load(nssLibraryDirectory + "/plc4.dll");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.load(nssLibraryDirectory + "/plds4.dll");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.load(nssLibraryDirectory + "/nssutil3.dll");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
        } else if ("linux".equals(osName) || "mac".equals(osName)) {
            File nssLibDir = new File(nssLibraryDirectory);
            File[] nssLibs = nssLibDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".so") || pathname.getAbsolutePath().endsWith(".dylib");
                }
            });
            int i = 0;
            for (i = 0; i < nssLibs.length; ++i) {
                try {
                    System.load(nssLibs[i].getAbsolutePath());
                    continue;
                }
                catch (UnsatisfiedLinkError e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static File[] firefoxSignerFilterProfileDirectories(File[] dirs) {
        Vector<File> out = new Vector<File>();
        for (int i = 0; i < dirs.length; ++i) {
            String dir = dirs[i].getName();
            if (dir.length() <= 8 || dir.charAt(8) != '.' || dir.contains("profiles.ini")) continue;
            out.add(dirs[i]);
        }
        return out.toArray(new File[out.size()]);
    }

    private static String firefoxSignerGetProviderConfig(File profileDir, String profilesPath, String nssLibraryDirectory) throws FileNotFoundException {
        String profileDirName = profileDir.getName();
        String nssSecmodDirectory = profilesPath + "/" + profileDirName;
        if (System.getProperty("os.name").contains("Windows")) {
            if (System.getProperty("java.version").contains("7")) {
                nssLibraryDirectory = CAIBSigner.getWindowsShortPath(new File(nssLibraryDirectory)).replaceAll("\\\\", "\\\\");
                nssSecmodDirectory = CAIBSigner.getWindowsShortPath(new File(nssSecmodDirectory.replaceAll("/", "\\\\"))).replaceAll("\\\\", "\\\\").replaceAll("\\\\", "/");
            } else {
                nssLibraryDirectory = new File(nssLibraryDirectory).getAbsolutePath().replaceAll("\\\\", "\\\\");
                nssSecmodDirectory = new File(nssSecmodDirectory).getAbsolutePath().replaceAll("\\\\", "\\\\").replaceAll("\\\\", "/");
            }
        }
        String providerCfg = "name = NSS" + profileDirName + "\n" + "nssLibraryDirectory = " + nssLibraryDirectory + "\n" + "nssSecmodDirectory = \"" + nssSecmodDirectory + "\"\n" + "nssDbMode = readOnly\n" + "nssModule = keystore\n";
        return providerCfg;
    }

    public static String getWindowsShortPath(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException("Cannot get short path of a non existing file");
        }
        String shortpath = "";
        StringTokenizer tokenizer = new StringTokenizer(f.getAbsolutePath(), "\\");
        String temp = null;
        String nextTemp = null;
        while (tokenizer.hasMoreTokens()) {
            int counter = 1;
            temp = temp == null ? tokenizer.nextToken() : nextTemp;
            nextTemp = tokenizer.nextToken();
            String tempShortpath = null;
            do {
                tempShortpath = temp.length() > 8 ? temp.replaceAll(" ", "").substring(0, 6) + "~" + counter + "\\" : temp + "\\";
            } while (!new File(shortpath + tempShortpath + nextTemp).exists() && ++counter < 100);
            if (counter == 100) {
                throw new FileNotFoundException("Short path counter limit exceeded");
            }
            shortpath = shortpath + tempShortpath;
        }
        return shortpath + nextTemp;
    }

    static {
        lock = new Object();
    }
}

