/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.impl.CAIBSecurityManager;
import es.caib.signatura.impl.CertificateProvider;
import es.caib.signatura.impl.CertificateProviderException;
import es.caib.signatura.impl.ClassLoaderFactory;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;

public class CertificateProviderFactory {
    private static ClassLoaderFactory factory;

    public static CertificateProvider getCertificateProvider(String classname) throws CertificateProviderException {
        System.out.println("CertificateProviderFactory.getCertificateProvider()");
        CertificateProviderFactory.init();
        CertificateProvider p = null;
        try {
            p = (CertificateProvider)factory.getFactory().getMasterClassLoader().loadClass(classname).newInstance();
        }
        catch (Exception e) {
            throw new CertificateProviderException(e);
        }
        System.out.println("FIN CertificateProviderFactory.getCertificateProvider()");
        return p;
    }

    private static void init() {
        System.out.println("CertificateProviderFactory.init()");
        CAIBSecurityManager.register();
        try {
            InputStream inputStream;
            if (factory == null) {
                factory = ClassLoaderFactory.getFactory();
            }
            if (Security.getProvider("BC") == null) {
                ClassLoader c = factory.getFactory().getMasterClassLoader();
                Provider p = (Provider)factory.getFactory().getMasterClassLoader().loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
                Security.addProvider(p);
            }
            if ((inputStream = factory.getMasterClassLoader().getResourceAsStream("es/caib/signatura/provider/impl/lunaPCI/LunaPCISigner.class")) != null) {
                Provider p;
                ClassLoader c;
                if (Security.getProvider("LunaJCE") == null) {
                    c = factory.getFactory().getMasterClassLoader();
                    p = (Provider)factory.getFactory().getMasterClassLoader().loadClass("com.chrysalisits.cryptox.LunaJCEProvider").newInstance();
                    Security.addProvider(p);
                }
                if (Security.getProvider("LunaJCA") == null) {
                    c = factory.getFactory().getMasterClassLoader();
                    p = (Provider)factory.getFactory().getMasterClassLoader().loadClass("com.chrysalisits.crypto.LunaJCAProvider").newInstance();
                    Security.addProvider(p);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println("FIN CertificateProviderFactory.init()");
    }
}

