/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.api.SMIMEParser;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.api.SignatureException;
import es.caib.signatura.impl.ClassLoaderFactory;
import java.io.IOException;
import java.io.InputStream;

public class SMIMEParserProxy
implements SMIMEParser {
    SMIMEParser impl = null;
    SMIMEParser smimeFactory = null;

    public SMIMEParserProxy(InputStream smime) throws InstantiationException, IllegalAccessException, IOException, SignatureException {
        ClassLoaderFactory loaderFactory = ClassLoaderFactory.getFactory();
        try {
            this.smimeFactory = (SMIMEParser)loaderFactory.getMasterClassLoader().loadClass("es.caib.signatura.provider.impl.common.SMIMEImpl").newInstance();
            this.impl = this.smimeFactory.getInstance(smime);
        }
        catch (SignatureDataException e) {
            throw new SignatureException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new SignatureException(e.getMessage(), e);
        }
    }

    public SMIMEParser getInstance(InputStream smime) throws InstantiationException, IllegalAccessException, IOException, SignatureException {
        return new SMIMEParserProxy(smime);
    }

    public Signature[] getSignatures() {
        if (this.impl != null) {
            return this.impl.getSignatures();
        }
        return null;
    }

    public void parse(InputStream mimeIS) throws IOException, InstantiationException, IllegalAccessException, SignatureException {
        this.impl = this.smimeFactory.getInstance(mimeIS);
    }

    public Object getSignedObject() {
        if (this.impl != null) {
            return this.impl.getSignedObject();
        }
        return null;
    }
}

