/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.impl.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class SMIMEPkcs7InputStream
extends InputStream {
    private static final int CHUNK_SIZE = 48;
    private int status = 0;
    private static final int STATUS_IDLE = 0;
    private static final int STATUS_HEADER = 1;
    private static final int STATUS_BODY = 2;
    private static final int STATUS_END = 3;
    int bufferOffset = 0;
    byte[] buffer = null;
    byte[] signatureData;
    int signatureDataOffset;

    public SMIMEPkcs7InputStream(byte[] pkcs7) {
        this.signatureData = pkcs7;
        this.signatureDataOffset = 0;
    }

    public synchronized void close() throws IOException {
        this.status = 3;
    }

    public synchronized int read() throws IOException {
        while (true) {
            if (this.buffer != null && this.bufferOffset < this.buffer.length) {
                byte b = this.buffer[this.bufferOffset++];
                return b;
            }
            if (this.status == 3) {
                return -1;
            }
            this.fetchData();
        }
    }

    public synchronized int read(byte[] targetBuffer, int offset, int length) throws IOException {
        while (true) {
            if (this.buffer != null && this.bufferOffset < this.buffer.length) {
                int actualLength = this.buffer.length - this.bufferOffset;
                if (actualLength > length) {
                    actualLength = length;
                }
                System.arraycopy(this.buffer, this.bufferOffset, targetBuffer, offset, actualLength);
                this.bufferOffset += actualLength;
                return actualLength;
            }
            if (this.status == 3) {
                return -1;
            }
            this.fetchData();
        }
    }

    public synchronized int available() throws IOException {
        while (this.buffer == null || this.bufferOffset >= this.buffer.length) {
            if (this.status == 3) {
                return -1;
            }
            this.fetchData();
        }
        return this.buffer.length - this.bufferOffset;
    }

    private void fetchData() throws IOException {
        switch (this.status) {
            case 0: {
                this.buffer = this.fetchIdle();
                break;
            }
            case 1: {
                this.buffer = this.fetchHeader();
                break;
            }
            case 2: {
                this.buffer = this.fetchSignatureBody();
                break;
            }
            default: {
                this.buffer = null;
            }
        }
        this.bufferOffset = 0;
    }

    private byte[] fetchSignatureBody() {
        int len = this.signatureData.length - this.signatureDataOffset;
        if (len <= 0) {
            this.status = 3;
            return null;
        }
        if (len > 48) {
            len = 48;
        }
        byte[] result = Base64.toBase64(this.signatureData, this.signatureDataOffset, len);
        this.signatureDataOffset += len;
        return result;
    }

    private byte[] fetchHeader() {
        try {
            this.status = 2;
            return "Content-Type: application/pkcs7-mime; smime-type=signed-data; name=smime.p7m;\r\nContent-Transfer-Encoding: base64\r\nContent-Disposition: attachment; filename=\"smime.p7m\"\r\nContent-Description: S/MIME Cryptographic Signature\r\n\r\n".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] fetchIdle() {
        this.status = 1;
        return null;
    }

    public synchronized long skip(long n) throws IOException {
        for (long i = 0L; i < n; ++i) {
            if (this.read() >= 0) continue;
            return i;
        }
        return n;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Base64InputStream does not support mark/reset");
    }

    public boolean markSupported() {
        return false;
    }
}

