/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl;

import es.caib.signatura.api.SignatureSignException;
import es.caib.signatura.impl.ValidadorProxy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class SignaturaProperties {
    private String configurationFile = null;
    private String propertiesCache = null;
    private Properties properties;
    private String updateSite;

    public SignaturaProperties() throws FileNotFoundException, IOException {
        this("http://www.caib.es/signaturacaib/", new URL("http://www.caib.es/signaturacaib/signatura_api.properties"), "signatura_api.properties");
    }

    public SignaturaProperties(Map signerConfiguration) throws FileNotFoundException, IOException {
        if (signerConfiguration == null) {
            throw new IOException("Signature properties cannot be null");
        }
        this.getUserProperties(signerConfiguration);
    }

    public SignaturaProperties(String updateSite, URL configurationFile, String propertiesCachePath) {
        this.configurationFile = configurationFile.toString();
        this.updateSite = updateSite;
        this.propertiesCache = propertiesCachePath;
        this.getCacheProperties();
        this.getWWWProperties();
    }

    public void getCacheProperties() {
        try {
            File f = this.getCacheFile();
            Properties tempProperties = new Properties();
            tempProperties.load(new FileInputStream(f));
            this.updateProperties(tempProperties);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File getCacheFile() {
        File f = new File(System.getProperty("user.home") + "/.signaturacaib/" + this.propertiesCache);
        return f;
    }

    private boolean updateProperties(Properties tempProperties) {
        if (this.properties == null) {
            this.properties = tempProperties;
            return true;
        }
        try {
            Integer currentVersion = Integer.decode(this.properties.getProperty("build.number"));
            Integer newVersion = Integer.decode(tempProperties.getProperty("build.number"));
            if (newVersion.longValue() > currentVersion.longValue()) {
                this.properties = tempProperties;
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void getWWWProperties() {
        try {
            if (this.updateSite != null) {
                URL url = new URL(this.configurationFile);
                Properties tempProperties = new Properties();
                tempProperties.load(url.openStream());
                if (this.updateProperties(tempProperties)) {
                    try {
                        File f = this.getCacheFile();
                        if (!f.getParentFile().isDirectory()) {
                            f.getParentFile().mkdirs();
                        }
                        tempProperties.store(new FileOutputStream(f), "Descargado en fecha " + new Date());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getUserProperties(Map userProperties) throws IOException {
        this.properties = (Properties)userProperties;
    }

    protected String getProperty(String name) {
        int i;
        String value = this.properties.getProperty(name);
        if (value == null && (i = name.indexOf(59)) > 0) {
            value = this.properties.getProperty(name.substring(0, i));
        }
        if (value == null) {
            value = this.properties.getProperty("altres");
        }
        return value;
    }

    public boolean needsRecognizedCertificate(String contentType) {
        boolean DEFAULT_VALUE = true;
        String propertieValue = this.getProperty(contentType);
        if (propertieValue == null) {
            return DEFAULT_VALUE;
        }
        String[] signType = propertieValue.split(",");
        if (signType == null || signType.length < 2) {
            return DEFAULT_VALUE;
        }
        return signType[1].equalsIgnoreCase("CR");
    }

    public boolean needsTimeStamp(String contentType) {
        boolean DEFAULT_VALUE = false;
        String propertieValue = this.getProperty(contentType);
        if (propertieValue == null) {
            return DEFAULT_VALUE;
        }
        String[] signType = propertieValue.split(",");
        if (signType == null || signType.length < 2) {
            return DEFAULT_VALUE;
        }
        return signType[0].equalsIgnoreCase("SAST");
    }

    public boolean needsRawSignature(String contentType) {
        String propertieValue = this.getProperty(contentType);
        if (propertieValue == null) {
            return false;
        }
        String[] signType = propertieValue.split(",");
        if (signType == null || signType.length < 3) {
            return false;
        }
        return signType[2].equalsIgnoreCase("RAW");
    }

    public boolean needsAdvancedSignature(String contentType) throws SignatureSignException {
        return true;
    }

    public boolean enDesenvolupament() {
        try {
            return new ValidadorProxy().isEnDesenvolupament();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public String getTimestampService(String principalName) {
        return this.properties.getProperty("ts." + principalName);
    }

    public String getTimestampServiceApplicationId(String principalName) {
        return this.properties.getProperty("ts.applicationId." + principalName);
    }

    public String getTimestampServicePolicyOID(String name) {
        return this.properties.getProperty("ts.policyOID." + name);
    }

    private String[] getMultiProperty(String name) {
        int i = 1;
        Vector<String> v = new Vector<String>();
        while (this.properties.getProperty(name + "." + i) != null) {
            v.add(this.properties.getProperty(name + "." + i));
            ++i;
        }
        return v.toArray(new String[v.size()]);
    }

    public String[] getRecognizedPolicies() {
        return this.getMultiProperty("policy.recognized");
    }

    public String[] getRecognizedSecureDevicePolicies() {
        return this.getMultiProperty("policy.recognizedsecuredevice");
    }

    public String[] getAdvancedPolicies() {
        return this.getMultiProperty("policy.advanced");
    }

    public String[] getRecognizedExtensions() {
        return this.getMultiProperty("extension.recognized");
    }

    public String[] getAmbigousPoliciess() {
        return this.getMultiProperty("policy.ambigous");
    }

    public String[] getRootCAs() {
        return this.getMultiProperty("ca");
    }

    public String[] getPKCS11Drivers() {
        return this.getMultiProperty("pkcs11");
    }

    public String getCertificateParser(String id) {
        return this.properties.getProperty(id);
    }

    public String getPKCS11DriversDescription(String library) {
        String[] providersDescs = this.getMultiProperty("pkcs11");
        int i = 0;
        for (i = 0; i < providersDescs.length; ++i) {
            if (!providersDescs[i].contains(library)) continue;
            return this.getMultiProperty("pkcs11.description")[i];
        }
        return null;
    }

    public void getUpdateSite() throws FileNotFoundException, IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("version.properties");
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        Properties tempProperties = new Properties();
        tempProperties.load(inputStream);
        inputStream.close();
        this.updateSite = tempProperties.getProperty("updateSite");
        this.configurationFile = tempProperties.getProperty("configurationFile");
        this.propertiesCache = tempProperties.getProperty("propertiesCache");
    }

    public String[] getPublicEmployeeOID() {
        String[] props = this.getMultiProperty("policy.publicemployeeOID");
        if (props.length == 0 && this.properties.getProperty("policy.publicemployeeOID") != null) {
            return new String[]{this.properties.getProperty("policy.publicemployeeOID")};
        }
        return props;
    }

    public String getPublicEmployeeParser() {
        return this.properties.getProperty("certificateparser.funcionari", "es.caib.signatura.provider.impl.common.FuncionariParsedCertificateImpl");
    }
}

