/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.impl.ui;

import es.caib.signatura.impl.SigDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class FirefoxSignerProfileChooser
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JDesktopPane jDesktopPane = null;
    private JCheckBox jCheckBox = null;
    private JLabel jLabel = null;
    private JComboBox jComboBox = null;
    private JLabel jLabel1 = null;
    private JButton jButton = null;
    public static final String FIREFOX_PROPERTIES = System.getProperty("user.home") + "/.signaturacaib/firefox.properties";

    public FirefoxSignerProfileChooser() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 175);
        this.setTitle("Seleccionar perfil de Firefox");
        this.setModal(true);
        this.setPreferredSize(new Dimension(300, 175));
        this.setContentPane(this.getJDesktopPane());
        this.centerWindow();
        this.toFront();
    }

    private void centerWindow() {
        Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        Point center = new Point((int)screen.getCenterX(), (int)screen.getCenterY());
        Point newLocation = new Point(center.x - this.getWidth() / 2, center.y - this.getHeight() / 2);
        if (screen.contains(newLocation.x, newLocation.y, this.getWidth(), this.getHeight())) {
            this.setLocation(newLocation);
        }
    }

    private JDesktopPane getJDesktopPane() {
        if (this.jDesktopPane == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(new Rectangle(174, 62, 90, 16));
            this.jLabel1.setText("Recordar opci\u00f3n");
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(7, 8, 280, 16));
            this.jLabel.setText("Perfil de Firefox para buscar certificados:");
            this.jDesktopPane = new JDesktopPane();
            this.jDesktopPane.add((Component)this.getJCheckBox(), null);
            this.jDesktopPane.add((Component)this.jLabel, null);
            this.jDesktopPane.add((Component)this.getJComboBox(), null);
            this.jDesktopPane.add((Component)this.jLabel1, null);
            this.jDesktopPane.add((Component)this.getJButton(), null);
        }
        return this.jDesktopPane;
    }

    private JCheckBox getJCheckBox() {
        if (this.jCheckBox == null) {
            this.jCheckBox = new JCheckBox();
            this.jCheckBox.setBounds(new Rectangle(265, 61, 21, 21));
            this.jCheckBox.addActionListener(this);
        }
        return this.jCheckBox;
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setBounds(new Rectangle(6, 29, 280, 25));
            this.jComboBox.addActionListener(this);
        }
        return this.jComboBox;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setBounds(new Rectangle(103, 102, 97, 35));
            this.jButton.setText("Aceptar");
            this.jButton.addActionListener(this);
        }
        return this.jButton;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.jButton)) {
            if (e.getID() == 1001) {
                this.dispose();
            }
        } else if (e.getSource().equals(this.jComboBox) ? e.getID() == 1001 : !e.getSource().equals(this.jCheckBox) || e.getID() == 1001) {
            // empty if block
        }
    }

    public int getComboValue(File firefoxPropsFile) throws Exception {
        SigDebug.write("START getComboValue");
        if (this.jCheckBox.isSelected()) {
            SigDebug.write("START getComboValue CHECK SELECTED");
            Properties props = new Properties();
            props.setProperty("firefox.chosenprofile", (String)this.jComboBox.getSelectedItem());
            props.store(new FileOutputStream(firefoxPropsFile), "Archivo de propiedades para el signer de Firefox");
        }
        SigDebug.write("END getComboValue");
        return this.jComboBox.getSelectedIndex();
    }

    public void fillItemList(File[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.jComboBox.addItem(items[i].getName().substring(9));
        }
    }

    public static int getFirefoxProfile(File[] profiles) throws Exception {
        FirefoxSignerProfileChooser p = new FirefoxSignerProfileChooser();
        File firefoxPropsFile = new File(FIREFOX_PROPERTIES);
        if (firefoxPropsFile.exists()) {
            SigDebug.write("Existe " + firefoxPropsFile.getAbsolutePath());
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(firefoxPropsFile));
                String value = props.getProperty("firefox.chosenprofile");
                if (value == null || "".equals(value)) {
                    throw new Exception("Clave 'firefox.chosenprofile' nula o vac\u00eda en el archivo firefox.properties");
                }
                for (int i = 0; i < profiles.length; ++i) {
                    if (!value.equals(profiles[i].getName().substring(9))) continue;
                    return i;
                }
                throw new Exception("El perfil guardado en el archivo " + FIREFOX_PROPERTIES + " no coincide con " + "ninguno de los que se ofrecen como candidatos. Se sugiere borrar este " + "archivo e intentarlo de nuevo.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        p.fillItemList(profiles);
        p.setVisible(true);
        return p.getComboValue(firefoxPropsFile);
    }
}

