/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.tradise;

import es.caib.signatura.api.ParsedCertificate;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.impl.ClassLoaderFactory;
import es.caib.signatura.impl.SignatureProviderInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;

public class TradiseSignature
implements Signature,
Serializable {
    protected byte[] signatureBytes = null;
    private static final long serialVersionUID = 1L;
    private String contentType = null;
    private static final String CLASS_LOADER = "tradise";
    private transient SignatureProviderInterface impl = null;

    public TradiseSignature(byte[] pkcs7, String contentType) throws SignatureDataException {
        this.signatureBytes = pkcs7;
        this.contentType = contentType;
        try {
            this.init();
        }
        catch (IOException e) {
            throw new SignatureDataException(e);
        }
    }

    public TradiseSignature(SignatureProviderInterface impl) {
        this.impl = impl;
        this.signatureBytes = impl.getPkcs7();
        this.contentType = impl.getContentType();
    }

    protected String getClassLoaderName() {
        return CLASS_LOADER;
    }

    protected String getImplClassName() {
        return "es.caib.signatura.provider.impl.tradise.TradiseSignatureImpl";
    }

    private void init() throws IOException {
        if (this.impl == null) {
            try {
                ClassLoader cl = ClassLoaderFactory.getFactory().getClassLoader(this.getClassLoaderName());
                Class<?> clazz = cl.loadClass(this.getImplClassName());
                this.impl = (SignatureProviderInterface)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.impl.setContentType(this.contentType);
            this.impl.setSignedData(this.signatureBytes);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse signature");
        }
    }

    public String getCertCaName() {
        return this.impl.getCertCaName();
    }

    public String getCertSubjectCommonName() {
        return this.impl.getCertSubjectCommonName();
    }

    public String getCertSubjectAlternativeNames() {
        return this.impl.getCertSubjectAlternativeNames();
    }

    public byte[] getPkcs7() {
        return this.signatureBytes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public Date getDate() throws SignatureTimestampException {
        return this.impl.getDate();
    }

    public boolean verify() throws SignatureVerifyException {
        return this.impl.verify();
    }

    public String getContentType() {
        return this.contentType;
    }

    public X509Certificate getCert() {
        return this.impl.getCert();
    }

    public X509Certificate[] getCertificateChain() throws Exception {
        return this.impl.getCertificateChain();
    }

    public ParsedCertificate getParsedCertificate() {
        return this.impl.getParsedCertificate();
    }

    public boolean verifyAPosterioriTimestamp(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        return this.verify(contentStream);
    }

    public boolean verify(InputStream contentStream) throws SignatureProviderException, IOException, SignatureVerifyException {
        return this.impl.verify(contentStream);
    }
}

