/**
 * 
 */
package es.caib.signatura.provider.impl.firefox;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

import javax.security.auth.login.LoginException;
import javax.swing.JOptionPane;

import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.tsp.TSPException;

import sun.security.pkcs11.SunPKCS11;

import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureCertNotFoundException;
import es.caib.signatura.api.SignatureException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.impl.CMSSignatureRawv2;
import es.caib.signatura.impl.CMSSignaturev2;
import es.caib.signatura.impl.MIMEInputStream;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.provider.impl.common.AbstractSigner;
import es.caib.signatura.provider.impl.common.PDFSigner;
import es.caib.signatura.provider.impl.common.ParsedCertificateImpl;
import es.caib.signatura.provider.impl.common.TimeStampManager;



/**
 * @author e43155798r y u91940
 *
 */
public class FirefoxSigner extends AbstractSigner {
	
	private static String configFile = null;
	private static FirefoxSigner actuallyUsedBy=null;
	private static SunPKCS11 provider = null;
	
	/** contraseña maestra **/
	private char pin[];
	
	/**si ha iniciado sesión anteriormente. Estático porque de momento sólo puede haber un provider a la vez**/
	private static boolean passwordInitialized=false;
	private boolean ignoreProvider=false;
		
	

	public FirefoxSigner(String cfgFile, String providerDesc) throws SignatureException {
		
		super(); // llamada a initialize(), por constructor de AbstractSigner
		if(configFile==null)
			configFile = cfgFile;
				
		// El nombre del provider será FIREFOXSIGNER profile + Ruta al perfil de Firefox que cargamos.
		setProviderName("FIREFOX " + providerDesc);

		//recordem qui l'està utilitzant per a poder tancar la sessió
		setActuallyUsedBy(this);
		
	}

	/* (non-Javadoc)
	 * @see es.caib.signatura.provider.impl.common.AbstractSigner#certifyDigitalCopy(java.io.InputStream, java.io.OutputStream, java.lang.String, java.lang.String, java.lang.String, boolean, java.lang.String, java.lang.String, float, float, float)
	 */
	public void certifyDigitalCopy(InputStream contentStream,
			OutputStream signedStream, String certificateName, String password,
			String contentType, boolean recognized, String url,
			String localidad, float x, float y, float rotation, SignaturaProperties properties)
			throws IOException, SignatureException {
		
		ParsedCertificateImpl parsed = null;
		
		try {
						
			KeyStore ks = getKeyStore();
			
			String alias = getAliasFromCN(certificateName, recognized);
			X509Certificate certs[] = getCertChainFromAlias(alias);
			
			PrivateKey privateKey;
			try {
				
				privateKey = (PrivateKey)ks.getKey(alias, password.toCharArray());
				if (privateKey == null)
					throw new SignatureException("Private key not found for alias " + alias);
				
				PDFSigner.certifyDigitalCopy(contentStream, signedStream, privateKey, certs, url, localidad, x, y, rotation,properties, provider.getName());
				return;
				
			} catch (UnrecoverableKeyException e) {
			
				e.printStackTrace();
				throw new SignatureException("Clave incorrecta", e);
			
			} catch (Exception e) {
				
				e.printStackTrace();
				throw new SignatureException("Error generando firma", e);
				
			}
		
		} catch (IOException e) {
			
			e.printStackTrace();
			throw e;
			
		} catch (CertificateEncodingException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException((parsed != null) ? parsed
					.getCommonName()
					+ ":[FIREFOXSIGNER]: " + e.getMessage() : e.getMessage(), e);
			
		} catch (CertificateException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		} catch (KeyStoreException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		} catch (NoSuchAlgorithmException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		}

	}

	/* (non-Javadoc)
	 * @see es.caib.signatura.provider.impl.common.AbstractSigner#getCurrentDate(java.lang.String, java.lang.String, boolean)
	 */
	public Date getCurrentDate(String certificateName, String password,
			boolean recognized) throws SignatureTimestampException,
			SignatureException, IOException {
		
		TimeStampManager tsm = new TimeStampManager();
		
		try {
						
			String alias = getAliasFromCN(certificateName, recognized);
			X509Certificate certs[] = getCertChainFromAlias(alias);
			
			return tsm.getTimeStamp(certs[0]);
			
		} catch (IOException e) {
			
			e.printStackTrace();
			throw new SignatureException(e.getMessage(), e.getCause());
			
		} catch (TSPException e) {
			
			e.printStackTrace();
			throw new SignatureException(e.getMessage(), e.getCause());
			
		} 
		
	}

	/* (non-Javadoc)
	 * @see es.caib.signatura.provider.impl.common.AbstractSigner#getVersion()
	 */
	public String getVersion() {
		
		return "1.0";
		
	}
	
	

	/* (non-Javadoc)
	 * @see es.caib.signatura.provider.impl.common.AbstractSigner#sign(java.io.InputStream, java.lang.String, java.lang.String, java.lang.String, boolean, boolean, boolean)
	 */
	public Signature sign(InputStream contentStream, String certificateName,
			String password, String contentType, boolean recognized,
			boolean timeStamp, boolean rawSign) throws IOException,
			SignatureException {
		
		ParsedCertificateImpl parsed = null;
		try {
			
			KeyStore ks = getKeyStore();
			
			String alias = getAliasFromCN(certificateName, recognized);
			X509Certificate certs[] = getCertChainFromAlias(alias);
			
			PrivateKey privateKey;
			try {
				
				privateKey = (PrivateKey)ks.getKey(alias, null);
				if (privateKey == null)
					throw new SignatureException("Private key not found for alias " + alias);
				
				return generate(privateKey, certs, contentType, contentStream, timeStamp, rawSign);
				
			} catch (UnrecoverableKeyException e) {
			
				e.printStackTrace();
				throw new SignatureException("Clave incorrecta", e);
			
			} catch (Exception e) {
				
				e.printStackTrace();
				throw new SignatureException("Error generando firma", e);
				
			}
						
		} catch (IOException e) {
			
			e.printStackTrace();
			throw e;
			
		} catch (CertificateEncodingException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException((parsed != null) ? parsed
					.getCommonName()
					+ ":[FIREFOXSIGNER]: " + e.getMessage() : e.getMessage(), e);
			
		} catch (CertificateException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		} catch (KeyStoreException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		} catch (NoSuchAlgorithmException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		}
		
	}

	/* (non-Javadoc)
	 * @see es.caib.signatura.provider.impl.common.AbstractSigner#signPDF(java.io.InputStream, java.io.OutputStream, java.lang.String, java.lang.String, java.lang.String, boolean, java.lang.String, int, boolean)
	 */
	public void signPDF(InputStream contentStream, OutputStream signedStream,
			String certificateName, String password, String contentType,
			boolean recognized, String url, int position,
			boolean allowMultipleSignature) throws IOException,
			SignatureException {
		
		ParsedCertificateImpl parsed = null;
		try {
			
			KeyStore ks = getKeyStore();
			
			String alias = getAliasFromCN(certificateName, recognized);
			X509Certificate certs[] = getCertChainFromAlias(alias);
			
			PrivateKey privateKey;
			try {
				
				privateKey = (PrivateKey)ks.getKey(alias, null);
				if (privateKey == null)
					throw new SignatureException("Private key not found for alias " + alias);
				
				PDFSigner.sign(contentStream, signedStream, privateKey, certs, url, position, allowMultipleSignature, provider.getName());
				return;
				
			} catch (UnrecoverableKeyException e) {
			
				e.printStackTrace();
				throw new SignatureException("Clave incorrecta", e);
			
			} catch (Exception e) {
				
				e.printStackTrace();
				throw new SignatureException("Error generando firma", e);
				
			}
			
		} catch (IOException e) {
			
			e.printStackTrace();
			throw e;
			
		} catch (CertificateEncodingException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException((parsed != null) ? parsed
					.getCommonName()
					+ ":[FIREFOXSIGNER]: " + e.getMessage() : e.getMessage(), e);
			
		} catch (CertificateException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		} catch (KeyStoreException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		} catch (NoSuchAlgorithmException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		}

	}
	
	public void signPDF(InputStream pdfInputStream, OutputStream signedStream, String certificateName, String password, String contentType, boolean recognized, String textoAdicional, int stampOptions, float top, float left, float height, float width, float rotation, boolean allowMultipleSignature) throws IOException, SignatureException {
		ParsedCertificateImpl parsed = null;
		try {
			
			KeyStore ks = getKeyStore();
			
			String alias = getAliasFromCN(certificateName, recognized);
			X509Certificate certs[] = getCertChainFromAlias(alias);
			
			PrivateKey privateKey;
			try {
				
				privateKey = (PrivateKey)ks.getKey(alias, null);
				if (privateKey == null)
					throw new SignatureException("Private key not found for alias " + alias);
				
				PDFSigner.sign(pdfInputStream, signedStream, privateKey, certs, textoAdicional, stampOptions, top, left, height, width, rotation, allowMultipleSignature, provider.getName());
				return;
				
			} catch (UnrecoverableKeyException e) {
			
				e.printStackTrace();
				throw new SignatureException("Clave incorrecta", e);
			
			} catch (Exception e) {
				
				e.printStackTrace();
				throw new SignatureException("Error generando firma", e);
				
			}
			
		} catch (IOException e) {
			
			e.printStackTrace();
			throw e;
			
		} catch (CertificateEncodingException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException((parsed != null) ? parsed
					.getCommonName()
					+ ":[FIREFOXSIGNER]: " + e.getMessage() : e.getMessage(), e);
			
		} catch (CertificateException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		} catch (KeyStoreException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		} catch (NoSuchAlgorithmException e) {
			
			e.printStackTrace();
			throw new SignatureCertNotFoundException(e);
			
		}		
	}
	
	/* (non-Javadoc)
	 * @see es.caib.signatura.provider.impl.common.AbstractSigner#getAliases()
	 */
	protected String[] getAliases() throws SignatureProviderException {
		
		Enumeration enumeration=null;
		KeyStore ks;
		
		try {
			
			ks = getKeyStore();
			if(ks!=null)
				enumeration = ks.aliases();
			
		} catch (KeyStoreException e) {
			
			e.printStackTrace();
			throw new SignatureProviderException(e.getMessage(), e.getCause());
			
		} catch (NoSuchAlgorithmException e) {
			
			e.printStackTrace();
			throw new SignatureProviderException(e.getMessage(), e.getCause());
			
		} catch (CertificateException e) {
		
			e.printStackTrace();
			throw new SignatureProviderException(e.getMessage(), e.getCause());
			
		} catch (IOException e) {

			e.printStackTrace();
			throw new SignatureProviderException(e.getMessage(), e.getCause());
			
		}
		
		Vector out = new Vector();
		
		while (enumeration!=null && enumeration.hasMoreElements()) {
			
			String alias = (String)enumeration.nextElement();
			out.add(alias);
			
		}
		
		return (String[])out.toArray(new String[out.size()]);
		
	}

	/* (non-Javadoc)
	 * @see es.caib.signatura.provider.impl.common.AbstractSigner#getCertChainFromAlias(java.lang.String)
	 */
	protected X509Certificate[] getCertChainFromAlias(String alias)
			throws SignatureProviderException {
		
		X509Certificate certs[] = null;
		KeyStore ks;
					
		try {
			
			ks = getKeyStore();
			if(ks!=null)
				certs = (X509Certificate[])ks.getCertificateChain(alias);
			
			
		} catch (KeyStoreException e) {

			e.printStackTrace();
			throw new SignatureProviderException(e.getMessage(), e.getCause());
			
		} catch (NoSuchAlgorithmException e) {

			e.printStackTrace();
			throw new SignatureProviderException(e.getMessage(), e.getCause());
			
		} catch (CertificateException e) {

			e.printStackTrace();
			throw new SignatureProviderException(e.getMessage(), e.getCause());
			
		} catch (IOException e) {

			e.printStackTrace();
			throw new SignatureProviderException(e.getMessage(), e.getCause());
			
		}
		
		return certs;
		
	}

	/* (non-Javadoc)
	 * @see es.caib.signatura.provider.impl.common.AbstractSigner#initialize()
	 */
	protected void initialize() throws SignatureProviderException {
		
	}
	
	/* (non-Javadoc)
	 * @see es.caib.signatura.provider.impl.common.AbstractSigner#isInSecureDevice(java.lang.String)
	 */
	protected boolean isInSecureDevice(String alias) {
	
		return passwordInitialized;

	}
	
	private SunPKCS11 getProvider()
	{
		if (provider == null) { 
			
			ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(configFile.getBytes());
			provider = new SunPKCS11(localByteArrayInputStream);
			Security.addProvider(provider);
		
		}
		
		return provider;
	}
	
	private KeyStore getKeyStore()
		throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException
	{
		
		KeyStore ks = null;
		if(!ignoreProvider){
			if (pin == null) {
				try {
					
					ks= getKeyStore(null);
					if(!passwordInitialized) System.out.println("No password provided to load keystore "+providerName);
					return ks;
					
				} catch (IOException e) {
					
					if (e.getCause() instanceof LoginException)
						return askForPin();
					else
						throw e;
					
				} catch (KeyStoreException e) {
					
					if (e.getCause() instanceof LoginException)
						return askForPin();
					else{
						disposeProvider();
						throw e;
					}
					
				}
				
			} else {
				
				try {
					
					return getKeyStore (pin);
					
				} catch (KeyStoreException e) {
					
					disposeProvider();
					
					try {
						
						Thread.sleep(5000);
						
					} catch (InterruptedException e1) {
					}
					
					return getKeyStore();
					
				}
				
			}
		}else{
			return null;
		}
		
	}
	
	private KeyStore getKeyStore(char pinToUse[])
	throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException
	{
		
		KeyStore ks = null;
		
		try {
			
			ks = KeyStore.getInstance("PKCS11", getProvider());
			ks.load(null, pinToUse);
			
		} catch (ProviderException e) { // Token has been removed
			
			throw new KeyStoreException("Unable to get KeyStore: "+providerName , e);
			
		}
		
		return ks;
		
	}
	
	private KeyStore askForPin()
	throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException
	{
	
		//el titol de la finestra és el nom del perfil, que comença a l'ultim punt del nom del provider.
		char newPin[] = PinDialog.getPIN(this.providerName.substring(this.providerName.lastIndexOf(".")+1));
		
		if(newPin==null) ignoreProvider=true;
		
		try {
			
			KeyStore ks = getKeyStore(newPin);
			pin = newPin;
			passwordInitialized=true;
			return ks;
			
		} catch (IOException e2) {
			
			//e2.printStackTrace();
			
			if (e2.getCause() instanceof LoginException) {
				
					JOptionPane.showMessageDialog(null, "PIN incorrecto para el perfil de FIREFOX", "Perfil de Firefox "+providerName, JOptionPane.WARNING_MESSAGE);
			
			}
			
			throw e2;
			
		}
	
	}

	protected void finalize () {
		
		closeSession();
		
	}
	
	private void disposeProvider()
	{
		if(getActuallyUsedBy()==this){
			pin = null;
			closeSession();
		}
	}

	private void closeSession()
	{
		
		
		if(getActuallyUsedBy()==this){
			try {
				if (provider != null){
					provider.logout();
					passwordInitialized=false;
					configFile=null;
					provider=null;
					setActuallyUsedBy(null);
				}
			} catch (LoginException e) {
				e.printStackTrace();
			} catch (Throwable e) {
				e.printStackTrace();
			}
		}
	}
	/**
	 * Devuelve una tabla con los atributos firmados
	 * (por ahora sólo el Signing Certificate)
	 * @param cert Certificado X509 del cual obtendremos la información
	 */
	private AttributeTable getSignedAttributes(X509Certificate cert)
			throws Exception {
		
		try {
			// Obtenemos la forma codificada del certificado.
			// Al ser X.509 se obtendrá en ASN.1 DER
			byte encodedCert[] = cert.getEncoded();

			// Calculamos el hash del certificado
			ByteArrayInputStream baInputStream = new ByteArrayInputStream(
					encodedCert);
			MessageDigest digester = MessageDigest.getInstance("SHA-1", "BC");
			DigestInputStream diInputStream = new DigestInputStream(
					baInputStream, digester);

			byte digestResult[] = null;
			byte b[] = new byte[8192];

			for (int read = diInputStream.read(b); read > 0; read = diInputStream.read(b))
				;

			diInputStream.close();
			baInputStream.close();
			digestResult = digester.digest();

			// Obtenemos el campo GeneralNames, a partir de un GeneralName
			// (necesario para el IssuerSerial)
			// Obtenemos el número de serie del certificado (necesario para
			// ESSCertID)
			// Obtenemos el IssuerSerial (necesario para ESSCertID)
			// Obtenemos el ESSCertID (necesario para SigningCertificate)
			// obtenemos el SigningCertificate
			GeneralName generalName = new GeneralName(new X509Name(cert.getIssuerX500Principal().getName()));
			GeneralNames generalNames = new GeneralNames(generalName);
			BigInteger serialNumber = cert.getSerialNumber();
			IssuerSerial issuerSerial = new IssuerSerial(generalNames, new DERInteger(serialNumber.intValue()));
			ESSCertID essCertID = new ESSCertID(digestResult, issuerSerial);
			SigningCertificate signingCertificate = new SigningCertificate(essCertID);

			// Creamos una Hashtable para introducir el nuevo valor
			// en los atributos firmados
			Hashtable table = new Hashtable();

			Attribute att = new Attribute(new DERObjectIdentifier(
					"1.2.840.113549.1.9.16.2.12"), new DERSet(
					signingCertificate));

			table.put("signingCertificate", att);

			return new AttributeTable(table);
			
		} catch (Exception e) {
			
			e.printStackTrace();
			throw e;
		
		}
	
	}
	
	/**
	 * Devuelve una tabla con los atributos no firmados
	 * @param cert Certificado X509 del cual obtendremos la información
	 */
	private AttributeTable getUnsignedAttributes(X509Certificate cert) {		
		
		return new AttributeTable(new Hashtable());
				
	}
 
	/**
	 * Genera CMS
	 * @param key
	 * @param certs
	 * @param contentType
	 * @param stream
	 * @param timeStamp
	 * @param raw
	 * @return
	 * @throws Exception
	 */
	private Signature generate(PrivateKey key, X509Certificate certs[], String contentType, InputStream stream,
			boolean timeStamp, boolean raw) throws Exception 
	{
		try {
			
			CMSSignedDataGenerator gen = new CMSSignedDataGenerator();

			// Obtenemos los atributos firmados y sin firmar, para añadirlos al
			// método addSigner()
			AttributeTable signedAttributes = getSignedAttributes(certs[0]);
			AttributeTable unsignedAttributes = getUnsignedAttributes(certs[0]);

			// Añadimos el Signer que utilizaremos en la firma
			gen.addSigner(key, certs[0], CMSSignedDataGenerator.DIGEST_SHA1,
					signedAttributes, unsignedAttributes);

			Vector v = new Vector();
			for (int i = 0; i < certs.length; i++) {
				v.add(certs[i]);
			}
			
			CollectionCertStoreParameters param = new CollectionCertStoreParameters(v);
			CertStore certStore = CertStore.getInstance("Collection", param);

			gen.addCertificatesAndCRLs(certStore);
			ProcessableInputStream in;
			
			if (raw) {
				in = new ProcessableInputStream(stream);
			} else {
				in = new ProcessableInputStream(new MIMEInputStream(stream, contentType));
			}

			CMSSignedData signedData = gen.generate(in, getProvider().getName());
			
			if (timeStamp) {
				
				TimeStampManager tsm = new TimeStampManager();
				CMSSignedData signedDataTimestamp = tsm.addTimestamp(certs[0], signedData);
				
				if (signedDataTimestamp != null) {
					signedData = signedDataTimestamp;
				}
				
			}
			
			if (raw) {
				return new CMSSignatureRawv2(signedData.getEncoded(), contentType);
			} else {
				return new CMSSignaturev2(signedData.getEncoded(), contentType);
			}
			
		} catch (Exception e) {
			
			e.printStackTrace();
			throw e;
			
		}
		
	}
	
	class ProcessableInputStream implements CMSProcessable {
		private DigestInputStream in;
		MessageDigest digester;
		byte digestResult[];

		public void write(OutputStream out) throws IOException, CMSException {
			byte b[] = new byte[8192];
			int read = in.read(b);
			while (read > 0) {
				out.write(b, 0, read);
				read = in.read(b);
			}
			out.close();
			in.close();
			digestResult = digester.digest();
		}

		public Object getContent() {
			return in;
		}

		public ProcessableInputStream(InputStream datain)
				throws NoSuchAlgorithmException, NoSuchProviderException {
			super();
			digester = MessageDigest.getInstance("SHA-1", "BC");
			in = new DigestInputStream(datain, digester);
			digestResult = null;
		}

		public byte[] getDigest() {
			return digestResult;
		}

	}

	/**
	 * @return the actuallyUsedBy
	 */
	protected static synchronized FirefoxSigner getActuallyUsedBy() {
		return actuallyUsedBy;
	}

	/**
	 * @param actuallyUsedBy the actuallyUsedBy to set
	 */
	protected static synchronized void setActuallyUsedBy(FirefoxSigner actuallyUsedBy) {
		FirefoxSigner.actuallyUsedBy = actuallyUsedBy;
	}


	

}
