/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.firefox;

import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureCertNotFoundException;
import es.caib.signatura.api.SignatureException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureTimestampException;
import es.caib.signatura.impl.CMSSignatureRawv2;
import es.caib.signatura.impl.CMSSignaturev2;
import es.caib.signatura.impl.MIMEInputStream;
import es.caib.signatura.impl.SignaturaProperties;
import es.caib.signatura.provider.impl.common.AbstractSigner;
import es.caib.signatura.provider.impl.common.PDFSigner;
import es.caib.signatura.provider.impl.common.TimeStampManager;
import es.caib.signatura.provider.impl.firefox.PinDialog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.security.auth.login.LoginException;
import javax.swing.JOptionPane;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.tsp.TSPException;
import sun.security.pkcs11.SunPKCS11;

public class FirefoxSigner
extends AbstractSigner {
    private static String configFile = null;
    private static FirefoxSigner actuallyUsedBy = null;
    private static SunPKCS11 provider = null;
    private char[] pin;
    private static boolean passwordInitialized = false;
    private boolean ignoreProvider = false;

    public FirefoxSigner(String cfgFile, String providerDesc) throws SignatureException {
        if (configFile == null) {
            configFile = cfgFile;
        }
        this.setProviderName("FIREFOX " + providerDesc);
        FirefoxSigner.setActuallyUsedBy(this);
    }

    public void certifyDigitalCopy(InputStream contentStream, OutputStream signedStream, String certificateName, String password, String contentType, boolean recognized, String url, String localidad, float x, float y, float rotation, SignaturaProperties properties) throws IOException, SignatureException {
        Object parsed = null;
        try {
            KeyStore ks = this.getKeyStore();
            String alias = this.getAliasFromCN(certificateName, recognized);
            X509Certificate[] certs = this.getCertChainFromAlias(alias);
            try {
                PrivateKey privateKey = (PrivateKey)ks.getKey(alias, password.toCharArray());
                if (privateKey == null) {
                    throw new SignatureException("Private key not found for alias " + alias);
                }
                PDFSigner.certifyDigitalCopy((InputStream)contentStream, (OutputStream)signedStream, (PrivateKey)privateKey, (X509Certificate[])certs, (String)url, (String)localidad, (float)x, (float)y, (float)rotation, (SignaturaProperties)properties, (String)provider.getName());
                return;
            }
            catch (UnrecoverableKeyException e) {
                e.printStackTrace();
                throw new SignatureException("Clave incorrecta", (Throwable)e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SignatureException("Error generando firma", (Throwable)e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException(parsed != null ? parsed.getCommonName() + ":[FIREFOXSIGNER]: " + e.getMessage() : e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
    }

    public Date getCurrentDate(String certificateName, String password, boolean recognized) throws SignatureTimestampException, SignatureException, IOException {
        TimeStampManager tsm = new TimeStampManager();
        try {
            String alias = this.getAliasFromCN(certificateName, recognized);
            X509Certificate[] certs = this.getCertChainFromAlias(alias);
            return tsm.getTimeStamp(certs[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SignatureException(e.getMessage(), e.getCause());
        }
        catch (TSPException e) {
            e.printStackTrace();
            throw new SignatureException(e.getMessage(), e.getCause());
        }
    }

    public String getVersion() {
        return "1.0";
    }

    public Signature sign(InputStream contentStream, String certificateName, String password, String contentType, boolean recognized, boolean timeStamp, boolean rawSign) throws IOException, SignatureException {
        Object parsed = null;
        try {
            KeyStore ks = this.getKeyStore();
            String alias = this.getAliasFromCN(certificateName, recognized);
            X509Certificate[] certs = this.getCertChainFromAlias(alias);
            try {
                PrivateKey privateKey = (PrivateKey)ks.getKey(alias, null);
                if (privateKey == null) {
                    throw new SignatureException("Private key not found for alias " + alias);
                }
                return this.generate(privateKey, certs, contentType, contentStream, timeStamp, rawSign);
            }
            catch (UnrecoverableKeyException e) {
                e.printStackTrace();
                throw new SignatureException("Clave incorrecta", (Throwable)e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SignatureException("Error generando firma", (Throwable)e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException(parsed != null ? parsed.getCommonName() + ":[FIREFOXSIGNER]: " + e.getMessage() : e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
    }

    public void signPDF(InputStream contentStream, OutputStream signedStream, String certificateName, String password, String contentType, boolean recognized, String url, int position, boolean allowMultipleSignature) throws IOException, SignatureException {
        Object parsed = null;
        try {
            KeyStore ks = this.getKeyStore();
            String alias = this.getAliasFromCN(certificateName, recognized);
            X509Certificate[] certs = this.getCertChainFromAlias(alias);
            try {
                PrivateKey privateKey = (PrivateKey)ks.getKey(alias, null);
                if (privateKey == null) {
                    throw new SignatureException("Private key not found for alias " + alias);
                }
                PDFSigner.sign((InputStream)contentStream, (OutputStream)signedStream, (PrivateKey)privateKey, (X509Certificate[])certs, (String)url, (int)position, (boolean)allowMultipleSignature, (String)provider.getName());
                return;
            }
            catch (UnrecoverableKeyException e) {
                e.printStackTrace();
                throw new SignatureException("Clave incorrecta", (Throwable)e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SignatureException("Error generando firma", (Throwable)e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException(parsed != null ? parsed.getCommonName() + ":[FIREFOXSIGNER]: " + e.getMessage() : e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
    }

    public void signPDF(InputStream pdfInputStream, OutputStream signedStream, String certificateName, String password, String contentType, boolean recognized, String textoAdicional, int stampOptions, float top, float left, float height, float width, float rotation, boolean allowMultipleSignature) throws IOException, SignatureException {
        Object parsed = null;
        try {
            KeyStore ks = this.getKeyStore();
            String alias = this.getAliasFromCN(certificateName, recognized);
            X509Certificate[] certs = this.getCertChainFromAlias(alias);
            try {
                PrivateKey privateKey = (PrivateKey)ks.getKey(alias, null);
                if (privateKey == null) {
                    throw new SignatureException("Private key not found for alias " + alias);
                }
                PDFSigner.sign((InputStream)pdfInputStream, (OutputStream)signedStream, (PrivateKey)privateKey, (X509Certificate[])certs, (String)textoAdicional, (int)stampOptions, (float)top, (float)left, (float)height, (float)width, (float)rotation, (boolean)allowMultipleSignature, (String)provider.getName());
                return;
            }
            catch (UnrecoverableKeyException e) {
                e.printStackTrace();
                throw new SignatureException("Clave incorrecta", (Throwable)e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SignatureException("Error generando firma", (Throwable)e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException(parsed != null ? parsed.getCommonName() + ":[FIREFOXSIGNER]: " + e.getMessage() : e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new SignatureCertNotFoundException((Exception)e);
        }
    }

    protected String[] getAliases() throws SignatureProviderException {
        Enumeration<String> enumeration = null;
        try {
            KeyStore ks = this.getKeyStore();
            if (ks != null) {
                enumeration = ks.aliases();
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new SignatureProviderException(e.getMessage(), e.getCause());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new SignatureProviderException(e.getMessage(), e.getCause());
        }
        catch (CertificateException e) {
            e.printStackTrace();
            throw new SignatureProviderException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SignatureProviderException(e.getMessage(), e.getCause());
        }
        Vector<String> out = new Vector<String>();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            out.add(alias);
        }
        return out.toArray(new String[out.size()]);
    }

    protected X509Certificate[] getCertChainFromAlias(String alias) throws SignatureProviderException {
        X509Certificate[] certs = null;
        try {
            KeyStore ks = this.getKeyStore();
            if (ks != null) {
                certs = (X509Certificate[])ks.getCertificateChain(alias);
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new SignatureProviderException(e.getMessage(), e.getCause());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new SignatureProviderException(e.getMessage(), e.getCause());
        }
        catch (CertificateException e) {
            e.printStackTrace();
            throw new SignatureProviderException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SignatureProviderException(e.getMessage(), e.getCause());
        }
        return certs;
    }

    protected void initialize() throws SignatureProviderException {
    }

    protected boolean isInSecureDevice(String alias) {
        return passwordInitialized;
    }

    private SunPKCS11 getProvider() {
        if (provider == null) {
            ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(configFile.getBytes());
            provider = new SunPKCS11((InputStream)localByteArrayInputStream);
            Security.addProvider(provider);
        }
        return provider;
    }

    private KeyStore getKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = null;
        if (!this.ignoreProvider) {
            if (this.pin == null) {
                try {
                    ks = this.getKeyStore(null);
                    if (!passwordInitialized) {
                        System.out.println("No password provided to load keystore " + this.providerName);
                    }
                    return ks;
                }
                catch (IOException e) {
                    if (e.getCause() instanceof LoginException) {
                        return this.askForPin();
                    }
                    throw e;
                }
                catch (KeyStoreException e) {
                    if (e.getCause() instanceof LoginException) {
                        return this.askForPin();
                    }
                    this.disposeProvider();
                    throw e;
                }
            }
            try {
                return this.getKeyStore(this.pin);
            }
            catch (KeyStoreException e) {
                this.disposeProvider();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.getKeyStore();
            }
        }
        return null;
    }

    private KeyStore getKeyStore(char[] pinToUse) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("PKCS11", this.getProvider());
            ks.load(null, pinToUse);
        }
        catch (ProviderException e) {
            throw new KeyStoreException("Unable to get KeyStore: " + this.providerName, e);
        }
        return ks;
    }

    private KeyStore askForPin() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        char[] newPin = PinDialog.getPIN(this.providerName.substring(this.providerName.lastIndexOf(".") + 1));
        if (newPin == null) {
            this.ignoreProvider = true;
        }
        try {
            KeyStore ks = this.getKeyStore(newPin);
            this.pin = newPin;
            passwordInitialized = true;
            return ks;
        }
        catch (IOException e2) {
            if (e2.getCause() instanceof LoginException) {
                JOptionPane.showMessageDialog(null, "PIN incorrecto para el perfil de FIREFOX", "Perfil de Firefox " + this.providerName, 2);
            }
            throw e2;
        }
    }

    protected void finalize() {
        this.closeSession();
    }

    private void disposeProvider() {
        if (FirefoxSigner.getActuallyUsedBy() == this) {
            this.pin = null;
            this.closeSession();
        }
    }

    private void closeSession() {
        if (FirefoxSigner.getActuallyUsedBy() == this) {
            try {
                if (provider != null) {
                    provider.logout();
                    passwordInitialized = false;
                    configFile = null;
                    provider = null;
                    FirefoxSigner.setActuallyUsedBy(null);
                }
            }
            catch (LoginException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private AttributeTable getSignedAttributes(X509Certificate cert) throws Exception {
        try {
            byte[] encodedCert = cert.getEncoded();
            ByteArrayInputStream baInputStream = new ByteArrayInputStream(encodedCert);
            MessageDigest digester = MessageDigest.getInstance("SHA-1", "BC");
            DigestInputStream diInputStream = new DigestInputStream(baInputStream, digester);
            byte[] digestResult = null;
            byte[] b = new byte[8192];
            int read = diInputStream.read(b);
            while (read > 0) {
                read = diInputStream.read(b);
            }
            diInputStream.close();
            baInputStream.close();
            digestResult = digester.digest();
            GeneralName generalName = new GeneralName(new X509Name(cert.getIssuerX500Principal().getName()));
            GeneralNames generalNames = new GeneralNames(generalName);
            BigInteger serialNumber = cert.getSerialNumber();
            IssuerSerial issuerSerial = new IssuerSerial(generalNames, new DERInteger(serialNumber.intValue()));
            ESSCertID essCertID = new ESSCertID(digestResult, issuerSerial);
            SigningCertificate signingCertificate = new SigningCertificate(essCertID);
            Hashtable<String, Attribute> table = new Hashtable<String, Attribute>();
            Attribute att = new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.16.2.12"), (ASN1Set)new DERSet((DEREncodable)signingCertificate));
            table.put("signingCertificate", att);
            return new AttributeTable(table);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private AttributeTable getUnsignedAttributes(X509Certificate cert) {
        return new AttributeTable(new Hashtable());
    }

    private Signature generate(PrivateKey key, X509Certificate[] certs, String contentType, InputStream stream, boolean timeStamp, boolean raw) throws Exception {
        try {
            TimeStampManager tsm;
            CMSSignedData signedDataTimestamp;
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            AttributeTable signedAttributes = this.getSignedAttributes(certs[0]);
            AttributeTable unsignedAttributes = this.getUnsignedAttributes(certs[0]);
            gen.addSigner(key, certs[0], CMSSignedDataGenerator.DIGEST_SHA1, signedAttributes, unsignedAttributes);
            Vector<X509Certificate> v = new Vector<X509Certificate>();
            for (int i = 0; i < certs.length; ++i) {
                v.add(certs[i]);
            }
            CollectionCertStoreParameters param = new CollectionCertStoreParameters(v);
            CertStore certStore = CertStore.getInstance("Collection", param);
            gen.addCertificatesAndCRLs(certStore);
            ProcessableInputStream in = raw ? new ProcessableInputStream(stream) : new ProcessableInputStream((InputStream)new MIMEInputStream(stream, contentType));
            CMSSignedData signedData = gen.generate((CMSProcessable)in, this.getProvider().getName());
            if (timeStamp && (signedDataTimestamp = (tsm = new TimeStampManager()).addTimestamp(certs[0], signedData)) != null) {
                signedData = signedDataTimestamp;
            }
            if (raw) {
                return new CMSSignatureRawv2(signedData.getEncoded(), contentType);
            }
            return new CMSSignaturev2(signedData.getEncoded(), contentType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected static synchronized FirefoxSigner getActuallyUsedBy() {
        return actuallyUsedBy;
    }

    protected static synchronized void setActuallyUsedBy(FirefoxSigner actuallyUsedBy) {
        FirefoxSigner.actuallyUsedBy = actuallyUsedBy;
    }

    class ProcessableInputStream
    implements CMSProcessable {
        private DigestInputStream in;
        MessageDigest digester = MessageDigest.getInstance("SHA-1", "BC");
        byte[] digestResult;

        public void write(OutputStream out) throws IOException, CMSException {
            byte[] b = new byte[8192];
            int read = this.in.read(b);
            while (read > 0) {
                out.write(b, 0, read);
                read = this.in.read(b);
            }
            out.close();
            this.in.close();
            this.digestResult = this.digester.digest();
        }

        public Object getContent() {
            return this.in;
        }

        public ProcessableInputStream(InputStream datain) throws NoSuchAlgorithmException, NoSuchProviderException {
            this.in = new DigestInputStream(datain, this.digester);
            this.digestResult = null;
        }

        public byte[] getDigest() {
            return this.digestResult;
        }
    }
}

