/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.core;

import es.caib.signatura.test.core.DynamicQueryResolver;
import es.caib.signatura.test.core.Execution;
import es.caib.signatura.test.core.ExecutionData;
import es.caib.signatura.test.core.ExecutionView;
import es.caib.signatura.test.core.RemoteExecutionVerificationRequest;
import es.caib.signatura.test.core.SynchronizableBoolean;
import es.caib.signatura.test.privileged.utils.SignatureTestUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExecutionDirector {
    public static final String ACTION_START_EXECUTIONS = "start-executions";
    public static final String ACTION_SHOW_RESULTS = "show-results";
    public static final String ACTION_EXPORT_RESULTS = "export-results";
    public static final String ACTION_DESTROY = "destroy";
    private Vector executions = new Vector();
    private ExecutionView view = null;
    private String config = null;
    private String configURL = null;
    private Map executionMap = new Hashtable();
    private SynchronizableBoolean loopQueryActions = new SynchronizableBoolean(true);
    private Map globalVariables = new Hashtable();
    private String monitorServletURL = "";

    public void start() {
        this.setUp();
        while (this.loopQueryActions.get()) {
            String action = this.view.queryActions();
            this.changeExecutionsStatus(1);
            this.performInternalAction(action);
        }
    }

    private void changeExecutionsStatus(int statusConfigured) {
        Iterator it = this.executions.iterator();
        while (it.hasNext()) {
            Execution execution = (Execution)it.next();
            execution.setStatus(statusConfigured, this.getGlobalVariables());
        }
    }

    protected void performInternalAction(String action) {
        if (ACTION_START_EXECUTIONS.equals(action)) {
            this.runExecutions();
            this.view.onFinalizeExecutions();
        } else if (ACTION_SHOW_RESULTS.equals(action)) {
            this.view.updateResults(this.executions);
        } else if (ACTION_DESTROY.equals(action)) {
            this.loopQueryActions.set(false);
            this.view.closeView();
        } else if (ACTION_EXPORT_RESULTS.equals(action)) {
            String export = this.exportResults();
            this.view.exportResults(export);
        }
    }

    protected String exportResults() {
        StringBuffer export = new StringBuffer();
        export.append("Arq|SO|JRE|Nom|Descripci\u00f3|Class|Resultat|Verificaci\u00f3\n");
        Iterator it = this.executions.iterator();
        int i = 0;
        while (it.hasNext()) {
            Execution ex = (Execution)it.next();
            if (!ex.isActive()) continue;
            export.append(System.getProperty("os.arch"));
            export.append('|');
            export.append(System.getProperty("os.name"));
            export.append('|');
            export.append(System.getProperty("java.version"));
            export.append('|');
            export.append(ex.getName());
            export.append('|');
            export.append(ex.getDescription());
            export.append('|');
            export.append(ex.getClass());
            export.append('|');
            if (ex.getVerificationResult() == null) {
                int result = ex.verify(this.getGlobalVariables());
                ex.setVerificationResult(new Integer(result));
            }
            if (ex.getVerificationResult() != -2) {
                if (ex.getVerificationResult() == -1) {
                    try {
                        String downloadURL = this.uploadExecutionResultFile(ex.getResult(), ex.getName(), ex.getResultContentType());
                        export.append(downloadURL);
                    }
                    catch (Exception e) {
                        this.view.notifyFatal(e.getMessage(), e);
                    }
                } else if (ex.getResult() != null) {
                    export.append(ex.getResult().toString());
                }
            } else {
                try {
                    ex.setVerificationResult(new Integer(this.executeRemoteVerification(ex)));
                }
                catch (Exception e) {
                    this.view.notifyFatal(e.getMessage(), e);
                }
            }
            export.append('|');
            export.append(ex.getVerificationResult());
            export.append('\n');
            ++i;
        }
        return export.toString();
    }

    protected void runExecutions() {
        Iterator it = this.executions.iterator();
        while (it.hasNext()) {
            Execution execution = (Execution)it.next();
            if (!execution.isActive()) continue;
            try {
                execution.setStatus(2, this.getGlobalVariables());
                PrintStream oldOut = System.out;
                PrintStream oldErr = System.err;
                SignatureTestUtils.setOut((PrintStream)execution.getOut());
                SignatureTestUtils.setErr((PrintStream)execution.getErr());
                execution.execute(this.getGlobalVariables());
                SignatureTestUtils.setOut((PrintStream)oldOut);
                SignatureTestUtils.setErr((PrintStream)oldErr);
                System.out.println(new String(execution.getOutStreamBytes().toByteArray()));
                System.err.println(new String(execution.getErrStreamBytes().toByteArray()));
                execution.setStatus(3, this.getGlobalVariables());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.view.notifyFatal(e.getMessage(), e);
            }
        }
    }

    protected void setUp() {
        if (this.view == null) {
            this.view.notifyFatal("No view configured", new Exception("No view configured"));
        }
        try {
            this.parseXML(this.config);
            this.view.showAvailableExecutions(this.executions);
            this.changeExecutionsStatus(0);
            this.executions = this.view.queryUserExecutionsConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.view.notifyFatal(e.getMessage(), e);
        }
    }

    protected void parseXML(String xml) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
        Document doc = builder.parse(bis);
        bis.close();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        this.parseGlobalOptions(doc);
        ArrayList outList = new ArrayList();
        NodeList stagesNodeList = (NodeList)xpath.evaluate("/executions/execution", doc, XPathConstants.NODESET);
        if (stagesNodeList != null) {
            for (int i = 0; i < stagesNodeList.getLength(); ++i) {
                Execution stage = ExecutionDirector.parse(stagesNodeList.item(i));
                ExecutionData stageData = stage.parseData(this, stagesNodeList.item(i));
                stage.setData(stageData);
                this.executions.add(stage);
                if (stage.getName() == null) {
                    throw new SAXException("execution/@name is mandatory");
                }
                this.executionMap.put(stage.getName(), stage);
            }
        }
    }

    private void parseGlobalOptions(Document doc) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NodeList globals = (NodeList)xpath.evaluate("./executions/global", doc, XPathConstants.NODESET);
        for (int i = 1; i <= globals.getLength(); ++i) {
            String name = (String)xpath.evaluate("./executions/global[" + i + "]/@name", doc, XPathConstants.STRING);
            String value = (String)xpath.evaluate("./executions/global[" + i + "]/text()", doc, XPathConstants.STRING);
            this.globalVariables.put(name, DynamicQueryResolver.resolveString(value, this.globalVariables));
        }
    }

    public static Execution parse(Node item) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String _name = item.getAttributes().getNamedItem("name").getNodeValue();
        String _tipus = item.getAttributes().getNamedItem("type") != null ? item.getAttributes().getNamedItem("type").getNodeValue() : null;
        String _description = (String)xpath.evaluate("./description", item, XPathConstants.STRING);
        if (_tipus == null) {
            throw new SAXException("atribute \"type\" not defined for node " + _name);
        }
        Class<?> stageTipusClass = Execution.class.getClassLoader().loadClass(_tipus);
        Constructor<?> constructor = stageTipusClass.getDeclaredConstructor(String.class, String.class);
        Execution instance = (Execution)constructor.newInstance(_name, _description);
        return instance;
    }

    public String uploadExecutionResultFile(Object in, String executionName, String resultContentType) throws Exception {
        String uploadServlet = this.getMonitorServletURL().replace("ResultsCollectorServlet", "UploadServlet");
        String downloadServlet = this.getMonitorServletURL().replace("ResultsCollectorServlet", "DownloadServlet");
        URL uploadServletURL = new URL(uploadServlet);
        HttpURLConnection c = (HttpURLConnection)uploadServletURL.openConnection();
        c.setRequestProperty("configFilePath", this.getConfigURL());
        c.setRequestProperty("executionName", executionName);
        c.setDoInput(true);
        c.setDoOutput(true);
        c.setRequestMethod("POST");
        c.setRequestProperty("content-type", resultContentType);
        c.connect();
        ObjectOutputStream o = new ObjectOutputStream(c.getOutputStream());
        o.writeObject(in);
        o.close();
        String response = this.readInputStream(c.getInputStream());
        c.disconnect();
        return downloadServlet + "/" + response;
    }

    private int executeRemoteVerification(Execution ex) throws Exception {
        String remoteVerificationServlet = this.getMonitorServletURL().replace("ResultsCollectorServlet", "RemoteVerificationServlet");
        URL uploadServletURL = new URL(remoteVerificationServlet);
        RemoteExecutionVerificationRequest verificationReq = new RemoteExecutionVerificationRequest(ex, this.getGlobalVariables());
        HttpURLConnection c = (HttpURLConnection)uploadServletURL.openConnection();
        c.setDoInput(true);
        c.setDoOutput(true);
        c.setRequestMethod("POST");
        c.connect();
        ObjectOutputStream o = new ObjectOutputStream(c.getOutputStream());
        o.writeObject(verificationReq);
        o.flush();
        o.close();
        String response = this.readInputStream(c.getInputStream());
        c.disconnect();
        if (c.getResponseCode() != 200) {
            return 0;
        }
        return Integer.parseInt(response);
    }

    private String readInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(inputStream);
        byte[] b = new byte[8192];
        int read = 0;
        while ((read = in.read(b)) > 0) {
            out.write(b, 0, read);
        }
        in.close();
        return out.toString("UTF-8");
    }

    public synchronized ExecutionView getView() {
        return this.view;
    }

    public synchronized void setView(ExecutionView view) {
        this.view = view;
    }

    public synchronized String getConfig() {
        return this.config;
    }

    public synchronized void setConfigURL(String configFileURL) {
        this.configURL = configFileURL;
        String conf = null;
        try {
            URL f = new URL(configFileURL);
            InputStream in = f.openStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int r = 0;
            while ((r = in.read(buf)) != -1) {
                out.write(buf, 0, r);
            }
            conf = new String(out.toByteArray(), "UTF-8");
            String encodingtag = conf.substring(conf.indexOf("encoding"), conf.indexOf("?>"));
            String encoding = encodingtag.substring(encodingtag.indexOf("\"") + 1, encodingtag.lastIndexOf("\""));
            conf = new String(out.toByteArray(), encoding);
        }
        catch (Exception e) {
            this.view.notifyFatal("Error! " + e.getMessage(), e);
            return;
        }
        this.config = conf;
    }

    public synchronized Vector getExecutions() {
        return this.executions;
    }

    public synchronized Map getExecutionMap() {
        return this.executionMap;
    }

    public synchronized Map getGlobalVariables() {
        Hashtable o = new Hashtable();
        o.putAll(this.globalVariables);
        return o;
    }

    public synchronized void setGlobalVariables(Map globalVariables) {
        this.globalVariables = globalVariables;
    }

    public synchronized String getMonitorServletURL() {
        return this.monitorServletURL;
    }

    public synchronized void setMonitorServletURL(String monitorServletURL) {
        this.monitorServletURL = monitorServletURL;
    }

    public synchronized String getConfigURL() {
        return this.configURL;
    }
}

