/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.test.core;

import es.caib.signatura.test.core.Pipe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessHelper {
    private Process proc = null;
    private OutputStream out = System.out;
    private InputStream in = System.in;
    private OutputStream err = System.err;
    private RedirectorThread t1;
    private RedirectorThread t2;
    private RedirectorThread t3;

    private synchronized int redirectAndWait() {
        this.t1 = new RedirectorThread(this.proc, "out", this.proc.getInputStream(), this.out);
        this.t2 = new RedirectorThread(this.proc, "in", this.in, this.proc.getOutputStream());
        this.t3 = new RedirectorThread(this.proc, "err", this.proc.getErrorStream(), this.err);
        int ret = -1;
        try {
            this.t3.start();
            this.t2.start();
            this.t1.start();
            ret = this.proc.waitFor();
            this.t1.unpipe();
            this.t2.unpipe();
            this.t3.unpipe();
            this.t1.stop();
            this.t1 = null;
            this.t2.stop();
            this.t2 = null;
            this.t3.stop();
            this.t3 = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public synchronized int runAndWait(String[] command) {
        Runtime run = Runtime.getRuntime();
        try {
            this.proc = run.exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        return this.redirectAndWait();
    }

    public synchronized int runAndWait(String[] command, String[] environment) {
        Runtime run = Runtime.getRuntime();
        try {
            this.proc = run.exec(command, environment);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        return this.redirectAndWait();
    }

    public InputStream getIn() {
        return this.in;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public Process getProc() {
        return this.proc;
    }

    public void setProc(Process proc) {
        this.proc = proc;
    }

    public OutputStream getErr() {
        return this.err;
    }

    public void setErr(OutputStream err) {
        this.err = err;
    }

    private class RedirectorThread
    extends Thread {
        private Process proc = null;
        private String debug_name;
        private InputStream inputStream;
        private OutputStream outputStream;
        private Pipe p;

        public RedirectorThread(Process p_proc, String p_debug_name, InputStream p_inputStream, OutputStream p_outputStream) {
            this.proc = p_proc;
            this.debug_name = p_debug_name;
            this.inputStream = p_inputStream;
            this.outputStream = p_outputStream;
        }

        public void run() {
            this.p = new Pipe(this.debug_name, this.inputStream, this.outputStream);
            this.p.run();
        }

        public void unpipe() {
            this.p.unpipe();
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public String getDebugName() {
            return this.debug_name;
        }

        public void setDebugName(String name) {
            this.debug_name = name;
        }

        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        public void setOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public Process getProc() {
            return this.proc;
        }

        public void setProc(Process proc) {
            this.proc = proc;
        }
    }
}

